/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.netbeans.modules.cnd.utils.cache.TinyTwoValuesMap;

class TinyArrayMap<K, V>
implements Map<K, V> {
    private final Object[] keyValues;
    private int size;

    public TinyArrayMap(int capacity) {
        this.keyValues = new Object[capacity * 2];
        this.size = 0;
    }

    TinyArrayMap(TinyTwoValuesMap<K, V> twoValues, int capacity) {
        assert (capacity >= 2);
        this.keyValues = new Object[capacity * 2];
        this.size = twoValues.size();
        int index = 0;
        this.keyValues[index++] = twoValues.getFirstKey();
        this.keyValues[index++] = twoValues.getFirstValue();
        this.keyValues[index++] = twoValues.getSecondKey();
        this.keyValues[index] = twoValues.getSecondValue();
    }

    TinyArrayMap(TinyArrayMap<K, V> prev, int capacity) {
        assert (prev.keyValues.length <= capacity * 2);
        this.keyValues = new Object[capacity * 2];
        System.arraycopy(prev.keyValues, 0, this.keyValues, 0, prev.keyValues.length);
        this.size = prev.size;
    }

    TinyArrayMap(int capacity, Map<K, V> map) {
        this.size = map.size();
        assert (this.size <= capacity);
        this.keyValues = new Object[capacity * 2];
        int index = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.keyValues[index++] = entry.getKey();
            this.keyValues[index++] = entry.getValue();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object aKey) {
        assert (aKey != null);
        int index = this.indexForKey(aKey);
        if (index >= 0) {
            return this.keyValues[index] != null;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object aValue) {
        assert (aValue != null);
        for (int i = 1; i < this.keyValues.length; ++i) {
            Object val;
            if ((val = this.keyValues[i++]) == null || !val.equals(aValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object aKey) {
        assert (aKey != null);
        int index = this.indexForKey(aKey);
        if (index >= 0) {
            Object val = this.keyValues[index + 1];
            return (V)val;
        }
        return null;
    }

    @Override
    public V put(K aKey, V aValue) {
        assert (aKey != null);
        int index = this.indexForKey(aKey);
        if (index >= 0) {
            Object key = this.keyValues[index];
            if (key == null) {
                assert ((this.size + 1) * 2 <= this.keyValues.length);
                ++this.size;
                this.keyValues[index] = aKey;
                assert (this.keyValues[index + 1] == null);
            }
            Object prev = this.keyValues[index + 1];
            this.keyValues[index + 1] = aValue;
            return (V)prev;
        }
        assert (this.size * 2 == this.keyValues.length) : "trying to put " + this.size + " in " + this.keyValues.length;
        assert (false) : "this map can not contain more than " + this.size;
        return null;
    }

    private int indexForKey(Object aKey) {
        assert (aKey != null);
        int freeCell = -1;
        for (int i = 0; i < this.keyValues.length; i += 2) {
            Object key = this.keyValues[i];
            if (key == null) {
                freeCell = i;
                assert (this.keyValues[i + 1] == null);
                continue;
            }
            if (!key.equals(aKey)) continue;
            return i;
        }
        return freeCell;
    }

    @Override
    public V remove(Object aKey) {
        assert (aKey != null);
        int index = this.indexForKey(aKey);
        if (index >= 0 && this.keyValues[index] != null) {
            --this.size;
            this.keyValues[index] = null;
            Object prev = this.keyValues[index + 1];
            this.keyValues[index + 1] = null;
            return (V)prev;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.size = 0;
        for (int i = 0; i < this.keyValues.length; ++i) {
            this.keyValues[i] = null;
        }
    }

    @Override
    public Set<K> keySet() {
        HashSet<Object> keys = new HashSet<Object>(this.size);
        for (int i = 0; i < this.keyValues.length; i += 2) {
            Object key = this.keyValues[i];
            if (key == null) continue;
            keys.add(key);
        }
        return keys;
    }

    @Override
    public Collection<V> values() {
        ArrayList<Object> values = new ArrayList<Object>(this.size);
        for (int i = 0; i < this.keyValues.length; i += 2) {
            Object key = this.keyValues[i];
            if (key == null) continue;
            Object val = this.keyValues[i + 1];
            values.add(val);
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.size == 0) {
            return Collections.emptySet();
        }
        return new Set<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return TinyArrayMap.this.size;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private byte index = 0;
                    private byte counter = 0;

                    @Override
                    public boolean hasNext() {
                        return this.counter < TinyArrayMap.this.size;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (this.counter < TinyArrayMap.this.size) {
                            while (this.index < TinyArrayMap.this.keyValues.length && TinyArrayMap.this.keyValues[this.index] == null) {
                                this.index = (byte)(this.index + 2);
                            }
                            assert (this.index < TinyArrayMap.this.keyValues.length - 1);
                            final byte entryIndex = this.index;
                            this.counter = (byte)(this.counter + 1);
                            this.index = (byte)(this.index + 2);
                            return new Map.Entry<K, V>(){

                                @Override
                                public K getKey() {
                                    return TinyArrayMap.this.keyValues[entryIndex];
                                }

                                @Override
                                public V getValue() {
                                    return TinyArrayMap.this.keyValues[entryIndex + 1];
                                }

                                @Override
                                public V setValue(V value) {
                                    Object res = TinyArrayMap.this.keyValues[entryIndex + 1];
                                    ((TinyArrayMap)TinyArrayMap.this).keyValues[entryIndex + 1] = value;
                                    return res;
                                }
                            };
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                };
            }

            @Override
            public boolean contains(Object o) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public <T> T[] toArray(T[] a) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean add(Map.Entry<K, V> o) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }
}

