/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.parser.impl;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.parser.CppFoldRecord;
import org.netbeans.modules.cnd.editor.parser.impl.CommentTokenFilter;
import org.netbeans.modules.cnd.editor.parser.impl.FolderException;
import org.netbeans.modules.cnd.editor.parser.impl.PreprocessorFilter;
import org.netbeans.modules.cnd.editor.parser.impl.TokenFilter;
import org.openide.filesystems.FileObject;

public class FoldingParserImpl {
    private final List<CppFoldRecord> parserFolders = new ArrayList<CppFoldRecord>();
    private final List<TokenFilter> filters;
    private final TokenSequence<CppTokenId> ts;
    private static final boolean reportErrors = Boolean.getBoolean("folding.parser.report.errors");
    private boolean matchError = false;
    private Exception matchException = defaultException;
    public static final Exception defaultException = new Exception("Exceptions turned off, so you are unable to see error description here");
    protected static final boolean throwRecExceptions = false;

    public FoldingParserImpl(TokenSequence<CppTokenId> ts) {
        this.ts = ts;
        this.filters = new ArrayList<TokenFilter>();
    }

    private void createFolder(int folderKind, Token<CppTokenId> begin, Token<CppTokenId> end) {
        this.parserFolders.add(new CppFoldRecord(folderKind, begin.offset(null), end.offset(null) + end.length()));
    }

    protected List<CppFoldRecord> getFolders() {
        ArrayList<CppFoldRecord> out = new ArrayList<CppFoldRecord>(this.parserFolders.size());
        for (TokenFilter filter : this.filters) {
            out.addAll(filter.getFolders());
        }
        out.addAll(this.parserFolders);
        return out;
    }

    private static FoldingParserImpl getParser(TokenSequence ts) {
        FoldingParserImpl parser = new FoldingParserImpl((TokenSequence<CppTokenId>)ts);
        return parser;
    }

    public static List<CppFoldRecord> parse(FileObject fo, TokenSequence ts) {
        try {
            FoldingParserImpl parser = FoldingParserImpl.getParser(ts);
            parser.filters.clear();
            parser.filters.add(new CommentTokenFilter());
            parser.filters.add(new PreprocessorFilter(ts));
            parser.translation_unit();
            return new ArrayList<CppFoldRecord>(parser.getFolders());
        }
        catch (Exception e) {
            if (reportErrors) {
                System.err.println("exception: " + e);
                e.printStackTrace(System.err);
            }
            return null;
        }
    }

    public void reportError(Exception e) {
        if (reportErrors) {
            System.err.println("exception: " + e);
            e.printStackTrace(System.err);
        }
    }

    protected final void balanceParens() {
        assert (this.LA(0) == CppTokenId.LPAREN);
        this.balanceBracket(CppTokenId.LPAREN, CppTokenId.RPAREN);
        assert (this.matchError || this.LA(1) == CppTokenId.RPAREN);
    }

    protected final void balanceCurlies() {
        assert (this.LA(0) == CppTokenId.LBRACE);
        this.balanceBracket(CppTokenId.LBRACE, CppTokenId.RBRACE);
        assert (this.matchError || this.LA(1) == CppTokenId.RBRACE);
    }

    protected final void balanceTemplateParams() {
        assert (this.LA(0) == CppTokenId.LT);
        this.balanceBracket(CppTokenId.LT, CppTokenId.GT);
        assert (this.matchError || this.LA(1) == CppTokenId.GT);
    }

    protected final void balanceCurliesAndCreateFolders(int folderType, int level, boolean foldCurrent) {
        if (this.LA(0) != CppTokenId.LBRACE) {
            this.matchError = true;
            return;
        }
        CppTokenId startType = CppTokenId.LBRACE;
        CppTokenId endType = CppTokenId.RBRACE;
        Token<CppTokenId> startToken = this.LT(0);
        CppTokenId LA1 = this.LA(1);
        while (LA1 != CppTokenId.EOF) {
            if (LA1 == endType) {
                Token<CppTokenId> endToken = this.LT(1);
                if (!foldCurrent) break;
                this.createFolder(folderType, startToken, endToken);
                break;
            }
            if (LA1 == startType) {
                this.moveNext();
                this.balanceCurliesAndCreateFolders(folderType, level + 1, true);
            } else {
                this.moveNext();
            }
            LA1 = this.LA(1);
        }
        this.match((TokenId)CppTokenId.RBRACE);
    }

    private void balanceBracket(CppTokenId startType, CppTokenId endType) {
        int level = 0;
        CppTokenId LA1 = this.LA(1);
        while (LA1 != CppTokenId.EOF) {
            if (LA1 == endType) {
                if (level <= 0) break;
                --level;
            } else if (LA1 == startType) {
                ++level;
            }
            this.moveNext();
            LA1 = this.LA(1);
        }
        if (level != 0 || LA1 == CppTokenId.EOF) {
            this.matchError = true;
            this.matchException = new Exception("unbalanced bracket " + startType.name());
        }
    }

    protected final void createCurlyFolder(int folderKind) {
        Token<CppTokenId> begin = this.LT(1);
        this.match((TokenId)CppTokenId.LBRACE);
        if (!this.matchError) {
            this.balanceCurlies();
            if (!this.matchError) {
                Token<CppTokenId> end = this.LT(1);
                this.match((TokenId)CppTokenId.RBRACE);
                if (!this.matchError) {
                    this.createFolder(folderKind, begin, end);
                }
            }
        }
        if (this.matchError) {
            this.reportError(this.matchException);
            this.resetMatchError();
        }
    }

    public final void translation_unit() {
        this.external_declarations();
        if (!this.matchError && this.moveNext()) {
            this.matchError = true;
            this.matchException = new Exception("EOF should be reached here: " + this.ts.token());
        }
        if (this.matchError) {
            this.reportError(this.matchException);
            this.resetMatchError();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected final void external_declarations() {
        block5: while (true) {
            LA1 = this.LA(1);
            LA2 = this.LA(2);
            switch (1.$SwitchMap$org$netbeans$cnd$api$lexer$CppTokenId[LA1.ordinal()]) {
                case 1: {
                    this.match((TokenId)CppTokenId.RBRACE);
                    break block5;
                }
                case 2: {
                    break block5;
                }
                case 3: {
                    if (LA2 == CppTokenId.STRING_LITERAL) {
                        this.linkage_specification();
                        if (!this.matchError) continue block5;
                        break block5;
                    }
                }
                default: {
                    if (this.LA(1) == CppTokenId.EOF) {
                        this.matchError = true;
                        this.matchException = new FolderException("EOF unexpected", this.LT(1));
                        continue block5;
                    }
                    this.declaration();
                    if (this.matchError) ** break;
                    continue block5;
                    break block5;
                }
            }
            break;
        }
        if (this.matchError) {
            this.reportError(this.matchException);
            this.resetMatchError();
        }
    }

    protected final void linkage_specification() {
        block8: {
            this.match((TokenId)CppTokenId.EXTERN);
            if (!this.matchError) {
                this.match((TokenId)CppTokenId.STRING_LITERAL);
                if (!this.matchError) {
                    CppTokenId LA1 = this.LA(1);
                    CppTokenId LA2 = this.LA(2);
                    if (LA1 == CppTokenId.LBRACE) {
                        Token<CppTokenId> begin = this.LT(1);
                        this.moveNext();
                        while (this.LA(1) != CppTokenId.RBRACE && this.LA(1) != CppTokenId.EOF) {
                            this.external_declarations();
                            if (!this.matchError) continue;
                            break block8;
                        }
                        Token<CppTokenId> end = this.LT(1);
                        this.match((TokenId)CppTokenId.RBRACE);
                        if (!this.matchError) {
                            this.createFolder(6, begin, end);
                        }
                    } else if (LA1 != CppTokenId.EOF) {
                        this.external_declarations();
                    }
                }
            }
        }
        if (this.matchError) {
            this.reportError(this.matchException);
            this.resetMatchError();
        }
    }

    private void eat2Token(CppTokenId type, boolean checkLeftCurly, boolean checkRightCurly) {
        CppTokenId LA1;
        while (!((LA1 = this.LA(1)) == type || checkLeftCurly && LA1 == CppTokenId.LBRACE || checkRightCurly && LA1 == CppTokenId.RBRACE)) {
            this.matchNot((TokenId)CppTokenId.EOF);
            if (!this.matchError) continue;
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void eatDeclPrefix() {
        block4: while (true) {
            switch (this.LA(1)) {
                case EXTERN: 
                case STRUCT: 
                case TYPEDEF: {
                    this.moveNext();
                    continue block4;
                }
                case TEMPLATE: {
                    this.moveNext();
                    if (this.LA(1) != CppTokenId.LT) continue block4;
                    this.moveNext();
                    this.balanceTemplateParams();
                    if (this.matchError) return;
                    this.match((TokenId)CppTokenId.GT);
                    if (this.matchError) return;
                    continue block4;
                }
                default: {
                    return;
                }
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void declaration() {
        this.eatDeclPrefix();
        if (!this.matchError) {
            boolean ns = false;
            CppTokenId LA1 = this.LA(1);
            block0 : switch (LA1) {
                case RBRACE: {
                    break;
                }
                case ENUM: {
                    this.moveNext();
                    if (this.LA(1) == CppTokenId.IDENTIFIER) {
                        this.moveNext();
                    }
                    this.createCurlyFolder(6);
                    if (this.matchError) break;
                    this.eat2Token(CppTokenId.SEMICOLON, true, true);
                    if (this.LA(1) == CppTokenId.SEMICOLON) {
                        this.moveNext();
                    }
                    if (!this.matchError) break;
                    break;
                }
                case NAMESPACE: {
                    ns = true;
                }
                case STRUCT: 
                case CLASS: 
                case UNION: {
                    this.moveNext();
                    this.eat2Token(CppTokenId.SEMICOLON, true, false);
                    if (this.matchError) break;
                    if (this.LA(1) == CppTokenId.LBRACE) {
                        this.declarationsFold(ns ? 10 : 6);
                        if (this.matchError) break;
                    }
                    if (!ns) {
                        this.eat2Token(CppTokenId.SEMICOLON, true, true);
                    }
                    if (this.LA(1) == CppTokenId.SEMICOLON) {
                        this.moveNext();
                    }
                    if (!this.matchError) break;
                    break;
                }
                default: {
                    this.eat2Token(CppTokenId.SEMICOLON, true, true);
                    if (this.matchError) break;
                    switch (this.LA(1)) {
                        case LBRACE: {
                            this.blockFold(7);
                            if (!this.matchError) break;
                            break block0;
                        }
                        case RBRACE: {
                            break block0;
                        }
                    }
                    if (this.LA(1) != CppTokenId.SEMICOLON) break;
                    this.moveNext();
                }
            }
        }
        if (this.matchError) {
            this.reportError(this.matchException);
            this.resetMatchError();
        }
    }

    protected final void declarationsFold(int folderKind) {
        block4: {
            Token<CppTokenId> begin = this.LT(1);
            this.match((TokenId)CppTokenId.LBRACE);
            if (!this.matchError) {
                while (this.LA(1) != CppTokenId.RBRACE && this.LA(1) != CppTokenId.EOF) {
                    this.declaration();
                    if (!this.matchError) continue;
                    break block4;
                }
                Token<CppTokenId> end = this.LT(1);
                this.match((TokenId)CppTokenId.RBRACE);
                if (!this.matchError) {
                    this.createFolder(folderKind, begin, end);
                }
            }
        }
        if (this.matchError) {
            this.reportError(this.matchException);
            this.resetMatchError();
        }
    }

    protected final void blockFold(int foldType) {
        block6: {
            Token<CppTokenId> begin = this.LT(1);
            this.match((TokenId)CppTokenId.LBRACE);
            if (!this.matchError) {
                while (this.LA(0) != CppTokenId.RBRACE) {
                    if (this.LA(1) == CppTokenId.RBRACE) {
                        this.moveNext();
                        break;
                    }
                    if (this.LA(1) == CppTokenId.EOF) break;
                    this.balanceCurliesAndCreateFolders(11, 0, false);
                    if (!this.matchError) continue;
                    break block6;
                }
                Token<CppTokenId> end = this.LT(0);
                if (this.LA(0) != CppTokenId.RBRACE) {
                    this.matchError = true;
                } else {
                    this.createFolder(foldType, begin, end);
                }
            }
        }
        if (this.matchError) {
            this.reportError(this.matchException);
            this.resetMatchError();
        }
    }

    private CppTokenId LA(int lookahead) {
        assert (lookahead >= 0);
        int index = this.ts.index();
        boolean between = this.ts.token() == null;
        boolean eof = false;
        while (lookahead > 0) {
            if (!this.moveNext(true)) {
                eof = true;
                break;
            }
            --lookahead;
        }
        CppTokenId id = eof ? CppTokenId.EOF : (CppTokenId)this.ts.token().id();
        this.ts.moveIndex(index);
        if (!between) {
            this.ts.moveNext();
        }
        return id;
    }

    private Token<CppTokenId> LT(int lookahead) {
        assert (lookahead >= 0);
        int index = this.ts.index();
        boolean between = this.ts.token() == null;
        boolean eof = false;
        while (lookahead > 0 && this.moveNext(true)) {
            --lookahead;
        }
        Token token = eof ? null : this.ts.offsetToken();
        this.ts.moveIndex(index);
        if (!between) {
            this.ts.moveNext();
        }
        return token;
    }

    private void match(TokenId id) {
        if (this.LA(1) == id) {
            this.moveNext();
        } else {
            this.matchError = true;
        }
    }

    public void matchNot(TokenId id) {
        if (this.LA(1) != id) {
            this.moveNext();
        } else {
            this.matchError = true;
        }
    }

    private boolean moveNext() {
        return this.moveNext(false);
    }

    private boolean moveNext(boolean lookahead) {
        int index = this.ts.index();
        boolean between = this.ts.token() == null;
        do {
            boolean moved = this.ts.moveNext();
            CppTokenId id = null;
            if (moved) {
                id = (CppTokenId)this.ts.token().id();
            }
            if (!moved) {
                if (!lookahead) {
                    this.visitEof();
                }
                this.ts.moveIndex(index);
                if (!between) {
                    this.ts.moveNext();
                }
                return false;
            }
            if (lookahead) continue;
            this.visit((Token<CppTokenId>)this.ts.token());
        } while (this.consume((Token<CppTokenId>)this.ts.token()));
        return true;
    }

    private void visit(Token<CppTokenId> token) {
        for (TokenFilter filter : this.filters) {
            filter.visit(token);
        }
    }

    private void visitEof() {
        for (TokenFilter filter : this.filters) {
            filter.visitEof();
        }
    }

    private boolean consume(Token<CppTokenId> token) {
        boolean consumed = false;
        for (TokenFilter filter : this.filters) {
            consumed |= filter.consumes((CppTokenId)token.id());
        }
        return consumed;
    }

    public void resetMatchError() {
        this.matchError = false;
        this.matchException = defaultException;
    }
}

