/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder.exec;

import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.modules.maven.embedder.exec.Bundle;
import org.openide.util.Cancellable;
import org.sonatype.aether.transfer.TransferCancelledException;
import org.sonatype.aether.transfer.TransferEvent;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.transfer.TransferResource;

public class ProgressTransferListener
implements TransferListener {
    private static final ThreadLocal<ProgressTransferListener> activeListener = new ThreadLocal<ProgressTransferListener>(){

        @Override
        protected ProgressTransferListener initialValue() {
            return new ProgressTransferListener();
        }
    };
    private int length;
    private ProgressContributor contrib;
    private ProgressContributor pomcontrib;
    private int pomCount;
    private final Stack<ProgressContributor> contribStack = new Stack();
    private AggregateProgressHandle handle;
    public AtomicBoolean cancel;
    private static final int POM_MAX = 20;

    private ProgressTransferListener() {
    }

    public static ProgressTransferListener activeListener() {
        return activeListener.get();
    }

    public static void setAggregateHandle(AggregateProgressHandle hndl) {
        ProgressTransferListener ptl = ProgressTransferListener.activeListener();
        ptl.handle = hndl;
        ProgressContributor pc = AggregateProgressFactory.createProgressContributor((String)"Pom files");
        hndl.addContributor(pc);
        pc.start(20);
        ptl.pomcontrib = pc;
    }

    public static void clearAggregateHandle() {
        activeListener.remove();
    }

    public static Cancellable cancellable() {
        AtomicBoolean b;
        ProgressTransferListener.activeListener().cancel = b = new AtomicBoolean();
        return new Cancellable(){

            public boolean cancel() {
                return b.compareAndSet(false, true);
            }
        };
    }

    private void checkCancel() {
        if (this.cancel != null && this.cancel.get()) {
            throw new ThreadDeath();
        }
    }

    private String getResourceName(TransferResource res) {
        int lastSlash = res.getResourceName().lastIndexOf(47);
        return lastSlash > -1 ? res.getResourceName().substring(lastSlash + 1) : res.getResourceName();
    }

    public void transferInitiated(TransferEvent te) throws TransferCancelledException {
        if (this.handle == null) {
            return;
        }
        TransferResource res = te.getResource();
        String resName = this.getResourceName(res);
        if (!resName.endsWith(".pom")) {
            ProgressContributor pc;
            ProgressContributor progressContributor = pc = !this.contribStack.empty() ? this.contribStack.pop() : null;
            if (pc == null) {
                String name = te.getRequestType() == TransferEvent.RequestType.GET ? Bundle.TXT_Download(resName) : Bundle.TXT_Uploading(resName);
                pc = AggregateProgressFactory.createProgressContributor((String)name);
                this.handle.addContributor(pc);
            }
            this.contrib = pc;
        } else {
            String name = te.getRequestType() == TransferEvent.RequestType.GET ? Bundle.TXT_Download(resName) : Bundle.TXT_Uploading(resName);
            ProgressContributor pc = AggregateProgressFactory.createProgressContributor((String)name);
            this.contribStack.add(pc);
            this.handle.addContributor(pc);
            if (this.pomCount < 19) {
                this.pomcontrib.progress(Bundle.TXT_Started(resName), ++this.pomCount);
            } else {
                this.pomcontrib.progress(Bundle.TXT_Started(resName));
            }
        }
    }

    public void transferStarted(TransferEvent te) throws TransferCancelledException {
        ProgressContributor c = this.contrib;
        if (c == null || this.handle == null) {
            return;
        }
        TransferResource res = te.getResource();
        int total = (int)Math.min(Integer.MAX_VALUE, res.getContentLength());
        if (total < 0) {
            c.start(0);
        } else {
            c.start(total);
        }
        this.length = total;
        c.progress(Bundle.TXT_Started(this.getResourceName(res)));
    }

    public void transferProgressed(TransferEvent te) throws TransferCancelledException {
        this.checkCancel();
        ProgressContributor c = this.contrib;
        if (c == null) {
            return;
        }
        long cnt = te.getTransferredBytes();
        cnt = Math.min(Integer.MAX_VALUE, cnt);
        if (this.length < 0) {
            c.progress(Bundle.TXT_Transferring(this.getResourceName(te.getResource())));
        } else {
            cnt = Math.min(cnt, (long)this.length);
            c.progress(Bundle.TXT_Transferred(this.getResourceName(te.getResource()), cnt), (int)cnt);
        }
    }

    public void transferCorrupted(TransferEvent te) throws TransferCancelledException {
        ProgressContributor c = this.contrib;
        this.contrib = null;
        if (c != null) {
            c.finish();
        }
    }

    public void transferSucceeded(TransferEvent te) {
        ProgressContributor c = this.contrib;
        this.contrib = null;
        if (c != null) {
            c.finish();
        }
    }

    public void transferFailed(TransferEvent te) {
        ProgressContributor c = this.contrib;
        this.contrib = null;
        if (c != null) {
            c.finish();
        }
    }
}

