/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.config;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public class KVFile {
    private Map<Key, byte[]> map;
    private Map<String, Key> keyMap;
    private final VCSFileProxy file;

    public KVFile(VCSFileProxy file) {
        this.file = file;
        try {
            if (file.exists()) {
                this.parse();
            }
        }
        catch (IOException ex) {
            Subversion.LOG.log(Level.INFO, null, ex);
        }
    }

    protected byte[] getValue(Key key) {
        return this.getMap().get(key);
    }

    protected String getStringValue(Key key) {
        try {
            byte[] value = this.getValue(key);
            if (value == null) {
                return null;
            }
            return new String(value, "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            Subversion.LOG.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    protected void setValue(Key key, byte[] value) {
        this.getMap().put(key, value);
    }

    private Map<Key, byte[]> getMap() {
        if (this.map == null) {
            this.map = new TreeMap<Key, byte[]>();
        }
        return this.map;
    }

    public Map<String, byte[]> getNormalizedMap() {
        Map<Key, byte[]> keyValue = this.getMap();
        HashMap<String, byte[]> stringValue = new HashMap<String, byte[]>(keyValue.size());
        for (Map.Entry<Key, byte[]> next : keyValue.entrySet()) {
            stringValue.put(next.getKey().toString(), next.getValue());
        }
        return stringValue;
    }

    private Map<String, Key> getKeyMap() {
        if (this.keyMap == null) {
            this.keyMap = new HashMap<String, Key>();
        }
        return this.keyMap;
    }

    protected Key getKey(Key key) {
        Key storedKey = this.getKey(key.getName());
        if (storedKey == null) {
            this.setKey(key);
            return key;
        }
        return storedKey;
    }

    private Key getKey(String name) {
        return this.getKeyMap().get(name);
    }

    protected void setKey(Key key) {
        this.getKeyMap().put(key.getName(), key);
    }

    private void parse() throws IOException {
        InputStream is = null;
        try {
            is = new BufferedInputStream(this.file.getInputStream(false));
            int keyIdx = 0;
            while (!this.checkEOF(is)) {
                int keyLength = this.readEntryLength(is);
                byte[] keyName = new byte[keyLength];
                is.read(keyName);
                is.read();
                int valueLength = this.readEntryLength(is);
                byte[] value = new byte[valueLength];
                is.read(value);
                Key key = new Key(keyIdx, new String(keyName, "UTF8"));
                this.setKey(key);
                this.getMap().put(key, value);
                is.read();
                ++keyIdx;
            }
        }
        catch (EOFException eofe) {
            if (this.getMap().size() > 0) {
                throw new EOFException(this.file.getPath());
            }
        }
        catch (NumberFormatException nfe) {
            throw new IOException(this.file.getPath(), nfe);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                Subversion.LOG.log(Level.INFO, null, e);
            }
        }
    }

    private boolean checkEOF(InputStream is) throws IOException {
        is.mark(3);
        byte[] end = new byte[3];
        is.read(end);
        is.reset();
        if (end[0] == -1 || end[1] == -1 || end[2] == -1) {
            throw new EOFException();
        }
        return end[0] == 69 && end[1] == 78 && end[2] == 68;
    }

    private int readEntryLength(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte b = (byte)is.read();
        while (b != 10) {
            if (b == -1) {
                throw new EOFException();
            }
            baos.write(b);
            b = (byte)is.read();
        }
        String line = baos.toString("UTF-8");
        return Integer.decode(line.substring(2));
    }

    public void store() throws IOException {
        this.store(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(VCSFileProxy file) throws IOException {
        OutputStream os = null;
        try {
            VCSFileProxy parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                VCSFileProxySupport.mkdirs((VCSFileProxy)parent);
            }
            os = VCSFileProxySupport.getOutputStream((VCSFileProxy)file);
            for (Key key : this.getMap().keySet()) {
                byte[] value = this.getMap().get(key);
                StringBuffer sb = new StringBuffer();
                sb.append("K ");
                sb.append(key.getName().length());
                sb.append("\n");
                sb.append(key.getName());
                sb.append("\n");
                sb.append("V ");
                sb.append(value.length);
                sb.append("\n");
                os.write(sb.toString().getBytes("UTF8"));
                os.write(value);
                os.write("\n".getBytes("UTF8"));
            }
            os.write("END\n".getBytes("UTF8"));
            os.flush();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    Subversion.LOG.log(Level.INFO, null, ex);
                }
            }
        }
    }

    protected VCSFileProxy getFile() {
        return this.file;
    }

    @SuppressWarnings(value={"Dm"})
    void setValue(Key key, String value) {
        try {
            this.setValue(key, value.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            this.setValue(key, value.getBytes());
        }
    }

    protected static class Key
    implements Comparable<Key> {
        private final int idx;
        private final String name;

        protected Key(int idx, String name) {
            this.name = name;
            this.idx = idx;
        }

        public int getIndex() {
            return this.idx;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            return key.getIndex() == this.getIndex() && key.getName().equals(this.getName());
        }

        public int hashCode() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getName());
            sb.append(this.getIndex());
            return sb.toString().hashCode();
        }

        @Override
        public int compareTo(Key key) {
            if (key.getIndex() < this.getIndex()) {
                return 1;
            }
            if (key.getIndex() > this.getIndex()) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return this.name;
        }
    }
}

