/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

public final class RoutingToken {
    private static final int SUBSYSTEM_MASK = 255;
    private static final int SUBSYSTEM_SHIFT = 8;
    private int id;
    public static final int BROADCAST_TOKEN = 0;
    private static int nextTokenNumber = 1;
    public static final RoutingToken BREAKPOINTS = new RoutingToken(1);
    public static final RoutingToken DISPLAY_ITEM_MANAGER = new RoutingToken(2);
    public static final RoutingToken TREETABLE = new RoutingToken(3);
    public static final RoutingToken WATCH = new RoutingToken(4);
    public static final RoutingToken VAR = new RoutingToken(5);
    public static final RoutingToken WATCHES = new RoutingToken(6);

    private RoutingToken(int id) {
        this.id = id;
    }

    public final int getAsInt() {
        return this.id;
    }

    public final RoutingToken getBroadcastRoutingToken() {
        return new RoutingToken(0 | this.getSubsystemId());
    }

    private final int getSubsystemId() {
        return this.id & 0xFF;
    }

    private static final int getSubsystemId(int id) {
        return id & 0xFF;
    }

    public final int getUniqueId() {
        return this.id >> 8;
    }

    public static final int getUniqueId(int routingId) {
        return routingId >> 8;
    }

    public synchronized RoutingToken getUniqueRoutingToken() {
        return new RoutingToken(nextTokenNumber++ << 8 | this.getSubsystemId());
    }

    public synchronized int getUniqueRoutingTokenInt() {
        return nextTokenNumber++ << 8 | this.getSubsystemId();
    }

    public final boolean isSameSubsystem(RoutingToken routingToken) {
        return routingToken.getSubsystemId() == this.getSubsystemId();
    }

    public final boolean isSameSubsystem(int routingToken) {
        return RoutingToken.getSubsystemId(routingToken) == RoutingToken.getSubsystemId(this.id);
    }

    public final boolean isTargetOf(int routingToken) {
        return routingToken == 0 || RoutingToken.getUniqueId(routingToken) == 0 && this.isSameSubsystem(routingToken) || this.id == routingToken;
    }

    public static final String toString(int id) {
        String uniqueId = RoutingToken.getUniqueId(id) == 0 ? "BROADCAST" : Integer.toString(RoutingToken.getUniqueId(id));
        String systemId = "";
        if (BREAKPOINTS.isSameSubsystem(id)) {
            systemId = "BREAKPOINTS";
        }
        systemId = WATCHES.isSameSubsystem(id) ? "WATCHES" : (DISPLAY_ITEM_MANAGER.isSameSubsystem(id) ? "DIM" : (TREETABLE.isSameSubsystem(id) ? "TREETABLE" : (WATCH.isSameSubsystem(id) ? "WATCH" : (VAR.isSameSubsystem(id) ? "VAR" : Integer.toString(RoutingToken.getSubsystemId(id))))));
        return "RoutingToken[" + uniqueId + "/" + systemId + "]";
    }

    public final String toString() {
        return RoutingToken.toString(this.id);
    }
}

