/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails.settings;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.groovy.grails.api.GrailsEnvironment;
import org.openide.util.Exceptions;
import org.openide.util.NbCollections;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public final class GrailsSettings {
    public static final String GRAILS_BASE_PROPERTY = "grailsBase";
    private static final String GRAILS_HOME_KEY = "grailsHome";
    private static final String GRAILS_PORT_KEY = "grailsPrj-Port-";
    private static final String GRAILS_ENV_KEY = "grailsPrj-Env-";
    private static final String GRAILS_JAVA_PLATFORM_KEY = "grailsPrj-JavaPlatform-";
    private static final String GRAILS_VM_OPTIONS_KEY = "grailsPrj-VmOptions-";
    private static final String GRAILS_DEBUG_BROWSER_KEY = "grailsPrj-DebugBrowser-";
    private static final String GRAILS_DISPLAY_BROWSER_KEY = "grailsPrj-DisplayBrowser-";
    private static final String GRAILS_PROJECT_PLUGINS_DIR_KEY = "grailsPrj-ProjectPluginsDir-";
    private static final String GRAILS_GLOBAL_PLUGINS_DIR_KEY = "grailsPrj-GlobalPluginsDir-";
    private static final String GRAILS_LOCAL_PLUGINS_KEY = "grailsPrj-LocalPlugins-";
    private static GrailsSettings instance;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private GrailsSettings() {
    }

    public static synchronized GrailsSettings getInstance() {
        if (instance == null) {
            instance = new GrailsSettings();
        }
        return instance;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGrailsBase() {
        String base = null;
        GrailsSettings grailsSettings = this;
        synchronized (grailsSettings) {
            base = this.getPreferences().get(GRAILS_HOME_KEY, null);
        }
        if (base == null || base.length() <= 0) {
            base = this.findGroovyPlatform();
        }
        return base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGrailsBase(String path) {
        String oldValue;
        GrailsSettings grailsSettings = this;
        synchronized (grailsSettings) {
            oldValue = this.getGrailsBase();
            this.getPreferences().put(GRAILS_HOME_KEY, path);
        }
        this.propertyChangeSupport.firePropertyChange(GRAILS_BASE_PROPERTY, oldValue, path);
    }

    public String getPortForProject(Project prj) {
        assert (prj != null);
        return this.getPreferences().get(this.getPortKey(prj), null);
    }

    public void setPortForProject(Project prj, String port) {
        assert (prj != null);
        assert (port != null);
        this.getPreferences().put(this.getPortKey(prj), port);
    }

    public String getVmOptionsForProject(Project prj) {
        assert (prj != null);
        return this.getPreferences().get(this.getVmOptionsKey(prj), null);
    }

    public void setVmOptionsForProject(Project prj, String options) {
        assert (prj != null);
        assert (options != null);
        this.getPreferences().put(this.getVmOptionsKey(prj), options);
    }

    public GrailsEnvironment getEnvForProject(Project prj) {
        assert (prj != null);
        String value = this.getPreferences().get(this.getEnvKey(prj), null);
        if (value != null) {
            return GrailsEnvironment.valueOf(value);
        }
        return null;
    }

    public void setEnvForProject(Project prj, GrailsEnvironment env) {
        assert (prj != null);
        assert (env != null);
        this.getPreferences().put(this.getEnvKey(prj), env.toString());
    }

    public String getDebugBrowserForProject(Project prj) {
        assert (prj != null);
        return this.getPreferences().get(this.getDebugBrowserKey(prj), null);
    }

    public void setDebugBrowserProject(Project prj, String browser) {
        assert (prj != null);
        assert (browser != null);
        this.getPreferences().put(this.getDebugBrowserKey(prj), browser);
    }

    public String getJavaPlatformForProject(Project prj) {
        assert (prj != null);
        return this.getPreferences().get(this.getJavaPlatformKey(prj), null);
    }

    public void setJavaPlatformForProject(Project prj, String platformId) {
        assert (prj != null);
        assert (platformId != null);
        this.getPreferences().put(this.getJavaPlatformKey(prj), platformId);
    }

    public boolean getDisplayBrowserForProject(Project prj) {
        assert (prj != null);
        return this.getPreferences().getBoolean(this.getDisplayBrowserKey(prj), true);
    }

    public void setDisplayBrowserForProject(Project prj, boolean displayBrowser) {
        assert (prj != null);
        this.getPreferences().putBoolean(this.getDisplayBrowserKey(prj), displayBrowser);
    }

    public String getProjectPluginsDirForProject(Project prj) {
        assert (prj != null);
        return this.getPreferences().get(this.getProjectPluginsDirKey(prj), null);
    }

    public void setProjectPluginsDirForProject(Project prj, String dir) {
        assert (prj != null);
        this.getPreferences().put(this.getProjectPluginsDirKey(prj), dir);
    }

    public String getGlobalPluginsDirForProject(Project prj) {
        assert (prj != null);
        return this.getPreferences().get(this.getGlobalPluginsDirKey(prj), null);
    }

    public void setGlobalPluginsDirForProject(Project prj, String dir) {
        assert (prj != null);
        this.getPreferences().put(this.getGlobalPluginsDirKey(prj), dir);
    }

    public Map<String, String> getLocalPluginsForProject(Project prj) {
        assert (prj != null);
        Preferences prefs = this.getPreferences();
        Preferences subPrefs = prefs.node(this.getLocalPluginsKey(prj));
        HashMap<String, String> ret = new HashMap<String, String>();
        try {
            for (String name : subPrefs.keys()) {
                String value = subPrefs.get(name, null);
                if (value == null) continue;
                ret.put(name, value);
            }
        }
        catch (BackingStoreException ex) {
            return Collections.emptyMap();
        }
        return ret;
    }

    public void setLocalPluginsForProject(Project prj, Map<String, String> plugins) {
        assert (prj != null);
        Preferences prefs = this.getPreferences();
        Preferences subPrefs = prefs.node(this.getLocalPluginsKey(prj));
        Set<String> keys = null;
        try {
            keys = new HashSet<String>(Arrays.asList(subPrefs.keys()));
        }
        catch (BackingStoreException ex) {
            keys = Collections.emptySet();
        }
        for (Map.Entry<String, String> entry : plugins.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            subPrefs.put(entry.getKey(), entry.getValue());
            keys.remove(entry.getKey());
        }
        for (String key : keys) {
            subPrefs.remove(key);
        }
    }

    private String getProjectName(Project prj) {
        assert (prj != null);
        ProjectInformation info = (ProjectInformation)prj.getLookup().lookup(ProjectInformation.class);
        assert (info != null);
        return info.getName();
    }

    private String getPortKey(Project prj) {
        assert (prj != null);
        return GRAILS_PORT_KEY + this.getProjectName(prj);
    }

    private String getVmOptionsKey(Project prj) {
        assert (prj != null);
        return GRAILS_VM_OPTIONS_KEY + this.getProjectName(prj);
    }

    private String getEnvKey(Project prj) {
        assert (prj != null);
        return GRAILS_ENV_KEY + this.getProjectName(prj);
    }

    private String getDebugBrowserKey(Project prj) {
        assert (prj != null);
        return GRAILS_DEBUG_BROWSER_KEY + this.getProjectName(prj);
    }

    private String getJavaPlatformKey(Project prj) {
        assert (prj != null);
        return GRAILS_JAVA_PLATFORM_KEY + this.getProjectName(prj);
    }

    private String getDisplayBrowserKey(Project prj) {
        assert (prj != null);
        return GRAILS_DISPLAY_BROWSER_KEY + this.getProjectName(prj);
    }

    private String getProjectPluginsDirKey(Project prj) {
        assert (prj != null);
        return GRAILS_PROJECT_PLUGINS_DIR_KEY + this.getProjectName(prj);
    }

    private String getGlobalPluginsDirKey(Project prj) {
        assert (prj != null);
        return GRAILS_GLOBAL_PLUGINS_DIR_KEY + this.getProjectName(prj);
    }

    private String getLocalPluginsKey(Project prj) {
        assert (prj != null);
        return GRAILS_LOCAL_PLUGINS_KEY + this.getProjectName(prj);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(GrailsSettings.class);
    }

    private String findGroovyPlatform() {
        String groovyPath = System.getenv("GRAILS_HOME");
        if (groovyPath == null) {
            for (String dir : GrailsSettings.dirsOnPath()) {
                File f = null;
                f = Utilities.isWindows() ? new File(dir, "grails.bat") : new File(dir, "grails");
                if (!f.isFile()) continue;
                try {
                    groovyPath = f.getCanonicalFile().getParentFile().getParent();
                    break;
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        }
        return groovyPath;
    }

    private static Iterable<String> dirsOnPath() {
        String rawPath = System.getenv("PATH");
        if (rawPath == null) {
            rawPath = System.getenv("Path");
        }
        if (rawPath == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> candidates = new LinkedHashSet<String>(Arrays.asList(rawPath.split(File.pathSeparator)));
        Iterator it = candidates.iterator();
        while (it.hasNext()) {
            String dir = (String)it.next();
            if (new File(dir).isDirectory()) continue;
            it.remove();
        }
        return NbCollections.iterable(candidates.iterator());
    }
}

