/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.Annotation;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.Descriptor;
import com.sun.tools.classfile.TypeAnnotation;
import com.sun.tools.javap.BasicWriter;
import com.sun.tools.javap.ClassWriter;
import com.sun.tools.javap.ConstantWriter;
import com.sun.tools.javap.Context;

public class AnnotationWriter
extends BasicWriter {
    element_value_Writer ev_writer = new element_value_Writer();
    private ClassWriter classWriter;
    private ConstantWriter constantWriter;

    static AnnotationWriter instance(Context context) {
        AnnotationWriter instance = context.get(AnnotationWriter.class);
        if (instance == null) {
            instance = new AnnotationWriter(context);
        }
        return instance;
    }

    protected AnnotationWriter(Context context) {
        super(context);
        this.classWriter = ClassWriter.instance(context);
        this.constantWriter = ConstantWriter.instance(context);
    }

    public void write(Annotation annot) {
        this.write(annot, false);
    }

    public void write(Annotation annot, boolean resolveIndices) {
        boolean showParens;
        this.writeDescriptor(annot.type_index, resolveIndices);
        boolean bl = showParens = annot.num_element_value_pairs > 0 || !resolveIndices;
        if (showParens) {
            this.print("(");
        }
        for (int i = 0; i < annot.num_element_value_pairs; ++i) {
            if (i > 0) {
                this.print(",");
            }
            this.write(annot.element_value_pairs[i], resolveIndices);
        }
        if (showParens) {
            this.print(")");
        }
    }

    public void write(TypeAnnotation annot) {
        this.write(annot, true, false);
    }

    public void write(TypeAnnotation annot, boolean showOffsets, boolean resolveIndices) {
        this.write(annot.annotation, resolveIndices);
        this.print(": ");
        this.write(annot.position, showOffsets);
    }

    public void write(TypeAnnotation.Position pos, boolean showOffsets) {
        this.print((Object)pos.type);
        switch (pos.type) {
            case INSTANCEOF: 
            case NEW: 
            case CONSTRUCTOR_REFERENCE: 
            case METHOD_REFERENCE: {
                if (!showOffsets) break;
                this.print(", offset=");
                this.print(pos.offset);
                break;
            }
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: {
                if (pos.lvarOffset == null) {
                    this.print(", lvarOffset is Null!");
                    break;
                }
                this.print(", {");
                for (int i = 0; i < pos.lvarOffset.length; ++i) {
                    if (i != 0) {
                        this.print("; ");
                    }
                    if (showOffsets) {
                        this.print("start_pc=");
                        this.print(pos.lvarOffset[i]);
                    }
                    this.print(", length=");
                    this.print(pos.lvarLength[i]);
                    this.print(", index=");
                    this.print(pos.lvarIndex[i]);
                }
                this.print("}");
                break;
            }
            case EXCEPTION_PARAMETER: {
                this.print(", exception_index=");
                this.print(pos.exception_index);
                break;
            }
            case METHOD_RECEIVER: {
                break;
            }
            case CLASS_TYPE_PARAMETER: 
            case METHOD_TYPE_PARAMETER: {
                this.print(", param_index=");
                this.print(pos.parameter_index);
                break;
            }
            case CLASS_TYPE_PARAMETER_BOUND: 
            case METHOD_TYPE_PARAMETER_BOUND: {
                this.print(", param_index=");
                this.print(pos.parameter_index);
                this.print(", bound_index=");
                this.print(pos.bound_index);
                break;
            }
            case CLASS_EXTENDS: {
                this.print(", type_index=");
                this.print(pos.type_index);
                break;
            }
            case THROWS: {
                this.print(", type_index=");
                this.print(pos.type_index);
                break;
            }
            case METHOD_FORMAL_PARAMETER: {
                this.print(", param_index=");
                this.print(pos.parameter_index);
                break;
            }
            case CAST: 
            case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
            case METHOD_INVOCATION_TYPE_ARGUMENT: 
            case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: 
            case METHOD_REFERENCE_TYPE_ARGUMENT: {
                if (showOffsets) {
                    this.print(", offset=");
                    this.print(pos.offset);
                }
                this.print(", type_index=");
                this.print(pos.type_index);
                break;
            }
            case METHOD_RETURN: 
            case FIELD: {
                break;
            }
            case UNKNOWN: {
                throw new AssertionError((Object)"AnnotationWriter: UNKNOWN target type should never occur!");
            }
            default: {
                throw new AssertionError((Object)("AnnotationWriter: Unknown target type for position: " + pos));
            }
        }
        if (!pos.location.isEmpty()) {
            this.print(", location=");
            this.print(pos.location);
        }
    }

    public void write(Annotation.element_value_pair pair) {
        this.write(pair, false);
    }

    public void write(Annotation.element_value_pair pair, boolean resolveIndices) {
        this.writeIndex(pair.element_name_index, resolveIndices);
        this.print("=");
        this.write(pair.value, resolveIndices);
    }

    public void write(Annotation.element_value value) {
        this.write(value, false);
    }

    public void write(Annotation.element_value value, boolean resolveIndices) {
        this.ev_writer.write(value, resolveIndices);
    }

    private void writeDescriptor(int index, boolean resolveIndices) {
        if (resolveIndices) {
            try {
                ConstantPool constant_pool = this.classWriter.getClassFile().constant_pool;
                Descriptor d = new Descriptor(index);
                this.print(d.getFieldType(constant_pool));
                return;
            }
            catch (ConstantPoolException | Descriptor.InvalidDescriptor exception) {
                // empty catch block
            }
        }
        this.print("#" + index);
    }

    private void writeIndex(int index, boolean resolveIndices) {
        if (resolveIndices) {
            this.print(this.constantWriter.stringValue(index));
        } else {
            this.print("#" + index);
        }
    }

    class element_value_Writer
    implements Annotation.element_value.Visitor<Void, Boolean> {
        element_value_Writer() {
        }

        public void write(Annotation.element_value value, boolean resolveIndices) {
            value.accept(this, resolveIndices);
        }

        @Override
        public Void visitPrimitive(Annotation.Primitive_element_value ev, Boolean resolveIndices) {
            if (resolveIndices.booleanValue()) {
                AnnotationWriter.this.writeIndex(ev.const_value_index, resolveIndices);
            } else {
                AnnotationWriter.this.print((char)ev.tag + "#" + ev.const_value_index);
            }
            return null;
        }

        @Override
        public Void visitEnum(Annotation.Enum_element_value ev, Boolean resolveIndices) {
            if (resolveIndices.booleanValue()) {
                AnnotationWriter.this.writeIndex(ev.type_name_index, resolveIndices);
                AnnotationWriter.this.print(".");
                AnnotationWriter.this.writeIndex(ev.const_name_index, resolveIndices);
            } else {
                AnnotationWriter.this.print((char)ev.tag + "#" + ev.type_name_index + ".#" + ev.const_name_index);
            }
            return null;
        }

        @Override
        public Void visitClass(Annotation.Class_element_value ev, Boolean resolveIndices) {
            if (resolveIndices.booleanValue()) {
                AnnotationWriter.this.writeIndex(ev.class_info_index, resolveIndices);
                AnnotationWriter.this.print(".class");
            } else {
                AnnotationWriter.this.print((char)ev.tag + "#" + ev.class_info_index);
            }
            return null;
        }

        @Override
        public Void visitAnnotation(Annotation.Annotation_element_value ev, Boolean resolveIndices) {
            AnnotationWriter.this.print(Character.valueOf((char)ev.tag));
            AnnotationWriter.this.write(ev.annotation_value, (boolean)resolveIndices);
            return null;
        }

        @Override
        public Void visitArray(Annotation.Array_element_value ev, Boolean resolveIndices) {
            AnnotationWriter.this.print("[");
            for (int i = 0; i < ev.num_values; ++i) {
                if (i > 0) {
                    AnnotationWriter.this.print(",");
                }
                this.write(ev.values[i], resolveIndices);
            }
            AnnotationWriter.this.print("]");
            return null;
        }
    }
}

