/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Parameters;

public class ClasspathUtil {
    private static final Logger LOGGER = Logger.getLogger(ClasspathUtil.class.getName());

    public static boolean containsClass(List<URL> classPath, String className) throws IOException {
        Parameters.notNull((CharSequence)"classpath", classPath);
        Parameters.notNull((CharSequence)"className", (Object)className);
        ArrayList<File> diskFiles = new ArrayList<File>();
        for (URL url : classPath) {
            File diskFile;
            URL localURL;
            FileObject fo;
            URL archiveURL = FileUtil.getArchiveFile((URL)url);
            if (archiveURL != null) {
                url = archiveURL;
            }
            if ("nbinst".equals(url.getProtocol()) && (fo = URLMapper.findFileObject((URL)url)) != null && (localURL = URLMapper.findURL((FileObject)fo, (int)1)) != null) {
                url = localURL;
            }
            if ((fo = URLMapper.findFileObject((URL)url)) == null || (diskFile = FileUtil.toFile((FileObject)fo)) == null) continue;
            diskFiles.add(diskFile);
        }
        return ClasspathUtil.containsClass(diskFiles, className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsClass(Collection<File> classpath, String className) throws IOException {
        Parameters.notNull((CharSequence)"classpath", classpath);
        Parameters.notNull((CharSequence)"driverClassName", (Object)className);
        String classFilePath = className.replace('.', '/') + ".class";
        for (File file : classpath) {
            if (file.isFile()) {
                JarInputStream is = new JarInputStream((InputStream)new BufferedInputStream(new FileInputStream(file)), false);
                try {
                    JarEntry entry;
                    while ((entry = is.getNextJarEntry()) != null) {
                        if (!classFilePath.equals(entry.getName())) continue;
                        boolean bl = true;
                        return bl;
                    }
                    continue;
                }
                finally {
                    is.close();
                    continue;
                }
            }
            if (!new File(file, classFilePath).exists()) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    public static <T> T containsClass(@NonNull List<URL> classPath, @NonNull Map<T, String> classNames) throws IOException {
        Parameters.notNull((CharSequence)"classpath", classPath);
        Parameters.notNull((CharSequence)"className", classNames);
        if (classNames.isEmpty()) {
            throw new IllegalArgumentException("classNames can't be empty");
        }
        ArrayList<File> diskFiles = new ArrayList<File>();
        for (URL url : classPath) {
            File diskFile;
            URL localURL;
            FileObject fo;
            URL archiveURL = FileUtil.getArchiveFile((URL)url);
            if (archiveURL != null) {
                url = archiveURL;
            }
            if ("nbinst".equals(url.getProtocol()) && (fo = URLMapper.findFileObject((URL)url)) != null && (localURL = URLMapper.findURL((FileObject)fo, (int)1)) != null) {
                url = localURL;
            }
            if ((fo = URLMapper.findFileObject((URL)url)) == null || (diskFile = FileUtil.toFile((FileObject)fo)) == null) continue;
            diskFiles.add(diskFile);
        }
        return ClasspathUtil.containsClass(diskFiles, classNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public static <T> T containsClass(@NonNull Collection<File> classpath, @NonNull Map<T, String> classNames) throws IOException {
        Parameters.notNull((CharSequence)"classpath", classpath);
        Parameters.notNull((CharSequence)"classNames", classNames);
        if (classNames.isEmpty()) {
            throw new IllegalArgumentException("classNames can't be empty");
        }
        String classFilePathFirst = null;
        T tokenFirst = null;
        LinkedHashMap<T, String> classFilePaths = new LinkedHashMap<T, String>();
        for (Map.Entry<T, String> entry : classNames.entrySet()) {
            String classFilePath = entry.getValue().replace('.', '/') + ".class";
            if (classFilePathFirst == null) {
                classFilePathFirst = classFilePath;
                tokenFirst = entry.getKey();
                continue;
            }
            classFilePaths.put(entry.getKey(), classFilePath);
        }
        int weight = Integer.MAX_VALUE;
        T token = null;
        block5: for (File file : classpath) {
            if (file.isFile()) {
                JarFile jf = new JarFile(file);
                try {
                    Enumeration<JarEntry> entries = jf.entries();
                    block6: while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (classFilePathFirst.equals(entry.getName())) {
                            T t = tokenFirst;
                            return t;
                        }
                        int i = 0;
                        for (Map.Entry entryTokens : classFilePaths.entrySet()) {
                            if (i < weight && ((String)entryTokens.getValue()).equals(entry.getName())) {
                                token = (T)entryTokens.getKey();
                                weight = i;
                            } else if (i > weight) continue block6;
                            ++i;
                        }
                    }
                    continue;
                }
                finally {
                    jf.close();
                    continue;
                }
            }
            if (new File(file, classFilePathFirst).exists()) {
                return tokenFirst;
            }
            int i = 0;
            for (Map.Entry entryTokens : classFilePaths.entrySet()) {
                if (i < weight && new File(file, (String)entryTokens.getValue()).exists()) {
                    token = (T)entryTokens.getKey();
                    weight = i;
                } else if (i > weight) continue block5;
                ++i;
            }
        }
        return token;
    }

    public static File[] getJ2eePlatformClasspathEntries(@NullAllowed Project project, @NullAllowed J2eePlatform j2eePlatform) {
        J2eeModuleProvider j2eeModuleProvider;
        if (project != null && (j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class)) != null) {
            J2eePlatform j2eePlatformLocal;
            J2eePlatform j2eePlatform2 = j2eePlatformLocal = j2eePlatform != null ? j2eePlatform : Deployment.getDefault().getJ2eePlatform(j2eeModuleProvider.getServerInstanceID());
            if (j2eePlatformLocal != null) {
                try {
                    return j2eePlatformLocal.getClasspathEntries(j2eeModuleProvider.getConfigSupport().getLibraries());
                }
                catch (ConfigurationException ex) {
                    LOGGER.log(Level.FINE, null, ex);
                    return j2eePlatformLocal.getClasspathEntries();
                }
            }
        }
        if (j2eePlatform != null) {
            return j2eePlatform.getClasspathEntries();
        }
        return new File[0];
    }
}

