/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.structure;

import java.io.Serializable;
import org.netbeans.modules.cnd.apt.impl.structure.APTContainerNode;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.netbeans.modules.cnd.utils.cache.TextCache;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;
import org.openide.util.Parameters;

public final class APTFileNode
extends APTContainerNode
implements APTFile,
Serializable {
    private static final long serialVersionUID = -6182803432699849825L;
    private transient FileSystem fileSystem;
    private final CharSequence path;
    private volatile CharSequence guard = CharSequences.empty();
    private transient boolean tokenized;

    APTFileNode(APTFileNode orig) {
        super(orig);
        this.fileSystem = orig.fileSystem;
        this.path = orig.path;
        this.tokenized = false;
        this.guard = orig.guard;
    }

    public APTFileNode(FileSystem fileSystem, CharSequence path) {
        Parameters.notNull((CharSequence)"null fileSystem", (Object)fileSystem);
        this.fileSystem = fileSystem;
        this.path = FilePathCache.getManager().getString(path);
        this.guard = TextCache.getManager().getString(this.guard);
        this.tokenized = true;
    }

    void setGuard(CharSequence guard) {
        this.guard = TextCache.getManager().getString(guard);
    }

    @Override
    public final int getType() {
        return 1;
    }

    @Override
    public int getOffset() {
        return -1;
    }

    @Override
    public int getEndOffset() {
        return -1;
    }

    @Override
    public APT getNextSibling() {
        return null;
    }

    @Override
    public String getText() {
        return "FILE:{" + this.getPath() + "}";
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public CharSequence getPath() {
        return this.path;
    }

    @Override
    public boolean isTokenized() {
        return this.tokenized;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof APTFileNode)) {
            return false;
        }
        APTFileNode other = (APTFileNode)obj;
        return this.path.equals(other.path);
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + this.path.hashCode();
        return hash;
    }

    @Override
    public final void setNextSibling(APT next) {
        assert (false) : "Illegal to add siblings to file node";
    }

    @Override
    public CharSequence getGuardMacro() {
        return this.guard;
    }
}

