/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support.clank;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import org.clang.basic.BasicClangGlobals;
import org.clang.basic.FileEntry;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.SourceManager;
import org.clang.lex.DirectoryLookup;
import org.clang.lex.MacroDefinition;
import org.clang.lex.MacroInfo;
import org.clang.lex.Preprocessor;
import org.clang.tools.services.support.FileInfo;
import org.clang.tools.services.support.FileInfoCallback;
import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.raw_ostream;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.clank.APTToClankCompilationDB;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankDriverImpl;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankFileSystemProviderImpl;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankIncludeHandlerImpl;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankToAPTToken;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankToAPTUtils;
import org.netbeans.modules.cnd.apt.support.APTFileSearch;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.ClankDriver;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.debug.DebugUtils;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.Utilities;

public final class ClankPPCallback
extends FileInfoCallback {
    private final ClankDriver.ClankPreprocessorCallback delegate;
    private final PreprocHandler ppHandler;
    private final ClankIncludeHandlerImpl includeHandler;
    private final FileSystem startFileSystem;
    private final ArrayList<ClankFileInfoWrapper> includeStack = new ArrayList(16);
    private final CancellableInterrupter interrupter;

    public ClankPPCallback(PreprocHandler ppHandler, raw_ostream traceOS, ClankDriver.ClankPreprocessorCallback delegate, CancellableInterrupter interrupter) {
        super(traceOS);
        this.ppHandler = ppHandler;
        this.includeHandler = (ClankIncludeHandlerImpl)ppHandler.getIncludeHandler();
        this.startFileSystem = this.includeHandler.getStartEntry().getFileSystem();
        this.includeHandler.resetIncludeStack();
        this.delegate = delegate;
        this.interrupter = interrupter;
    }

    protected void onUserDiagnosticDirective(FileInfo curStackElement, FileInfoCallback.UserDiagnosticDirectiveInfo directive) {
        if (!directive.isWarning()) {
            PreprocHandler.State stateWhenMetErrorDirective = APTHandlersSupport.createCleanPreprocState(this.ppHandler.getState());
            ClankErrorDirectiveWrapper errorDirectiveWrapper = new ClankErrorDirectiveWrapper(directive, stateWhenMetErrorDirective);
            directive.setAnnotation((Object)errorDirectiveWrapper);
        }
        this.interrupter.updateStateFromDelegate();
    }

    protected void onInclusionDirective(FileInfo curFile, FileInfoCallback.InclusionDirectiveInfo directive) {
        int stacksSize = this.includeStack.size();
        ResolvedPath resolvedPath = this.createResolvedPath(curFile, directive);
        StringRef fileNameSpelling = directive.getFileNameSpelling();
        String spelling = Casts.toCharSequence((char.ptr)fileNameSpelling.data(), (int)fileNameSpelling.size()).toString();
        boolean system = directive.isAngled();
        if (spelling.startsWith("rfs:")) {
            spelling = ClankFileSystemProviderImpl.getPathFromUrl(spelling);
            system = true;
        }
        ClankFileInfoWrapper currentFileWrapper = this.includeStack.get(stacksSize - 1);
        int includeDirectiveIndex = currentFileWrapper.getNextIncludeDirectiveIndex();
        ClankInclusionDirectiveWrapper inclDirectiveWrapper = new ClankInclusionDirectiveWrapper(directive, system, includeDirectiveIndex, resolvedPath, spelling);
        directive.setAnnotation((Object)inclDirectiveWrapper);
        assert (currentFileWrapper.current == curFile || !curFile.isFile());
        if (resolvedPath == null) {
            if (DebugUtils.STANDALONE) {
                if (APTUtils.LOG.getLevel().intValue() <= Level.SEVERE.intValue()) {
                    System.err.println("FAILED INCLUDE: from " + CndPathUtilities.getBaseName((String)currentFileWrapper.getFilePath().toString()) + " for:\n\t" + spelling);
                }
            } else {
                APTUtils.LOG.log(Level.WARNING, "failed resolving path from {0} for {1}", new Object[]{currentFileWrapper.getFilePath(), spelling});
            }
        }
        this.delegate.onInclusionDirective(currentFileWrapper, inclDirectiveWrapper);
        this.interrupter.updateStateFromDelegate();
    }

    protected void onDeepInclusion() {
        ClankFileInfoWrapper fileInfo = ClankPPCallback.findRecursiveInclusion(this.includeStack);
        if (fileInfo != null && fileInfo.getInclusionDirective() != null) {
            CharSequence recursivePath = fileInfo.getFilePath();
            ClankDriver.ClankInclusionDirective recursiveInclusionDirective = fileInfo.getInclusionDirective();
            for (ClankFileInfoWrapper file : this.includeStack) {
                ClankDriver.ClankInclusionDirective fileInclusionDirective = file.getInclusionDirective();
                if (!Objects.equals(file.getFilePath(), recursivePath) || fileInclusionDirective == null || !Objects.equals(fileInclusionDirective.getResolvedPath().getPath(), recursiveInclusionDirective.getResolvedPath().getPath()) || fileInclusionDirective.getDirectiveStartOffset() != recursiveInclusionDirective.getDirectiveStartOffset() || !(fileInclusionDirective instanceof ClankInclusionDirectiveWrapper)) continue;
                ClankInclusionDirectiveWrapper mutableDirective = (ClankInclusionDirectiveWrapper)fileInclusionDirective;
                mutableDirective.setRecursive(true);
            }
        }
        this.interrupter.updateStateFromDelegate();
    }

    protected void recoverFromErrorDirective() {
        this.getPreprocessor().cutOffCurFilePreprocessing();
    }

    private ResolvedPath createResolvedPath(FileInfo curFile, FileInfoCallback.InclusionDirectiveInfo directive) {
        String includedAbsPath;
        String searchedAbsPath;
        FileSystem includeFs;
        FileEntry fileEntry = directive.getFileEntry();
        if (fileEntry == null) {
            return null;
        }
        int searchPathSize = directive.getSearchPath().size();
        String searchPathUrl = Casts.toJavaString((char.ptr)directive.getSearchPath().data(), (int)searchPathSize);
        String fileEntryPathUrl = Casts.toJavaString((char.ptr)fileEntry.getName());
        assert (searchPathUrl.isEmpty() || fileEntryPathUrl.startsWith("rfs:") == searchPathUrl.startsWith("rfs:")) : "local file resolved in remote folder " + searchPathUrl + ":\n" + fileEntry;
        if (searchPathUrl.startsWith("rfs:")) {
            includeFs = CndFileSystemProvider.urlToFileSystem((CharSequence)searchPathUrl);
            if (includeFs == null) {
                Exceptions.printStackTrace((Throwable)new IllegalStateException("cannot resolve FS for " + searchPathUrl + " from " + curFile));
                return null;
            }
            searchedAbsPath = ClankFileSystemProviderImpl.getPathFromUrl(searchPathUrl);
            includedAbsPath = ClankFileSystemProviderImpl.getPathFromUrl(fileEntryPathUrl);
            if (CndUtils.isDebugMode()) {
                FileSystem includedFileFS = CndFileSystemProvider.urlToFileSystem((CharSequence)fileEntryPathUrl);
                assert (includeFs == includedFileFS) : "search dir fs=" + includeFs + "\n vs. file=" + fileEntryPathUrl + "\nfs=" + includedFileFS;
            }
        } else if (fileEntryPathUrl.startsWith("rfs:")) {
            assert (searchPathSize == 0) : "expected emtpy " + searchPathUrl + " for " + fileEntryPathUrl;
            searchedAbsPath = "";
            includeFs = CndFileSystemProvider.urlToFileSystem((CharSequence)fileEntryPathUrl);
            includedAbsPath = ClankFileSystemProviderImpl.getPathFromUrl(fileEntryPathUrl);
        } else {
            includeFs = this.startFileSystem;
            searchedAbsPath = searchPathUrl;
            includedAbsPath = fileEntryPathUrl;
        }
        assert (CndPathUtilities.isPathAbsolute((CharSequence)includedAbsPath)) : "expected to be abs path [" + includedAbsPath + "]";
        assert (searchPathSize == 0 || CndPathUtilities.isPathAbsolute((CharSequence)searchedAbsPath)) : "expected to be abs path [" + searchedAbsPath + "]";
        assert (searchPathSize == 0 == (searchedAbsPath.length() == 0)) : "unexpected searchedAbsPath " + searchedAbsPath + " from " + directive.getSearchPath();
        if (!APTTraceFlags.ALWAYS_USE_NB_FS) {
            includedAbsPath = CndFileUtils.normalizeAbsolutePath((FileSystem)includeFs, (String)includedAbsPath);
            searchedAbsPath = searchPathSize == 0 ? searchedAbsPath : CndFileUtils.normalizeAbsolutePath((FileSystem)includeFs, (String)searchedAbsPath);
        }
        CndUtils.assertNormalized((FileSystem)includeFs, (CharSequence)includedAbsPath);
        if (searchedAbsPath.isEmpty()) {
            String parent = CndPathUtilities.getDirName((String)includedAbsPath);
            return new ResolvedPath(includeFs, FilePathCache.getManager().getString((CharSequence)parent), includedAbsPath, false, 0);
        }
        CndUtils.assertNormalized((FileSystem)includeFs, (CharSequence)searchedAbsPath);
        assert (curFile != null);
        String currentFileFolderUrl = CndPathUtilities.getDirName((String)Casts.toJavaString((char.ptr)curFile.getName()));
        boolean isDefaultSearchPath = currentFileFolderUrl.equals(searchPathUrl);
        return new ResolvedPath(includeFs, FilePathCache.getManager().getString((CharSequence)searchedAbsPath), includedAbsPath, isDefaultSearchPath, 0);
    }

    protected void onSkippedInclusionDirective(FileInfo curFile, FileInfoCallback.InclusionDirectiveInfo directive) {
    }

    protected boolean onNotFoundInclusionDirective(FileInfo curFile, StringRef FileName, SmallString RecoveryPath, std.vector<DirectoryLookup> SearchedDirs, int SearchedFromIndex) {
        if (!APTTraceFlags.FIX_NOT_FOUND_INCLUDES) {
            return false;
        }
        APTFileSearch fileSearch = this.includeHandler.getFileSearch();
        if (fileSearch != null) {
            String headerPath;
            char.ptr curFilePath = curFile.getName();
            String FileNameStr = Native.$toString((char.ptr)FileName.data(), (int)FileName.size());
            FSPath path = fileSearch.searchInclude(FileNameStr, Native.$toString((char.ptr)curFilePath));
            if (path != null && (headerPath = path.getPath()).endsWith(FileNameStr) && headerPath.length() > FileNameStr.length()) {
                headerPath = CndFileSystemProvider.toUrl((FSPath)path).toString();
                String recoveryDir = headerPath.substring(0, headerPath.length() - FileNameStr.length() - 1);
                RecoveryPath.$assign(NativePointer.create_char$ptr_utf8((CharSequence)recoveryDir));
                return true;
            }
        }
        return super.onNotFoundInclusionDirective(curFile, FileName, RecoveryPath, SearchedDirs, SearchedFromIndex);
    }

    protected void onEnter(FileInfo enteredFrom, FileInfo enteredTo) {
        if (enteredTo.isFile()) {
            ClankDriver.ClankFileInfo enteredFromWrapper;
            ClankFileInfoWrapper enteredToWrapper = new ClankFileInfoWrapper(enteredTo, this.ppHandler);
            if (this.includeStack.isEmpty()) {
                if (CndUtils.isDebugMode()) {
                    CharSequence startUrl = APTTraceFlags.USE_CLANK ? CndFileSystemProvider.toUrl((FileSystem)this.includeHandler.getStartEntry().getFileSystem(), (CharSequence)this.includeHandler.getStartEntry().getStartFile()) : this.includeHandler.getStartEntry().getStartFile();
                    CndUtils.assertPathsEqualInConsole((CharSequence)startUrl, (CharSequence)Casts.toCharSequence((char.ptr)enteredTo.getName()), (String)"{0} vs. {1}", (Object[])new Object[]{this.includeHandler.getStartEntry(), enteredTo});
                }
                assert (this.includeHandler.getInclStackIndex() == 0) : " expected zero: " + this.includeHandler.getInclStackIndex();
                assert (enteredToWrapper.getFileIndex() == 0) : " expected zero: " + enteredToWrapper.getFileIndex();
                enteredFromWrapper = null;
            } else {
                ResolvedPath resolvedPath = enteredToWrapper.getResolvedPath();
                int includeDirectiveIndex = enteredToWrapper.getInclusionDirective().getIncludeDirectiveIndex();
                this.includeHandler.pushInclude(resolvedPath.getFileSystem(), resolvedPath.getPath(), 0, enteredTo.getIncludeStartOffset(), resolvedPath.getIndex(), includeDirectiveIndex);
                this.includeHandler.cachePreprocessorOutputImplementation(enteredToWrapper);
                enteredFromWrapper = this.includeStack.get(this.includeStack.size() - 1);
            }
            this.includeStack.add(enteredToWrapper);
            if (!this.delegate.onEnter(enteredFromWrapper, enteredToWrapper)) {
                this.interrupter.stop();
            }
        } else {
            assert (this.includeStack.size() == 1) : "there should be only one main file";
            assert (this.includeStack.get(0).current.isMainFile()) : "there should be only main file";
            this.includeStack.get(0).onEnterToBuiltIn(enteredTo);
        }
        this.interrupter.updateStateFromDelegate();
    }

    protected void onExit(FileInfo exitedFrom, FileInfo exitedTo) {
        if (exitedFrom.isFile()) {
            assert (this.includeStack.size() > 0) : "empty include stack?";
            ClankFileInfoWrapper exitedFromWrapper = this.includeStack.remove(this.includeStack.size() - 1);
            assert (exitedFromWrapper.current == exitedFrom);
            exitedFromWrapper.exited();
            this.includeHandler.cachePreprocessorOutputImplementation(exitedFromWrapper);
            ClankDriver.ClankFileInfo exitedToWrapper = this.includeStack.isEmpty() ? null : (ClankDriver.ClankFileInfo)this.includeStack.get(this.includeStack.size() - 1);
            if (!this.delegate.onExit(exitedFromWrapper, exitedToWrapper)) {
                this.interrupter.stop();
            }
            if (exitedToWrapper != null) {
                this.includeHandler.popInclude();
            }
        } else {
            assert (this.includeStack.size() == 1) : "there should be only one main file";
            assert (this.includeStack.get(0).current.isMainFile()) : "there should be only main file";
            this.includeStack.get(0).onExitFromBuiltIn(exitedFrom);
        }
        this.interrupter.updateStateFromDelegate();
    }

    protected boolean needPPDirectives() {
        return this.delegate.needPPDirectives();
    }

    protected boolean needTokens() {
        return this.delegate.needTokens();
    }

    protected boolean needSkippedRanges() {
        return this.delegate.needSkippedRanges();
    }

    protected boolean needMacroExpansion() {
        return this.delegate.needMacroExpansion();
    }

    protected boolean needComments() {
        return this.delegate.needComments();
    }

    protected boolean isStopped() {
        return this.interrupter.isCancelled();
    }

    private static ClankFileInfoWrapper findRecursiveInclusion(ArrayList<ClankFileInfoWrapper> stack) {
        if (!stack.isEmpty()) {
            ClankFileInfoWrapper best = null;
            int bestFrequency = 0;
            HashMap<String, Pair> mapping = new HashMap<String, Pair>();
            for (ClankFileInfoWrapper fileInfo : stack) {
                String path = fileInfo.getFilePath().toString();
                Pair pair = (Pair)mapping.get(path);
                pair = pair == null ? Pair.of((Object)fileInfo, (Object)1) : Pair.of((Object)pair.first(), (Object)((Integer)pair.second() + 1));
                mapping.put(path, pair);
                if (bestFrequency > (Integer)pair.second()) continue;
                best = (ClankFileInfoWrapper)pair.first();
                bestFrequency = (Integer)pair.second();
            }
            return best;
        }
        return null;
    }

    private static final class ClankFileInfoWrapper
    implements ClankDriver.ClankFileInfo,
    ClankDriverImpl.ClankPreprocessorOutputImplementation {
        private final boolean needLineColumnsForToken;
        private final FileInfo current;
        private final ClankInclusionDirectiveWrapper includeDirective;
        private final CharSequence filePath;
        private final int includeIndex;
        private APTToken[] convertedTokens;
        private List<ClankDriver.ClankPreprocessorDirective> convertedPPDirectives;
        private List<ClankDriver.MacroExpansion> convertedMacroExpansions;
        private List<ClankDriver.MacroUsage> convertedMacroUsages;
        private ClankDriver.FileGuard convertedGuard;
        private boolean hasTokenStream = false;
        private int[] skippedRanges = null;
        private boolean convertedToAPT = false;
        private int NextIncludeDirectiveIndex = -1;
        private Collection<FileInfo> visitedBuiltIns;

        public ClankFileInfoWrapper(FileInfo current, PreprocHandler ppHandler) {
            assert (current != null);
            this.needLineColumnsForToken = APTToClankCompilationDB.isFortran(ppHandler);
            this.current = current;
            this.includeIndex = current.getIncludeIndex();
            if (current.getInclusionDirective() == null) {
                assert (current.isMainFile()) : "forgot to set up include?" + current;
                this.includeDirective = null;
                this.filePath = ClankFileSystemProviderImpl.getPathFromUrl(Casts.toJavaString((char.ptr)current.getName()));
            } else {
                this.includeDirective = (ClankInclusionDirectiveWrapper)current.getInclusionDirective().getAnnotation();
                assert (this.includeDirective != null) : "forgot to set up include?" + current;
                assert (this.includeDirective.getResolvedPath() != null);
                this.filePath = this.includeDirective.getResolvedPath().getPath();
            }
        }

        public APTToken[] getConvertedTokens() {
            assert (this.convertedToAPT) : "was not prepared yet";
            assert (this.convertedTokens != null);
            return this.convertedTokens;
        }

        private void prepareConvertedMacroExpansions() {
            HashMap<MacroDefinition, ClankDriver.ClankMacroDirective> directives = new HashMap<MacroDefinition, ClankDriver.ClankMacroDirective>();
            SmallVector macroExpansions = this.current.getMacroExpansions();
            int size = macroExpansions.size();
            Object[] expansions = macroExpansions.$array();
            this.convertedMacroExpansions = new ArrayList<ClankDriver.MacroExpansion>(size);
            for (int i = 0; i < size; ++i) {
                FileInfoCallback.MacroExpansionInfo e = (FileInfoCallback.MacroExpansionInfo)expansions[i];
                MacroDefinition MD = e.getReferencedMacroDefinition();
                ClankDriver.ClankMacroDirective referencedMacro = (ClankDriver.ClankMacroDirective)directives.get(MD);
                if (referencedMacro == null) {
                    if (MD.$bool()) {
                        referencedMacro = ClankMacroDirectiveWrapper.create(e.getExpandedMacroName(), MD, this.current.getSourceManager());
                        directives.put(MD, referencedMacro);
                    } else {
                        CndUtils.assertTrueInConsole((boolean)false, (String)("Should be defined MacroDefinition: " + MD));
                        continue;
                    }
                }
                ClankDriver.MacroExpansion macroExpansion = new ClankDriver.MacroExpansion(e, referencedMacro);
                this.convertedMacroExpansions.add(macroExpansion);
            }
            SmallVector macroUsages = this.current.getMacroUsages();
            size = macroUsages.size();
            expansions = macroUsages.$array();
            this.convertedMacroUsages = new ArrayList<ClankDriver.MacroUsage>(size);
            SourceManager srcMgr = this.current.getSourceManager();
            for (int i = 0; i < size; ++i) {
                int macroUsageStartOffset;
                FileInfoCallback.MacroUsageInfo e = (FileInfoCallback.MacroUsageInfo)expansions[i];
                MacroDefinition MD = e.getReferencedMacroDefinition();
                ClankDriver.ClankMacroDirective referencedMacro = (ClankDriver.ClankMacroDirective)directives.get(MD);
                if (referencedMacro == null) {
                    if (MD.$bool()) {
                        referencedMacro = ClankMacroDirectiveWrapper.create(e.getUsedMacroName(), MD, srcMgr);
                        directives.put(MD, referencedMacro);
                    } else {
                        CndUtils.assertTrueInConsole((boolean)false, (String)("Should be defined MacroDefinition: " + MD));
                        continue;
                    }
                }
                int startOfset = macroUsageStartOffset = BasicClangGlobals.$second_offset((long)srcMgr.getDecomposedLoc(e.getUsedMacroNameLocation()));
                int endOfset = startOfset + e.getUsedMacroNameLength();
                ClankDriver.MacroUsage macroUsage = new ClankDriver.MacroUsage(startOfset, endOfset, referencedMacro);
                this.convertedMacroUsages.add(macroUsage);
            }
        }

        private void prepareConvertedGuard() {
            SmallVector guards = this.current.getFileGuardsInfo();
            assert (guards != null);
            if (!guards.empty()) {
                FileInfoCallback.FileGuardInfo fileGuardInfo = (FileInfoCallback.FileGuardInfo)guards.$at(guards.size() - 1);
                SourceManager srcMgr = this.current.getSourceManager();
                int start = BasicClangGlobals.$second_offset((long)srcMgr.getDecomposedLoc(fileGuardInfo.getIfDefMacroLocation()));
                this.convertedGuard = new ClankDriver.FileGuard(start, start + fileGuardInfo.getIfDefMacro().getLength());
            }
        }

        private void prepareConvertedPPDirectives() {
            assert (Thread.holdsLock(this));
            SmallVector ppDirectives = this.current.getPreprocessorDirectives();
            Object[] directives = ppDirectives.$array();
            int nrDirectives = ppDirectives.size();
            assert (this.convertedPPDirectives == null);
            this.convertedPPDirectives = new ArrayList<ClankDriver.ClankPreprocessorDirective>(nrDirectives);
            Preprocessor PP = this.current.getPreprocessor();
            SourceManager SM = PP.getSourceManager();
            if (this.current.isMainFile()) {
                if (this.visitedBuiltIns != null) {
                    for (FileInfo builtIn : this.visitedBuiltIns) {
                        SmallVector builtInPPDirectives = builtIn.getPreprocessorDirectives();
                        Object[] builtInPPArray = builtInPPDirectives.$array();
                        int nrBuiltInPPDirectives = builtInPPDirectives.size();
                        ArrayList<ClankInclusionDirectiveWrapper> includeFiles = new ArrayList<ClankInclusionDirectiveWrapper>(1);
                        for (int i = 0; i < nrBuiltInPPDirectives; ++i) {
                            FileInfoCallback.PreprocessorDirectiveInfo curBuiltInDirective = (FileInfoCallback.PreprocessorDirectiveInfo)builtInPPArray[i];
                            if (!(curBuiltInDirective instanceof FileInfoCallback.InclusionDirectiveInfo)) continue;
                            ClankInclusionDirectiveWrapper includedFile = (ClankInclusionDirectiveWrapper)curBuiltInDirective.getAnnotation();
                            assert (includedFile != null);
                            includeFiles.add(includedFile);
                        }
                        for (ClankInclusionDirectiveWrapper directiveWrapper : includeFiles) {
                            int fakeStartOffset = directiveWrapper.getIncludeDirectiveIndex() - includeFiles.size();
                            ClankInclusionDirectiveWrapper includedFile = directiveWrapper.convertToIncludeFile(fakeStartOffset);
                            ++fakeStartOffset;
                            this.convertedPPDirectives.add(includedFile);
                        }
                    }
                }
            } else assert (this.visitedBuiltIns == null) : "built-ins can be only in main file " + this.visitedBuiltIns;
            for (int i = 0; i < nrDirectives; ++i) {
                FileInfoCallback.MacroDefinitionInfo macroDirective;
                ClankPreprocessorDirectiveWrapper wrapper;
                FileInfoCallback.PreprocessorDirectiveInfo curDirective = (FileInfoCallback.PreprocessorDirectiveInfo)directives[i];
                if (curDirective instanceof FileInfoCallback.InclusionDirectiveInfo) {
                    wrapper = (ClankInclusionDirectiveWrapper)curDirective.getAnnotation();
                    assert (wrapper != null);
                    this.convertedPPDirectives.add(wrapper);
                    continue;
                }
                if (curDirective instanceof FileInfoCallback.UserDiagnosticDirectiveInfo) {
                    if (((FileInfoCallback.UserDiagnosticDirectiveInfo)curDirective).isWarning()) continue;
                    wrapper = (ClankErrorDirectiveWrapper)curDirective.getAnnotation();
                    assert (wrapper != null);
                    this.convertedPPDirectives.add(wrapper);
                    continue;
                }
                if (!(curDirective instanceof FileInfoCallback.MacroDefinitionInfo) || !(macroDirective = (FileInfoCallback.MacroDefinitionInfo)curDirective).isDefined()) continue;
                CharSequence macroName = ClankToAPTUtils.getIdentifierText(macroDirective.getMacroName());
                ArrayList<CharSequence> params = null;
                if (macroDirective.isFunctionLike()) {
                    IdentifierInfo[] arguments = macroDirective.getArguments();
                    params = new ArrayList<CharSequence>(arguments.length);
                    for (IdentifierInfo arg : arguments) {
                        CharSequence argName = ClankToAPTUtils.getIdentifierText(arg);
                        params.add(argName);
                    }
                    if (macroDirective.isVariadic()) {
                        assert (params.size() > 0);
                        params.set(params.size() - 1, APTUtils.VA_ARGS_TOKEN.getTextID());
                    }
                }
                int macroNameStartOffset = BasicClangGlobals.$second_offset((long)SM.getDecomposedLoc(macroDirective.getMacroNameLocation()));
                ClankMacroDirectiveWrapper wrapper2 = new ClankMacroDirectiveWrapper(macroName, params, macroDirective, macroNameStartOffset);
                this.convertedPPDirectives.add(wrapper2);
            }
        }

        private void prepareConvertedTokensIfAny() {
            assert (Thread.holdsLock(this));
            if (this.current.hasTokens()) {
                this.convertedTokens = ClankToAPTToken.convertToAPT(this.current.getPreprocessor(), this.current.getTokens(), this.needLineColumnsForToken);
            }
        }

        @Override
        public CharSequence getFilePath() {
            return this.filePath;
        }

        @Override
        public Collection<ClankDriver.ClankPreprocessorDirective> getPreprocessorDirectives() {
            this.prepareCachesIfPossible();
            return Collections.unmodifiableList(this.convertedPPDirectives);
        }

        @Override
        public Collection<ClankDriver.MacroExpansion> getMacroExpansions() {
            this.prepareCachesIfPossible();
            return Collections.unmodifiableList(this.convertedMacroExpansions);
        }

        @Override
        public Collection<ClankDriver.MacroUsage> getMacroUsages() {
            this.prepareCachesIfPossible();
            return Collections.unmodifiableList(this.convertedMacroUsages);
        }

        @Override
        public ClankDriver.FileGuard getFileGuard() {
            this.prepareCachesIfPossible();
            return this.convertedGuard;
        }

        @Override
        public TokenStream getTokenStream() {
            return new ClankDriverImpl.ArrayBasedAPTTokenStream(this.getConvertedTokens());
        }

        @Override
        public int getFileIndex() {
            return this.includeIndex;
        }

        @Override
        public ClankDriver.ClankInclusionDirective getInclusionDirective() {
            return this.includeDirective;
        }

        @Override
        public int[] getSkippedRanges() {
            return this.skippedRanges;
        }

        @Override
        public boolean hasTokenStream() {
            return this.hasTokenStream;
        }

        @Override
        public synchronized ClankDriverImpl.ClankPreprocessorOutputImplementation prepareCachesIfPossible() {
            this.prepareCaches();
            return this;
        }

        private void prepareCaches() {
            if (!this.convertedToAPT) {
                this.prepareConvertedTokensIfAny();
                this.prepareConvertedPPDirectives();
                this.prepareConvertedMacroExpansions();
                this.prepareConvertedGuard();
                this.convertedToAPT = true;
            }
        }

        public String toString() {
            return "ClankFileInfoImpl{convertedToAPT=" + this.convertedToAPT + ";" + " hasTokenStream=" + this.hasTokenStream + ", current=" + this.current + ",\n" + "currentInclude=" + this.includeDirective + '}';
        }

        private ResolvedPath getResolvedPath() {
            assert (this.includeDirective != null);
            return this.includeDirective.getResolvedPath();
        }

        private void exited() {
            this.hasTokenStream = this.current.hasTokens();
            this.skippedRanges = this.current.getSkippedRanges();
        }

        private int getNextIncludeDirectiveIndex() {
            return ++this.NextIncludeDirectiveIndex;
        }

        private void onEnterToBuiltIn(FileInfo enteredTo) {
            assert (this.current.isMainFile()) : "current wrapper must be Compilation Unit: " + this.current;
        }

        private void onExitFromBuiltIn(FileInfo exitedFrom) {
            assert (this.current.isMainFile()) : "current wrapper must be Compilation Unit: " + this.current;
            if (this.visitedBuiltIns == null) {
                this.visitedBuiltIns = new ArrayList<FileInfo>(2);
            }
            this.visitedBuiltIns.add(exitedFrom);
        }
    }

    private static final class ClankInclusionDirectiveWrapper
    extends ClankPreprocessorDirectiveWrapper
    implements ClankDriver.ClankInclusionDirective {
        private final ResolvedPath resolvedPath;
        private final String spelling;
        private final boolean isAngled;
        private final int includeDirectiveIndex;
        private boolean recursive;
        private static final String INCLUDE_FILE = "-include";

        public ClankInclusionDirectiveWrapper(FileInfoCallback.InclusionDirectiveInfo clankDelegate, boolean system, int includeDirectiveIndex, ResolvedPath resolvedPath, String spelling) {
            super((FileInfoCallback.PreprocessorDirectiveInfo)clankDelegate);
            this.isAngled = system;
            this.includeDirectiveIndex = includeDirectiveIndex;
            this.resolvedPath = resolvedPath;
            this.spelling = spelling;
            this.recursive = false;
        }

        private ClankInclusionDirectiveWrapper(int start, int end, ClankInclusionDirectiveWrapper copyFrom) {
            super(start, end);
            this.isAngled = copyFrom.isAngled;
            this.includeDirectiveIndex = copyFrom.includeDirectiveIndex;
            this.resolvedPath = copyFrom.resolvedPath;
            this.spelling = copyFrom.spelling;
            this.recursive = copyFrom.recursive;
            super.setAnnotation(copyFrom.getAnnotation());
        }

        private ClankInclusionDirectiveWrapper convertToIncludeFile(int start) {
            return new ClankInclusionDirectiveWrapper(start, start + INCLUDE_FILE.length(), this);
        }

        @Override
        public ResolvedPath getResolvedPath() {
            return this.resolvedPath;
        }

        @Override
        public String getSpellingName() {
            return this.spelling;
        }

        @Override
        public boolean isAngled() {
            return this.isAngled;
        }

        @Override
        public boolean isRecursive() {
            return this.recursive;
        }

        @Override
        public int getIncludeDirectiveIndex() {
            return this.includeDirectiveIndex;
        }

        public void setRecursive(boolean recursive) {
            this.recursive = recursive;
        }

        @Override
        public String toString() {
            return "ClankInclusionDirective{\n" + super.toString() + ",\n" + "#" + this.includeDirectiveIndex + ";" + "resolvedPath=" + this.resolvedPath + ",\n" + "spelling=" + this.spelling + ",\n" + '}';
        }
    }

    private static final class ClankErrorDirectiveWrapper
    extends ClankPreprocessorDirectiveWrapper
    implements ClankDriver.ClankErrorDirective {
        private final CharSequence msg;
        private final PreprocHandler.State stateWhenMetErrorDirective;

        public ClankErrorDirectiveWrapper(FileInfoCallback.UserDiagnosticDirectiveInfo clankDelegate, PreprocHandler.State stateWhenMetErrorDirective) {
            super((FileInfoCallback.PreprocessorDirectiveInfo)clankDelegate);
            assert (stateWhenMetErrorDirective != null);
            this.stateWhenMetErrorDirective = stateWhenMetErrorDirective;
            StringRef message = clankDelegate.getMessage();
            String spelling = Casts.toCharSequence((char.ptr)message.data(), (int)message.size()).toString();
            this.msg = spelling;
        }

        @Override
        public CharSequence getMessage() {
            return this.msg;
        }

        @Override
        public PreprocHandler.State getStateWhenMetErrorDirective() {
            return this.stateWhenMetErrorDirective;
        }

        @Override
        public String toString() {
            return "ClankErrorDirectiveWrapper{" + super.toString() + ",\n" + " msg=" + this.msg + '}';
        }
    }

    private static final class ClankMacroDirectiveWrapper
    extends ClankPreprocessorDirectiveWrapper
    implements ClankDriver.ClankMacroDirective {
        private final List<CharSequence> params;
        private final CharSequence macroName;
        private final boolean isDefined;
        private final int macroNameTokenSourceLocation;
        private final int macroNameOffset;
        private final CharSequence fileOwnerName;
        private final boolean isBuiltIn;

        static ClankMacroDirectiveWrapper create(IdentifierInfo II, MacroDefinition MD, SourceManager SM) {
            CharSequence strName;
            MacroInfo macroInfo = MD.getMacroInfo();
            int hashLoc = macroInfo.getHashLoc();
            long decomposedLocBegin = SM.getDecomposedLoc(hashLoc);
            int eodLoc = macroInfo.getEodLoc();
            long decomposedLocEnd = SM.getDecomposedLoc(eodLoc);
            int begOffset = BasicClangGlobals.$second_offset((long)decomposedLocBegin);
            int endOffset = BasicClangGlobals.$second_offset((long)decomposedLocEnd);
            ArrayList<CharSequence> params = null;
            boolean isVariadic = false;
            if (macroInfo.isFunctionLike()) {
                IdentifierInfo[] args = null;
                args = macroInfo.$args();
                if (args != null) {
                    isVariadic = macroInfo.isVariadic();
                    params = new ArrayList<CharSequence>(args.length);
                    for (IdentifierInfo arg : args) {
                        CharSequence argName = ClankToAPTUtils.getIdentifierText(arg);
                        params.add(argName);
                    }
                    if (isVariadic) {
                        assert (params.size() > 0);
                        params.set(params.size() - 1, APTUtils.VA_ARGS_TOKEN.getTextID());
                    }
                }
            }
            if ((strName = ClankToAPTUtils.getIdentifierText(II)) == null) {
                strName = "???";
                CndUtils.assertTrueInConsole((boolean)false, (String)("Null macro name " + MD));
            }
            char.ptr bufferName = SM.getBufferName(macroInfo.getDefinitionLoc());
            return new ClankMacroDirectiveWrapper(strName, params, bufferName, begOffset, endOffset);
        }

        public ClankMacroDirectiveWrapper(CharSequence name, List<CharSequence> params, char.ptr bufferName, int begOffset, int endOffset) {
            super(begOffset, endOffset);
            this.params = params;
            this.macroName = name;
            this.isDefined = true;
            this.macroNameTokenSourceLocation = -1;
            this.macroNameOffset = begOffset;
            if (std.strcmp((char.ptr)bufferName, (CharSequence)"<built-in>") == 0) {
                this.fileOwnerName = null;
                this.isBuiltIn = true;
            } else if (std.strcmp((char.ptr)bufferName, (CharSequence)"<invalid loc>") == 0) {
                this.fileOwnerName = null;
                this.isBuiltIn = true;
            } else if (std.strcmp((char.ptr)bufferName, (CharSequence)"Unknown buffer") == 0) {
                assert (false) : "Unknown location of macro definition " + this.macroName;
                this.fileOwnerName = null;
                this.isBuiltIn = true;
            } else {
                this.fileOwnerName = ClankMacroDirectiveWrapper.getFileOwnerNameImpl(bufferName);
                if (!Utilities.isWindows() && CharSequences.indexOf((CharSequence)this.fileOwnerName, (CharSequence)"/") < 0) {
                    CndUtils.assertTrueInConsole((boolean)false, (String)("Strange fileOwnerName: '" + this.fileOwnerName + ""));
                }
                this.isBuiltIn = false;
            }
        }

        public ClankMacroDirectiveWrapper(CharSequence macroName, List<CharSequence> params, FileInfoCallback.MacroDefinitionInfo clankDelegate, int macroNameStartOffset) {
            super((FileInfoCallback.PreprocessorDirectiveInfo)clankDelegate);
            this.params = params;
            this.macroName = macroName;
            this.isDefined = clankDelegate.isDefined();
            this.macroNameTokenSourceLocation = clankDelegate.getMacroNameLocation();
            this.macroNameOffset = macroNameStartOffset;
            FileInfo fileOwner = clankDelegate.getFileOwner();
            if (fileOwner.isFile()) {
                this.isBuiltIn = false;
                this.fileOwnerName = ClankMacroDirectiveWrapper.getFileOwnerNameImpl(fileOwner.getName());
            } else {
                this.isBuiltIn = true;
                this.fileOwnerName = null;
            }
        }

        @Override
        public CharSequence getFile() {
            return this.isBuiltIn ? BUILD_IN_FILE : this.fileOwnerName;
        }

        public boolean isBuiltIn() {
            return this.isBuiltIn;
        }

        @Override
        public boolean isDefined() {
            return this.isDefined;
        }

        @Override
        public CharSequence getMacroName() {
            return this.macroName;
        }

        @Override
        public int getMacroNameOffset() {
            return this.macroNameOffset;
        }

        @Override
        public List<CharSequence> getParameters() {
            return this.params == null ? null : Collections.unmodifiableList(this.params);
        }

        @Override
        public int getMacroNameLocation() {
            return this.macroNameTokenSourceLocation;
        }

        @Override
        public String toString() {
            return super.toString() + this.fileOwnerName + (this.isDefined ? " #define " : " #undef ") + this.macroName + (this.params == null ? "" : "(" + this.params + ")");
        }

        private static CharSequence getFileOwnerNameImpl(char.ptr fileOwner) {
            String res = ClankFileSystemProviderImpl.getPathFromUrl(Casts.toJavaString((char.ptr)fileOwner));
            if (CharSequenceUtils.startsWith((CharSequence)res, (CharSequence)"rfs:")) {
                Exceptions.printStackTrace((Throwable)new IllegalArgumentException("File owner name should not contain protocol: " + res));
            }
            return res;
        }
    }

    private static abstract class ClankPreprocessorDirectiveWrapper
    implements ClankDriver.ClankPreprocessorDirective {
        private Object externalAnnotation;
        private final int startOffset;
        private final int endOffset;

        public ClankPreprocessorDirectiveWrapper(FileInfoCallback.PreprocessorDirectiveInfo delegate) {
            this(delegate.getHashOffset(), delegate.getEodOffset());
        }

        public ClankPreprocessorDirectiveWrapper(int start, int end) {
            this.startOffset = start;
            this.endOffset = end;
        }

        @Override
        public int getDirectiveStartOffset() {
            return this.startOffset;
        }

        @Override
        public int getDirectiveEndOffset() {
            return this.endOffset;
        }

        @Override
        public void setAnnotation(Object annotation) {
            assert (this.externalAnnotation == null) : "replacing? " + this.externalAnnotation;
            this.externalAnnotation = annotation;
        }

        @Override
        public Object getAnnotation() {
            return this.externalAnnotation;
        }

        public String toString() {
            return "[" + this.startOffset + "-" + this.endOffset + "] " + "annotation=" + this.externalAnnotation;
        }
    }

    public static final class CancellableInterrupter
    implements org.clang.tools.services.support.Interrupter {
        final Interrupter outerDelegate;
        private boolean stoppedState = false;

        public CancellableInterrupter(Interrupter outerDelegate) {
            this.outerDelegate = outerDelegate;
        }

        public boolean isCancelled() {
            return this.stoppedState;
        }

        private void stop() {
            this.stoppedState = true;
        }

        private void updateStateFromDelegate() {
            this.stoppedState |= this.outerDelegate.cancelled();
        }
    }
}

