/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.networkneighbour;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.remote.ui.networkneighbour.NeighbourHost;
import org.netbeans.modules.cnd.remote.ui.networkneighbour.PortTextField;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class HostSelectionPanel
extends JPanel {
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private final MyChangeListener listener = new MyChangeListener();
    private PropertyChangeListener explorerListener = null;
    private Node selectedNode = null;
    private JLabel lblHostName;
    private JLabel lblPort;
    private JTextField textHost;
    private PortTextField textPort;

    public HostSelectionPanel() {
        this.initComponents();
        this.textPort.setText("22");
        this.textHost.getDocument().addDocumentListener(this.listener);
        this.textPort.getDocument().addDocumentListener(this.listener);
    }

    public void addChangeListener(ChangeListener cl) {
        this.cs.addChangeListener(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.cs.removeChangeListener(cl);
    }

    public String getHostname() {
        return this.textHost.getText().trim();
    }

    public int getPort() {
        if ("".equals(this.textPort.getText())) {
            return 22;
        }
        try {
            return Integer.parseInt(this.textPort.getText().trim());
        }
        catch (NumberFormatException e) {
            return 22;
        }
    }

    private void initComponents() {
        this.lblHostName = new JLabel();
        this.textHost = new JTextField();
        this.lblPort = new JLabel();
        this.textPort = new PortTextField();
        this.lblHostName.setLabelFor(this.textHost);
        Mnemonics.setLocalizedText((JLabel)this.lblHostName, (String)NbBundle.getMessage(HostSelectionPanel.class, (String)"HostSelectionPanel.lblHostName.text"));
        this.textHost.setText(NbBundle.getMessage(HostSelectionPanel.class, (String)"HostSelectionPanel.textHost.text"));
        this.lblPort.setLabelFor(this.textPort);
        Mnemonics.setLocalizedText((JLabel)this.lblPort, (String)NbBundle.getMessage(HostSelectionPanel.class, (String)"HostSelectionPanel.lblPort.text"));
        this.textPort.setText(NbBundle.getMessage(HostSelectionPanel.class, (String)"HostSelectionPanel.textPort.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblHostName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textHost, -1, 190, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPort).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textPort, -2, 68, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textHost, -2, -1, -2).addComponent(this.lblHostName).addComponent(this.lblPort).addComponent(this.textPort, -2, -1, -2)));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textHost.setEditable(enabled);
        this.textPort.setEditable(enabled);
    }

    public void set(String hostName, int port) {
        this.textHost.setText(hostName);
        if (port < 22) {
            port = 22;
        }
        this.textPort.setText(Integer.toString(port));
    }

    public void attach(ExplorerManager.Provider provider) {
        ExplorerManager mgr = provider.getExplorerManager();
        this.explorerListener = new MyExplorerListener(mgr);
        mgr.addPropertyChangeListener(this.explorerListener);
    }

    private class MyExplorerListener
    implements PropertyChangeListener {
        private final ExplorerManager manager;

        private MyExplorerListener(ExplorerManager explorerManager) {
            this.manager = explorerManager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Node[] nodes;
            if ("selectedNodes".equals(evt.getPropertyName()) && (nodes = this.manager.getSelectedNodes()).length > 0) {
                Node node = nodes[0];
                if (HostSelectionPanel.this.selectedNode == null || !HostSelectionPanel.this.selectedNode.getDisplayName().equals(node.getDisplayName())) {
                    HostSelectionPanel.this.selectedNode = node;
                    NeighbourHost host = (NeighbourHost)node.getLookup().lookup(NeighbourHost.class);
                    if (host != null) {
                        HostSelectionPanel.this.set(host.getName(), 22);
                    }
                }
            }
        }
    }

    private final class MyChangeListener
    implements DocumentListener {
        private MyChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            HostSelectionPanel.this.cs.fireChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            HostSelectionPanel.this.cs.fireChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            HostSelectionPanel.this.cs.fireChange();
        }
    }
}

