/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;

final class ProxySourceForBinaryQuery
implements SourceForBinaryQueryImplementation {
    private final SourceForBinaryQueryImplementation[] impls;

    ProxySourceForBinaryQuery(SourceForBinaryQueryImplementation ... impl) {
        this.impls = impl;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        ArrayList<SourceForBinaryQuery.Result> l = new ArrayList<SourceForBinaryQuery.Result>(this.impls.length);
        for (int i = 0; i < this.impls.length; ++i) {
            SourceForBinaryQuery.Result r = this.impls[i].findSourceRoots(binaryRoot);
            if (r == null) continue;
            l.add(r);
        }
        return new ProxyResult(l.toArray(new SourceForBinaryQuery.Result[l.size()]));
    }

    private static final class ProxyResult
    implements SourceForBinaryQuery.Result,
    ChangeListener {
        private final SourceForBinaryQuery.Result[] rs;
        private final ChangeSupport supp = new ChangeSupport((Object)this);

        ProxyResult(SourceForBinaryQuery.Result[] rs) {
            this.rs = rs;
        }

        public FileObject[] getRoots() {
            ArrayList<FileObject> l = new ArrayList<FileObject>(this.rs.length * 3);
            for (SourceForBinaryQuery.Result r : this.rs) {
                l.addAll(Arrays.asList(r.getRoots()));
            }
            return l.toArray(new FileObject[l.size()]);
        }

        public synchronized void addChangeListener(ChangeListener l) {
            boolean first = !this.supp.hasListeners();
            this.supp.addChangeListener(l);
            if (first) {
                for (SourceForBinaryQuery.Result r : this.rs) {
                    r.addChangeListener((ChangeListener)this);
                }
            }
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            boolean last;
            this.supp.removeChangeListener(l);
            boolean bl = last = !this.supp.hasListeners();
            if (last) {
                for (SourceForBinaryQuery.Result r : this.rs) {
                    r.removeChangeListener((ChangeListener)this);
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.supp.fireChange();
        }
    }
}

