/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.deps.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.javacard.project.deps.DependencyKind;
import org.netbeans.modules.javacard.project.deps.DeploymentStrategy;
import org.netbeans.modules.javacard.project.deps.ui.SigFilter;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class ChooseDeploymentStrategyPanelVisual
extends JPanel
implements ItemListener,
FocusListener,
ActionListener,
DocumentListener {
    private final ChangeSupport supp = new ChangeSupport((Object)this);
    private static final String CLIENT_PROP_DEP_KIND = "_dependencyKind";
    private final WizardDescriptor wiz;
    private final JTextField sigField = new JTextField();
    private final JButton browseButton = new JButton();
    boolean updating;

    ChooseDeploymentStrategyPanelVisual(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        HelpCtx.setHelpIDString((JComponent)this, (String)"org.netbeans.modules.javacard.ChangeLibraryDeploymentStrategy");
        this.sigField.addFocusListener(this);
        this.sigField.getDocument().addDocumentListener(this);
        this.browseButton.addActionListener(this);
    }

    void setDependencyKind(DependencyKind kind) {
        this.removeAll();
        ButtonGroup grp = new ButtonGroup();
        if (kind == null) {
            return;
        }
        ArrayList<DeploymentStrategy> l = new ArrayList<DeploymentStrategy>(kind.supportedDeploymentStrategies());
        Collections.sort(l);
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonConstraints.gridy = 0;
        buttonConstraints.fill = 1;
        buttonConstraints.anchor = 18;
        buttonConstraints.weightx = 1.0;
        buttonConstraints.weighty = 1.0;
        buttonConstraints.gridwidth = 0;
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.gridy = 1;
        labelConstraints.fill = 2;
        labelConstraints.anchor = 18;
        labelConstraints.insets = new Insets(0, 20, 12, 0);
        labelConstraints.weightx = 1.0;
        labelConstraints.weighty = 1.0;
        labelConstraints.gridwidth = 0;
        Border empty = BorderFactory.createEmptyBorder();
        Color ctrl = UIManager.getColor("control");
        ctrl = ctrl == null ? Color.GRAY : ctrl;
        Font font = null;
        for (DeploymentStrategy d : l) {
            JRadioButton button = new JRadioButton(d.toString());
            button.putClientProperty(CLIENT_PROP_DEP_KIND, (Object)d);
            button.addItemListener(this);
            grp.add(button);
            JTextArea area = new JTextArea(d.getDescription());
            if (font == null && (font = area.getFont()) != null) {
                font = font.deriveFont(2);
            }
            if (font != null) {
                area.setFont(font);
            }
            area.setBorder(empty);
            area.setLineWrap(true);
            area.setWrapStyleWord(true);
            JScrollPane desc = new JScrollPane(area);
            desc.setBorder(empty);
            desc.setViewportBorder(empty);
            area.setBackground(ctrl);
            desc.setBackground(ctrl);
            desc.getViewport().setBackground(ctrl);
            area.getCaret().setVisible(false);
            area.setEditable(false);
            this.add((Component)button, buttonConstraints);
            this.add((Component)desc, labelConstraints);
            if (d == DeploymentStrategy.DEPLOY_TO_CARD && !kind.isProjectDependency()) {
                Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(ChooseDeploymentStrategyPanelVisual.class, (String)"LBL_BROWSE"));
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.fill = 2;
                gbc.gridx = 0;
                gbc.gridy = buttonConstraints.gridy + 1;
                gbc.anchor = 17;
                int dist = Utilities.isMac() ? 12 : 5;
                int left = button.getIcon() != null ? button.getIcon().getIconWidth() + button.getIconTextGap() : button.getIconTextGap();
                left = Math.max(16, left);
                gbc.insets = new Insets(24, left, dist, dist);
                JLabel sigLabel = new JLabel(NbBundle.getMessage(ChooseDeploymentStrategyPanelVisual.class, (String)"SIG_FILE"));
                this.add((Component)sigLabel, gbc);
                gbc.insets = new Insets(24, 0, dist, dist);
                ++gbc.gridx;
                gbc.weightx = 1.0;
                this.add((Component)this.sigField, gbc);
                ++gbc.gridx;
                gbc.weightx = 0.0;
                this.add((Component)this.browseButton, gbc);
                buttonConstraints.gridy += 4;
                labelConstraints.gridy += 4;
            }
            buttonConstraints.gridy += 2;
            labelConstraints.gridy += 2;
        }
        this.insertUpdate(null);
    }

    public DeploymentStrategy getDeploymentStrategy() {
        for (Component c : this.getComponents()) {
            if (!(c instanceof JRadioButton) || !((JRadioButton)c).isSelected()) continue;
            JRadioButton r = (JRadioButton)c;
            return (DeploymentStrategy)((Object)r.getClientProperty(CLIENT_PROP_DEP_KIND));
        }
        return null;
    }

    public File getSignatureFile() {
        if (this.sigField.getText().trim().length() > 0) {
            return new File(this.sigField.getText());
        }
        return null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        JDialog dlg = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this);
        if (dlg != null) {
            Dimension d = dlg.getPreferredSize();
            dlg.setSize(d);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this.supp.removeChangeListener(listener);
    }

    public void fireChange() {
        this.supp.fireChange();
    }

    public void addChangeListener(ChangeListener listener) {
        this.supp.addChangeListener(listener);
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ChooseDeploymentStrategyPanelVisual.class, (String)"WIZARD_STEP_CHOOSE_DEPLOYMENT_STRATEGY");
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.insertUpdate(null);
        this.fireChange();
        this.insertUpdate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDeploymentStrategy(DeploymentStrategy deploymentStrategy) {
        this.updating = true;
        try {
            for (Component c : this.getComponents()) {
                if (deploymentStrategy == null) {
                    if (!(c instanceof JRadioButton)) continue;
                    ((JRadioButton)c).setSelected(false);
                    continue;
                }
                if (!(c instanceof JRadioButton) || deploymentStrategy != ((JRadioButton)c).getClientProperty(CLIENT_PROP_DEP_KIND)) continue;
                ((JRadioButton)c).setSelected(true);
            }
        }
        finally {
            this.updating = false;
        }
        this.insertUpdate(null);
    }

    @Override
    public void focusGained(FocusEvent e) {
        ((JTextComponent)e.getSource()).selectAll();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File f = new FileChooserBuilder(ChooseDeploymentStrategyPanelVisual.class).setTitle(NbBundle.getMessage(ChooseDeploymentStrategyPanelVisual.class, (String)"NAME_SIG_FILE_PANEL")).setFileFilter((FileFilter)new SigFilter()).showOpenDialog();
        if (f != null) {
            this.sigField.setText(f.getAbsolutePath());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        DeploymentStrategy deploymentStrategy = this.getDeploymentStrategy();
        this.sigField.setEnabled(deploymentStrategy == DeploymentStrategy.DEPLOY_TO_CARD);
        this.browseButton.setEnabled(deploymentStrategy == DeploymentStrategy.DEPLOY_TO_CARD);
        if (this.wiz != null && DeploymentStrategy.DEPLOY_TO_CARD.equals((Object)this.getDeploymentStrategy())) {
            if (this.sigField.isDisplayable() && this.sigField.getText().trim().length() == 0) {
                this.wiz.setValid(false);
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ChooseDeploymentStrategyPanelVisual.class, (String)"ERR_SIG_FILE_REQUIRED"));
                return;
            }
            File f = new File(this.sigField.getText());
            if (this.sigField.isDisplayable() && !f.exists()) {
                this.wiz.setValid(false);
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ChooseDeploymentStrategyPanelVisual.class, (String)"ERR_SIG_FILE_DOES_NOT_EXIST"));
                return;
            }
            if (this.sigField.isDisplayable() && f.isDirectory()) {
                this.wiz.setValid(false);
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ChooseDeploymentStrategyPanelVisual.class, (String)"ERR_SIG_FILE_IS_DIR"));
                return;
            }
        } else if (this.wiz == null || !DeploymentStrategy.DEPLOY_TO_CARD.equals((Object)deploymentStrategy)) {
            return;
        }
        this.wiz.setValid(true);
        this.wiz.putProperty("WizardPanel_errorMessage", null);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.insertUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.insertUpdate(e);
    }

    void setSigFile(File sigFile) {
        if (sigFile == null) {
            this.sigField.setText("");
        } else {
            this.sigField.setText(sigFile.getAbsolutePath());
        }
    }
}

