/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.mixeddev;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmSymbolResolver;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeSession;
import org.netbeans.modules.cnd.debugger.common2.debugger.State;
import org.netbeans.modules.cnd.debugger.common2.debugger.StateListener;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineType;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineTypeManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget.DebugTarget;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.utils.PsProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.mixeddev.java.JNISupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public final class MixedDevUtils {
    public static final String DOT = ".";
    public static final String COMMA = ",";
    public static final String LPAREN = "(";
    public static final String RPAREN = ")";
    public static final String SCOPE = "::";
    public static final String POINTER = "*";

    public static String stringize(Collection<? extends CharSequence> collection, CharSequence separator) {
        boolean first = true;
        StringBuilder result = new StringBuilder();
        for (CharSequence charSequence : collection) {
            if (!first) {
                result.append(separator);
            } else {
                first = false;
            }
            result.append(charSequence);
        }
        return result.toString();
    }

    public static String repeat(String pattern, int times) {
        StringBuilder sb = new StringBuilder();
        while (times-- > 0) {
            sb.append(pattern);
        }
        return sb.toString();
    }

    public static <K, V> Map<K, V> createMapping(Pair<K, V> ... pairs) {
        HashMap<Object, Object> mapping = new HashMap<Object, Object>();
        for (Pair<K, V> pair : pairs) {
            mapping.put(pair.first(), pair.second());
        }
        return Collections.unmodifiableMap(mapping);
    }

    public static <F, T> T[] transform(F[] from, Converter<F, T> converter, Class<T> toClass) {
        Object[] to = (Object[])Array.newInstance(toClass, from.length);
        for (int i = 0; i < from.length; ++i) {
            to[i] = converter.convert(from[i]);
        }
        return to;
    }

    public static <F, T> List<T> transform(List<F> from, Converter<F, T> converter) {
        ArrayList<T> to = new ArrayList<T>(from.size());
        for (F f : from) {
            to.add(converter.convert(f));
        }
        return to;
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : iterable) {
            result.add(t);
        }
        return result;
    }

    public static Iterable<NativeProject> findNativeProjects() {
        final Project[] projects = OpenProjects.getDefault().getOpenProjects();
        return new Iterable<NativeProject>(){

            @Override
            public Iterator<NativeProject> iterator() {
                return new Iterator<NativeProject>(){
                    private int i = 0;
                    private NativeProject nextProject = this.findNext();

                    @Override
                    public boolean hasNext() {
                        return this.nextProject != null;
                    }

                    @Override
                    public NativeProject next() {
                        NativeProject current = this.nextProject;
                        this.nextProject = this.findNext();
                        return current;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported.");
                    }

                    private NativeProject findNext() {
                        NativeProject nativeProject = null;
                        while (nativeProject == null && this.i < projects.length) {
                            nativeProject = (NativeProject)projects[this.i].getLookup().lookup(NativeProject.class);
                            ++this.i;
                        }
                        return nativeProject;
                    }
                };
            }
        };
    }

    public static CsmOffsetable findCppSymbol(String[] cppNames) {
        if (cppNames != null) {
            for (NativeProject nativeProject : MixedDevUtils.findNativeProjects()) {
                for (String cppName : cppNames) {
                    Collection candidates = CsmSymbolResolver.resolveSymbol((NativeProject)nativeProject, (CharSequence)cppName);
                    if (candidates.isEmpty()) continue;
                    return (CsmOffsetable)candidates.iterator().next();
                }
            }
        }
        return null;
    }

    public static MakeConfiguration findCppFunctionMakeConfiguration(String[] cppNames) {
        if (cppNames != null) {
            for (NativeProject nativeProject : MixedDevUtils.findNativeProjects()) {
                for (String cppName : cppNames) {
                    MakeConfigurationDescriptor descriptor;
                    ConfigurationDescriptorProvider provider;
                    Lookup.Provider project;
                    Collection candidates = CsmSymbolResolver.resolveGlobalFunction((NativeProject)nativeProject, (CharSequence)cppName);
                    if (candidates.isEmpty() || !((project = nativeProject.getProject()) instanceof Project) || (provider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class)) == null || !provider.gotDescriptor() || (descriptor = provider.getConfigurationDescriptor()) == null) continue;
                    return descriptor.getActiveConfiguration();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session attachToJavaProcess(String processFilter, String javaClassName, String javaMethodName, final boolean isAutoStart) {
        PsProvider.PsData psData = PsProvider.getDefault((Host)Host.getLocal()).getData(false);
        if (psData == null) {
            NativeDebuggerManager.warning((String)NbBundle.getMessage(MixedDevUtils.class, (String)"MSG_PS_Failed"));
            return null;
        }
        Vector processes = psData.processes(Pattern.compile(processFilter));
        if (processes.size() != 1) {
            NativeDebuggerManager.warning((String)NbBundle.getMessage(MixedDevUtils.class, (String)"MSG_ProcessDetectionError", (Object)processFilter));
            return null;
        }
        final String funcName = MethodMapper.getNativeName("" + javaClassName + DOT + javaMethodName);
        String stringPid = (String)((Vector)processes.firstElement()).get(psData.pidColumnIdx());
        final long longPid = Long.parseLong(stringPid);
        Session ret = MixedDevUtils.recognizeSessionByPid(longPid);
        if (ret == null) {
            NativeSession nativeSession;
            MakeConfiguration cppSymbolMakeConfiguration = MixedDevUtils.findCppFunctionMakeConfiguration(new String[]{funcName});
            DebugTarget target = new DebugTarget();
            MixedDevUtils.setDefaultEngine(target, ExecutionEnvironmentFactory.getLocal(), cppSymbolMakeConfiguration);
            target.setPid(longPid);
            target.setHostName("localhost");
            target.getConfig().setDevelopmentHost(new DevelopmentHostConfiguration(ExecutionEnvironmentFactory.getLocal()));
            target.setProjectMode(DebugTarget.ProjectMode.NO_PROJECT);
            final CountDownLatch latch = new CountDownLatch(1);
            NativeDebuggerManager.DebuggerStateListener listener = new NativeDebuggerManager.DebuggerStateListener(){

                public void notifyAttached(NativeDebugger debugger, long pid) {
                    if (pid == longPid) {
                        NativeDebuggerManager.get().removeDebuggerStateListener((NativeDebuggerManager.DebuggerStateListener)this);
                        if (!isAutoStart || funcName == null) {
                            debugger.stepTo(funcName);
                        }
                        latch.countDown();
                    }
                }
            };
            NativeDebuggerManager.get().addDebuggerStateListener(listener);
            NativeDebuggerManager.get().attach(isAutoStart, target);
            try {
                latch.await(100L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                NativeDebuggerManager.get().removeDebuggerStateListener(listener);
            }
            NativeDebugger currentDebugger = NativeDebuggerManager.get().currentDebugger();
            if (currentDebugger != null && (nativeSession = currentDebugger.session()) != null) {
                ret = nativeSession.coreSession();
            }
        } else {
            final NativeDebugger debugger = NativeSession.map((Session)ret).getDebugger();
            debugger.addStateListener(new StateListener(){

                public void update(State state) {
                    if (!state.isRunning) {
                        debugger.stepTo(funcName);
                        debugger.removeStateListener((StateListener)this);
                    }
                }
            });
            debugger.pause();
        }
        return ret;
    }

    private static Session recognizeSessionByPid(long pid) {
        for (NativeSession nativeSession : NativeDebuggerManager.get().getSessions()) {
            if (nativeSession.getPid() != pid) continue;
            return nativeSession.coreSession();
        }
        return null;
    }

    private static void setDefaultEngine(DebugTarget target, ExecutionEnvironment env, MakeConfiguration conf) {
        EngineType engine;
        CompilerSet defaultCompilerSet;
        EngineType engine2;
        CompilerSet compilerSet;
        if (conf != null && (compilerSet = conf.getCompilerSet().getCompilerSet()) != null && (engine2 = MixedDevUtils.getEngineFromCompilerSet(compilerSet)) != null) {
            target.setEngine(engine2);
            target.setCompilerSet(compilerSet);
            String id = EngineTypeManager.engine2DebugProfileID((EngineType)engine2);
            target.getDbgProfile().assign(conf.getAuxObject(id));
            return;
        }
        CompilerSetManager compilerSetManager = CompilerSetManager.get((ExecutionEnvironment)env);
        if (compilerSetManager != null && (defaultCompilerSet = compilerSetManager.getDefaultCompilerSet()) != null && (engine = MixedDevUtils.getEngineFromCompilerSet(defaultCompilerSet)) != null) {
            target.setEngine(engine);
            target.setCompilerSet(defaultCompilerSet);
        }
    }

    private static EngineType getEngineFromCompilerSet(CompilerSet cs) {
        Tool debuggerTool = cs.getTool((ToolKind)PredefinedToolKind.DebuggerTool);
        if (debuggerTool != null) {
            ToolchainManager.DebuggerDescriptor descriptor = (ToolchainManager.DebuggerDescriptor)debuggerTool.getDescriptor();
            return EngineTypeManager.getEngineTypeForDebuggerDescriptor((ToolchainManager.DebuggerDescriptor)descriptor);
        }
        return null;
    }

    private MixedDevUtils() {
        throw new AssertionError((Object)"Not instantiable");
    }

    private static final class MethodMapper {
        private MethodMapper() {
        }

        static String getNativeName(String javaName) {
            return JNISupport.getCppMethodSignature(javaName.replaceAll("[.]", "/"));
        }
    }

    public static interface Converter<F, T> {
        public T convert(F var1);
    }
}

