/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.actions;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.makeproject.api.DefaultProjectOperationsImplementationExecutor;
import org.netbeans.modules.cnd.makeproject.api.MakeProject;
import org.netbeans.modules.cnd.makeproject.ui.actions.DefaultProjectCopyPanel;
import org.netbeans.modules.cnd.makeproject.ui.actions.DefaultProjectDeletePanel;
import org.netbeans.modules.cnd.makeproject.ui.actions.DefaultProjectRenamePanel;
import org.netbeans.modules.cnd.makeproject.ui.actions.FileProxy;
import org.netbeans.modules.cnd.makeproject.uiapi.DefaultProjectOperationsImplementationUI;
import org.netbeans.spi.project.support.ProjectOperations;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class DefaultProjectOperationsImplementation
extends DefaultProjectOperationsImplementationUI {
    private static final Logger LOG = Logger.getLogger(DefaultProjectOperationsImplementation.class.getName());
    private static final double NOTIFY_WORK = 0.1;
    private static final double FIND_PROJECT_WORK = 0.1;
    static final int MAX_WORK = 100;

    private static String getDisplayName(Project project) {
        return ProjectUtils.getInformation((Project)project).getDisplayName();
    }

    public void deleteProject(MakeProject project, DefaultProjectOperationsImplementationExecutor executor) {
        GUIUserInputHandler handler = new GUIUserInputHandler();
        String displayName = DefaultProjectOperationsImplementation.getDisplayName((Project)project);
        FileObject projectFolder = project.getProjectDirectory();
        List dataFiles = ProjectOperations.getDataFiles((Project)project);
        ProgressHandle handle = ProgressHandle.createHandle((String)NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Delete_Project_Caption"));
        DefaultProjectDeletePanel deletePanel = new DefaultProjectDeletePanel(handle, displayName, FileUtil.getFileDisplayName((FileObject)projectFolder), !dataFiles.isEmpty());
        String caption = NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Delete_Project_Caption");
        handler.showConfirmationDialog(deletePanel, (Project)project, caption, "Yes_Button", "No_Button", true, () -> {
            deletePanel.addProgressBar();
            this.close((Project)project);
            if (deletePanel.isDeleteSources()) {
                try {
                    executor.doDeleteProject((Project)project, false, handle);
                }
                catch (IOException x) {
                    LOG.log(Level.WARNING, null, x);
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)x.getLocalizedMessage(), 0);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                }
                catch (Exception x) {
                    LOG.log(Level.WARNING, null, x);
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)x.getLocalizedMessage(), 0);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                }
            } else {
                try {
                    executor.doDeleteProject((Project)project, true, handle);
                }
                catch (IOException x) {
                    LOG.log(Level.WARNING, null, x);
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)x.getLocalizedMessage(), 0);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                }
                catch (Exception x) {
                    LOG.log(Level.WARNING, null, x);
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)x.getLocalizedMessage(), 0);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                }
            }
            deletePanel.removeProgressBar();
        });
        LOG.log(Level.FINE, "delete done: {0}", displayName);
    }

    public void copyProject(MakeProject project, DefaultProjectOperationsImplementationExecutor executor) {
        ProgressHandle handle = ProgressHandle.createHandle((String)NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Copy_Project_Handle"));
        DefaultProjectCopyPanel panel = new DefaultProjectCopyPanel(handle, (Project)project, false);
        handle.start(100);
        DefaultProjectOperationsImplementation.showConfirmationDialog(panel, (Project)project, NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Copy_Project_Caption"), "Copy_Button", null, false, () -> {
            String nueName = panel.getNewName();
            File newTarget = FileUtil.normalizeFile((File)panel.getNewDirectory());
            FileObject newTargetFO = FileUtil.toFileObject((File)newTarget);
            if (newTargetFO == null) {
                newTargetFO = this.createFolder(newTarget.getParentFile(), newTarget.getName());
            }
            FileObject newTgtFO = newTargetFO;
            project.getProjectDirectory().getFileSystem().runAtomicAction(() -> {
                try {
                    Project copy = executor.doCopyProject(handle, (Project)project, nueName, newTgtFO);
                    this.open(copy, false);
                }
                catch (IOException x) {
                    LOG.log(Level.WARNING, null, x);
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)x.getLocalizedMessage(), 0);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                }
                catch (Exception x) {
                    LOG.log(Level.WARNING, null, x);
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)x.getLocalizedMessage(), 0);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                }
            });
        });
    }

    public void moveProject(MakeProject project, DefaultProjectOperationsImplementationExecutor executor) {
        ProgressHandle handle = ProgressHandle.createHandle((String)NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Move_Project_Handle"));
        DefaultProjectCopyPanel panel = new DefaultProjectCopyPanel(handle, (Project)project, true);
        handle.start(100);
        Project main = OpenProjects.getDefault().getMainProject();
        boolean wasMain = main != null && project.getProjectDirectory().equals(main.getProjectDirectory());
        DefaultProjectOperationsImplementation.showConfirmationDialog(panel, (Project)project, NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Move_Project_Caption"), "Move_Button", null, false, () -> {
            this.close((Project)project);
            String nueFolderName = panel.getProjectFolderName();
            String nueProjectName = panel.getNewName();
            File newTarget = FileUtil.normalizeFile((File)panel.getNewDirectory());
            FileObject newTargetFO = FileUtil.toFileObject((File)newTarget);
            if (newTargetFO == null) {
                newTargetFO = this.createFolder(newTarget.getParentFile(), newTarget.getName());
            }
            FileObject newTgtFO = newTargetFO;
            try {
                Project move = executor.doMoveProject(handle, (Project)project, nueFolderName, nueProjectName, newTgtFO, true);
                this.open(move, wasMain);
            }
            catch (IOException x) {
                LOG.log(Level.WARNING, null, x);
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)x.getLocalizedMessage(), 0);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
            }
            catch (Exception x) {
                LOG.log(Level.WARNING, null, x);
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)x.getLocalizedMessage(), 0);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
            }
        });
    }

    public void renameProject(MakeProject project, DefaultProjectOperationsImplementationExecutor executor) {
        String nueName = null;
        ProgressHandle handle = ProgressHandle.createHandle((String)NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Rename_Project_Handle"));
        DefaultProjectRenamePanel panel = new DefaultProjectRenamePanel(handle, (Project)project, nueName);
        handle.start(100);
        Project main = OpenProjects.getDefault().getMainProject();
        boolean wasMain = main != null && project.getProjectDirectory().equals(main.getProjectDirectory());
        DefaultProjectOperationsImplementation.showConfirmationDialog(panel, (Project)project, NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Rename_Project_Caption"), "Rename_Button", null, false, () -> {
            String nueName1 = panel.getNewName();
            panel.addProgressBar();
            if (panel.getRenameProjectFolder()) {
                try {
                    Project move = executor.doMoveProject(handle, (Project)project, nueName1, nueName1, project.getProjectDirectory().getParent(), false);
                    this.close((Project)project);
                    this.open(move, wasMain);
                }
                catch (IOException x) {
                    LOG.log(Level.WARNING, null, x);
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)x.getLocalizedMessage(), 0);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                }
                catch (Exception x) {
                    LOG.log(Level.WARNING, null, x);
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)x.getLocalizedMessage(), 0);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                }
            } else {
                project.getProjectDirectory().getFileSystem().runAtomicAction(() -> {
                    try {
                        Project rename;
                        if (executor.isOldStyleRename(handle, (Project)project, nueName1)) {
                            this.close((Project)project);
                        }
                        if ((rename = executor.doRenameProject(handle, (Project)project, nueName1)) != null) {
                            this.open(rename, wasMain);
                        }
                    }
                    catch (IOException x) {
                        LOG.log(Level.WARNING, null, x);
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)x.getLocalizedMessage(), 0);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                    }
                    catch (Exception x) {
                        LOG.log(Level.WARNING, null, x);
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)x.getLocalizedMessage(), 0);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                    }
                });
            }
            panel.removeProgressBar();
        });
    }

    private FileObject createFolder(File parent, String name) throws IOException {
        FileObject path = FileUtil.toFileObject((File)parent);
        if (path != null) {
            return path.createFolder(name);
        }
        return this.createFolder(parent.getParentFile(), parent.getName()).createFolder(name);
    }

    private static JComponent wrapPanel(JComponent component) {
        component.setBorder(new EmptyBorder(12, 12, 12, 12));
        return component;
    }

    private static void showConfirmationDialog(final JComponent panel, Project project, String caption, String confirmButton, String cancelButton, boolean doSetMessageType, final Executor executor) {
        final JButton confirm = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)confirm, (String)NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)("LBL_" + confirmButton)));
        final JButton cancel = new JButton(cancelButton == null ? NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Cancel_Button") : NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)("LBL_" + cancelButton)));
        confirm.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)("ACSD_" + confirmButton)));
        cancel.getAccessibleContext().setAccessibleDescription(cancelButton == null ? NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"ACSD_Cancel_Button") : NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)("ACSD_" + cancelButton)));
        assert (panel instanceof InvalidablePanel);
        ((InvalidablePanel)((Object)panel)).addChangeListener(e -> confirm.setEnabled(((InvalidablePanel)((Object)panel)).isPanelValid()));
        confirm.setEnabled(((InvalidablePanel)((Object)panel)).isPanelValid());
        final Dialog[] dialog = new Dialog[1];
        DialogDescriptor dd = new DialogDescriptor((Object)(doSetMessageType ? panel : DefaultProjectOperationsImplementation.wrapPanel(panel)), caption, true, new Object[]{confirm, cancel}, (Object)(cancelButton != null ? cancel : confirm), 0, null, new ActionListener(){
            private boolean operationRunning;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.operationRunning) {
                    return;
                }
                if (dialog[0] instanceof JDialog) {
                    ((JDialog)dialog[0]).getRootPane().getInputMap(1).remove(KeyStroke.getKeyStroke(27, 0));
                    ((JDialog)dialog[0]).setDefaultCloseOperation(0);
                }
                this.operationRunning = true;
                if (e.getSource() == confirm) {
                    Container findParent;
                    confirm.setEnabled(false);
                    cancel.setEnabled(false);
                    ((InvalidablePanel)((Object)panel)).showProgress();
                    for (findParent = panel; findParent != null && !(findParent instanceof Window); findParent = findParent.getParent()) {
                    }
                    if (findParent != null) {
                        ((Window)findParent).pack();
                    }
                    RequestProcessor.getDefault().post(() -> {
                        AtomicReference<Throwable> ref = new AtomicReference<Throwable>();
                        try {
                            executor.execute();
                        }
                        catch (Throwable ex) {
                            ref.set(ex);
                            if (ex instanceof ThreadDeath) {
                                throw (ThreadDeath)ex;
                            }
                        }
                        finally {
                            SwingUtilities.invokeLater(() -> {
                                dialog[0].setVisible(false);
                                if (ref.get() != null) {
                                    LOG.log(Level.WARNING, null, (Throwable)ref.get());
                                }
                            });
                        }
                    });
                } else {
                    dialog[0].setVisible(false);
                }
            }
        });
        if (doSetMessageType) {
            dd.setMessageType(3);
        }
        dd.setClosingOptions(new Object[0]);
        dialog[0] = DialogDisplayer.getDefault().createDialog(dd);
        dialog[0].setVisible(true);
        dialog[0].dispose();
        dialog[0] = null;
    }

    @CheckForNull
    static String computeError(@NullAllowed FileProxy location, String projectNameText, boolean pureRename) {
        return DefaultProjectOperationsImplementation.computeError(location, projectNameText, null, pureRename);
    }

    @CheckForNull
    static String computeError(@NullAllowed FileProxy location, String projectNameText, String projectFolderText, boolean pureRename) {
        if (projectNameText.length() == 0) {
            return NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"ERR_Project_Name_Must_Entered");
        }
        if (projectNameText.indexOf(47) != -1 || projectNameText.indexOf(92) != -1) {
            return NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"ERR_Not_Valid_Filename", (Object)projectNameText);
        }
        if (location == null) {
            return null;
        }
        FileProxy parent = location;
        if (!location.exists()) {
            for (parent = location.getParentFile(); parent != null && !parent.exists(); parent = parent.getParentFile()) {
            }
            if (parent == null) {
                return NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"ERR_Location_Does_Not_Exist");
            }
        }
        if (!parent.canWrite()) {
            return NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"ERR_Location_Read_Only");
        }
        FileProxy projectFolderFile = null;
        projectFolderFile = projectFolderText == null ? location.getChild(projectNameText) : FileProxy.createAbsolute(location, projectFolderText);
        if (projectFolderFile.exists() && !pureRename) {
            return NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"ERR_Project_Folder_Exists");
        }
        return null;
    }

    private void close(Project prj) {
        LifecycleManager.getDefault().saveAll();
        OpenProjects.getDefault().close(new Project[]{prj});
    }

    private void open(Project prj, boolean setAsMain) {
        OpenProjects.getDefault().open(new Project[]{prj}, false);
        if (setAsMain) {
            OpenProjects.getDefault().setMainProject(prj);
        }
    }

    public static interface InvalidablePanel {
        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);

        public boolean isPanelValid();

        public void showProgress();
    }

    private static interface Executor {
        public void execute() throws Exception;
    }

    private static final class GUIUserInputHandler
    implements UserInputHandler {
        private GUIUserInputHandler() {
        }

        @Override
        public void showConfirmationDialog(JComponent panel, Project project, String caption, String confirmButton, String cancelButton, boolean doSetMessageType, Executor executor) {
            DefaultProjectOperationsImplementation.showConfirmationDialog(panel, project, caption, confirmButton, cancelButton, doSetMessageType, executor);
        }
    }

    static interface UserInputHandler {
        public void showConfirmationDialog(JComponent var1, Project var2, String var3, String var4, String var5, boolean var6, Executor var7);
    }
}

