/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.wizards.BuildSupport;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SelectModePanel;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FileAndFileObjectFilter;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class BjamScripSupport
implements BuildSupport.BuildFileProvider {
    private static final String[] pattern = new String[]{"b2"};

    public BuildSupport.BuildFile findBuildFileInFolder(FileObject folder, ExecutionEnvironment ee, CompilerSet compilerSet) {
        if (folder == null || !folder.isFolder() || !folder.canRead()) {
            return null;
        }
        for (String name : pattern) {
            FileObject makeFO = folder.getFileObject(name);
            if (makeFO == null || !makeFO.isValid() || !makeFO.isData() || !makeFO.canRead()) continue;
            return new BjamScriptArtifact(makeFO.getPath());
        }
        return null;
    }

    public BuildSupport.BuildFile scriptToBuildFile(String script) {
        String name = CndPathUtilities.getBaseName((String)script);
        if (name != null) {
            for (String predefined : pattern) {
                if (!predefined.equals(name)) continue;
                return new BjamScriptArtifact(script);
            }
        }
        return null;
    }

    public boolean isSupported(BuildSupport.BuildFile script) {
        return script instanceof BjamScriptArtifact;
    }

    public FileFilter[] getFileFilter() {
        return new FileFilter[]{new BjamFileFilter()};
    }

    public String getHint() {
        return NbBundle.getMessage(SelectModePanel.class, (String)"SelectModeSimpleInstructionExtraText_Bjam");
    }

    private static final class BjamFileFilter
    extends FileAndFileObjectFilter {
        private BjamFileFilter() {
        }

        public String getDescription() {
            return NbBundle.getMessage(BjamScripSupport.class, (String)"BjamFileFilter");
        }

        protected boolean mimeAccept(File f) {
            return this.acceptName(f.getName());
        }

        protected boolean mimeAccept(FileObject f) {
            return this.acceptName(f.getNameExt());
        }

        private boolean acceptName(String name) {
            return name != null && name.equals("b2");
        }

        protected String[] getSuffixes() {
            return new String[0];
        }
    }

    private static final class BjamScriptArtifact
    implements BuildSupport.BuildFile {
        private final String script;

        BjamScriptArtifact(String script) {
            this.script = script;
        }

        public String getFile() {
            return this.script;
        }

        public String getCleanCommandLine(String arguments, String workingDir) {
            String res = "./b2 --clean";
            if (arguments != null && !arguments.isEmpty()) {
                res = res + " " + arguments;
            }
            return res;
        }

        public String getBuildCommandLine(String arguments, String workingDir) {
            String res = "./b2 -a";
            if (arguments != null && !arguments.isEmpty()) {
                res = res + " " + arguments;
            }
            return res;
        }

        public String validate(ExecutionEnvironment ee, CompilerSet compilerSet) {
            return null;
        }
    }
}

