/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.hyperlink;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmExpressionResolver;
import org.netbeans.modules.cnd.api.model.services.CsmFunctionDefinitionResolver;
import org.netbeans.modules.cnd.api.model.services.CsmInstantiationProvider;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.support.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmTypeHierarchyResolver;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmAbstractHyperlinkProvider;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.modelutil.OverridesPopup;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.UIGesturesSupport;
import org.netbeans.modules.cnd.utils.ui.PopupUtil;
import org.openide.util.Exceptions;

public class CsmHyperlinkProvider
extends CsmAbstractHyperlinkProvider {
    @Override
    protected void performAction(Document doc, JTextComponent target, int offset, HyperlinkType type) {
        this.goToDeclaration(doc, target, offset, type);
    }

    @Override
    protected boolean isValidToken(TokenItem<TokenId> token, HyperlinkType type) {
        if (!CsmHyperlinkProvider.isSupportedToken(token, type)) {
            if (token != null && token.id() instanceof CppTokenId) {
                switch ((CppTokenId)token.id()) {
                    case AUTO: {
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    public static boolean isSupportedToken(TokenItem<TokenId> token, HyperlinkType type) {
        if (token != null) {
            if (type == HyperlinkType.ALT_HYPERLINK && ("whitespace".equals(token.id().primaryCategory()) || "comment".equals(token.id().primaryCategory()))) {
                return false;
            }
            if (token.id() instanceof CppTokenId) {
                switch ((CppTokenId)token.id()) {
                    case LTLT: 
                    case IDENTIFIER: 
                    case OPERATOR: 
                    case DELETE: 
                    case PROC_DIRECTIVE: {
                        return true;
                    }
                    case PREPROCESSOR_INCLUDE: 
                    case PREPROCESSOR_INCLUDE_NEXT: 
                    case PREPROCESSOR_SYS_INCLUDE: 
                    case PREPROCESSOR_USER_INCLUDE: {
                        return false;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean goToDeclaration(Document doc, JTextComponent target, int offset, HyperlinkType type) {
        if (!this.preJump(doc, target, offset, "opening-csm-element", type)) {
            return false;
        }
        CsmCacheManager.enter();
        try {
            CsmObject primary;
            TokenItem<TokenId> jumpToken = this.getJumpToken();
            CsmFile csmFile = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
            if (jumpToken.id() == CppTokenId.DELETE) {
                CsmClassifier classifier;
                primary = null;
                String deleteExpr = this.getRestExpression(doc, offset);
                CsmType resolvedType = CsmExpressionResolver.resolveType((CharSequence)deleteExpr, (CsmFile)csmFile, (int)offset, null);
                if (resolvedType != null && CsmKindUtilities.isClass((CsmObject)(classifier = CsmClassifierResolver.getDefault().getTypeClassifier(resolvedType, csmFile, offset, true)))) {
                    primary = CsmVirtualInfoQuery.getDefault().getFirstDestructor((CsmClass)classifier);
                }
            } else if (jumpToken.id() == CppTokenId.LTLT) {
                primary = null;
                int startExpression = this.getStartExpression(doc, offset);
                String rightOperand = this.getRightOperandExpression(doc, offset, CppTokenId.LTLT);
                CsmType rightType = CsmExpressionResolver.resolveType((CharSequence)rightOperand, (CsmFile)csmFile, (int)startExpression, null);
                if (rightType != null) {
                    CsmClassifier leftClassifier;
                    String leftOperand;
                    CsmType leftType;
                    CsmClassifier rightClassifier = CsmClassifierResolver.getDefault().getTypeClassifier(rightType, csmFile, offset, true);
                    if (CsmKindUtilities.isClass((CsmObject)rightClassifier)) {
                        for (CsmFriend friend : ((CsmClass)rightClassifier).getFriends()) {
                            if (!CsmKindUtilities.isOperator((CsmObject)friend) || !friend.getName().toString().endsWith(CppTokenId.LTLT.fixedText())) continue;
                            primary = friend;
                            break;
                        }
                    }
                    if (primary == null && (leftType = CsmExpressionResolver.resolveType((CharSequence)(leftOperand = this.getLeftmostOperandExpression(doc, offset, CppTokenId.LTLT)), (CsmFile)csmFile, (int)startExpression, null)) != null && CsmKindUtilities.isClass((CsmObject)(leftClassifier = CsmClassifierResolver.getDefault().getTypeClassifier(leftType, csmFile, offset, true)))) {
                        for (CsmMember member : ((CsmClass)leftClassifier).getMembers()) {
                            CsmParameter par;
                            CsmType aType;
                            Collection parameters;
                            if (!CsmKindUtilities.isOperator((CsmObject)member) || !member.getName().toString().endsWith(CppTokenId.LTLT.fixedText()) || (parameters = ((CsmFunction)member).getParameters()).size() != 1 || !this.isTypeEquals(aType = (par = (CsmParameter)parameters.iterator().next()).getType(), rightType)) continue;
                            primary = member;
                            break;
                        }
                    }
                }
            } else {
                primary = this.findTargetObject(doc, jumpToken, offset, false);
            }
            CsmOffsetable item = this.toJumpObject(primary, csmFile, offset);
            if (type == HyperlinkType.ALT_HYPERLINK) {
                Collection templateSpecializations;
                Collection baseTemplates;
                if (CsmKindUtilities.isFunction((CsmObject)item)) {
                    CsmFunction decl = CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)item));
                    baseTemplates = CsmInstantiationProvider.getDefault().getBaseTemplate((CsmDeclaration)decl);
                    templateSpecializations = CsmInstantiationProvider.getDefault().getSpecializations((CsmDeclaration)decl);
                    boolean inDeclaration = this.isInDeclaration(decl, csmFile, offset);
                    Collection baseMethods = new ArrayList(0);
                    Collection overriddenMethods = new ArrayList(0);
                    if (CsmKindUtilities.isMethod((CsmObject)decl)) {
                        CsmMethod meth = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)decl);
                        if (inDeclaration) {
                            baseMethods = CsmVirtualInfoQuery.getDefault().getFirstBaseDeclarations(meth);
                        }
                        if (!baseMethods.isEmpty() || CsmVirtualInfoQuery.getDefault().isVirtual(meth)) {
                            overriddenMethods = CsmVirtualInfoQuery.getDefault().getOverriddenMethods(meth, false);
                        }
                        baseMethods.remove(meth);
                    }
                    if (this.showOverridesPopup((CsmOffsetableDeclaration)(inDeclaration ? null : decl), baseMethods, overriddenMethods, baseTemplates, templateSpecializations, inDeclaration ? CsmKindUtilities.isFunctionDefinition((CsmObject)item) : true, target, offset)) {
                        UIGesturesSupport.submit((String)"USG_CND_HYPERLINK_METHOD", (Object[])new Object[]{type});
                        boolean meth = true;
                        return meth;
                    }
                } else if (CsmKindUtilities.isClass((CsmObject)item)) {
                    CsmClass cls = (CsmClass)item;
                    baseTemplates = CsmInstantiationProvider.getDefault().getBaseTemplate((CsmDeclaration)cls);
                    templateSpecializations = CsmInstantiationProvider.getDefault().getSpecializations((CsmDeclaration)cls);
                    ArrayList<CsmClass> subClasses = new ArrayList<CsmClass>(0);
                    Collection subRefs = CsmTypeHierarchyResolver.getDefault().getSubTypes(cls, false);
                    if (!subRefs.isEmpty()) {
                        for (CsmReference ref : subRefs) {
                            CsmObject obj = ref.getReferencedObject();
                            CndUtils.assertTrue((obj == null || obj instanceof CsmClass ? 1 : 0) != 0, (String)"getClassifier() should return either null or CsmClass");
                            if (!CsmKindUtilities.isClass((CsmObject)obj)) continue;
                            subClasses.add((CsmClass)obj);
                        }
                    }
                    if (this.showOverridesPopup(null, Collections.emptyList(), subClasses, baseTemplates, templateSpecializations, false, target, offset)) {
                        UIGesturesSupport.submit((String)"USG_CND_HYPERLINK_CLASS", (Object[])new Object[]{type});
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            UIGesturesSupport.submit((String)"USG_CND_HYPERLINK", (Object[])new Object[]{type});
            boolean bl = this.postJump(item, "goto_source_source_not_found", "cannot-open-csm-element");
            return bl;
        }
        finally {
            CsmCacheManager.leave();
        }
    }

    String getRightOperandExpression(final Document doc, final int offset, final CppTokenId endToken) {
        final AtomicReference out = new AtomicReference();
        doc.render(new Runnable(){

            @Override
            public void run() {
                TokenSequence cppTokenSequence = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)offset, (boolean)true, (boolean)false);
                if (cppTokenSequence == null) {
                    return;
                }
                cppTokenSequence.move(offset);
                if (cppTokenSequence.moveNext() && cppTokenSequence.moveNext()) {
                    Token token;
                    int start = cppTokenSequence.offset();
                    while (cppTokenSequence.moveNext() && (token = cppTokenSequence.token()).id() != CppTokenId.SEMICOLON && token.id() != endToken) {
                    }
                    int end = cppTokenSequence.offset();
                    try {
                        out.set(doc.getText(start, end - start).trim());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
        return (String)out.get();
    }

    String getLeftmostOperandExpression(final Document doc, final int offset, final CppTokenId endToken) {
        final AtomicReference out = new AtomicReference();
        doc.render(new Runnable(){

            @Override
            public void run() {
                TokenSequence cppTokenSequence = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)offset, (boolean)true, (boolean)false);
                if (cppTokenSequence == null) {
                    return;
                }
                cppTokenSequence.move(offset);
                if (cppTokenSequence.movePrevious()) {
                    Token token;
                    int end = cppTokenSequence.offset();
                    while (cppTokenSequence.movePrevious() && (token = cppTokenSequence.token()).id() != CppTokenId.SEMICOLON && token.id() != CppTokenId.LBRACE && token.id() != CppTokenId.RBRACE) {
                        if (token.id() != endToken) continue;
                        end = cppTokenSequence.offset();
                    }
                    int start = cppTokenSequence.offset();
                    try {
                        out.set(doc.getText(start + 1, end - start - 1).trim());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
        return (String)out.get();
    }

    int getStartExpression(final Document doc, final int offset) {
        final AtomicReference out = new AtomicReference();
        doc.render(new Runnable(){

            @Override
            public void run() {
                Token token;
                TokenSequence cppTokenSequence = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)offset, (boolean)true, (boolean)false);
                if (cppTokenSequence == null) {
                    return;
                }
                cppTokenSequence.move(offset);
                while (cppTokenSequence.movePrevious() && (token = cppTokenSequence.token()).id() != CppTokenId.SEMICOLON && token.id() != CppTokenId.LBRACE && token.id() != CppTokenId.RBRACE) {
                }
                out.set(cppTokenSequence.offset() + 1);
            }
        });
        return (Integer)out.get();
    }

    private boolean isTypeEquals(CsmType type1, CsmType type2) {
        if (type1 != null && type2 != null) {
            CsmType aType;
            CsmClassifier cls2;
            CsmType aType2;
            CsmClassifier cls1 = type1.getClassifier();
            if (CsmKindUtilities.isTypedef((CsmObject)cls1) && (aType2 = ((CsmTypedef)cls1).getType()) != null) {
                type1 = aType2;
            }
            if (CsmKindUtilities.isTypedef((CsmObject)(cls2 = type2.getClassifier())) && (aType = ((CsmTypedef)cls2).getType()) != null) {
                type2 = aType;
            }
            String canonicalText1 = type1.getCanonicalText().toString().replace("const const", "const");
            String canonicalText2 = type2.getCanonicalText().toString().replace("const const", "const");
            return canonicalText1.equals(canonicalText2);
        }
        return false;
    }

    String getRestExpression(final Document doc, final int offset) {
        final AtomicReference out = new AtomicReference();
        doc.render(new Runnable(){

            @Override
            public void run() {
                TokenSequence cppTokenSequence = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)offset, (boolean)true, (boolean)false);
                if (cppTokenSequence == null) {
                    return;
                }
                cppTokenSequence.move(offset);
                if (cppTokenSequence.moveNext() && cppTokenSequence.moveNext()) {
                    Token token;
                    int start = cppTokenSequence.offset();
                    while (cppTokenSequence.moveNext() && (token = cppTokenSequence.token()).id() != CppTokenId.SEMICOLON) {
                    }
                    int end = cppTokenSequence.offset();
                    try {
                        out.set(doc.getText(start, end - start));
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
        return (String)out.get();
    }

    private boolean showOverridesPopup(CsmOffsetableDeclaration mainDeclaration, Collection<? extends CsmOffsetableDeclaration> baseDeclarations, Collection<? extends CsmOffsetableDeclaration> descendantDeclarations, Collection<? extends CsmOffsetableDeclaration> baseTemplates, Collection<? extends CsmOffsetableDeclaration> templateSpecializations, boolean gotoDefinitions, JTextComponent target, int offset) {
        if (!(baseDeclarations.isEmpty() && descendantDeclarations.isEmpty() && baseDeclarations.isEmpty() && templateSpecializations.isEmpty())) {
            try {
                final OverridesPopup popup = new OverridesPopup(null, mainDeclaration, baseDeclarations, descendantDeclarations, baseTemplates, templateSpecializations, gotoDefinitions);
                Rectangle rect = target.modelToView(offset);
                final Point point = new Point((int)rect.getX(), (int)(rect.getY() + rect.getHeight()));
                SwingUtilities.convertPointToScreen(point, target);
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        PopupUtil.showPopup((JComponent)popup, null, (int)point.x, (int)point.y, (boolean)true, (int)0);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runner.run();
                } else {
                    SwingUtilities.invokeLater(runner);
                }
                return true;
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return false;
    }

    CsmObject findTargetObject(Document doc, TokenItem<TokenId> jumpToken, int offset, boolean toOffsetable) {
        CsmObject csmObject;
        CsmObject item = null;
        assert (jumpToken != null);
        CsmFile file = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
        CsmObject csmObject2 = csmObject = file == null ? null : ReferencesSupport.findDeclaration(file, doc, jumpToken, offset);
        if (csmObject != null) {
            item = toOffsetable ? this.toJumpObject(csmObject, file, offset) : csmObject;
        }
        return item;
    }

    private boolean isInDeclaration(CsmFunction func, CsmFile csmFile, int offset) {
        CsmFunction decl;
        CsmFunctionDefinition def;
        if (CsmKindUtilities.isFunctionDefinition((CsmObject)func)) {
            def = (CsmFunctionDefinition)func;
            decl = def.getDeclaration();
        } else {
            decl = func;
            def = func.getDefinition();
        }
        if (def != null && csmFile.equals(def.getContainingFile()) && def.getStartOffset() <= offset && offset <= def.getBody().getStartOffset()) {
            return true;
        }
        return decl != null && csmFile.equals(decl.getContainingFile()) && decl.getStartOffset() <= offset && offset <= decl.getEndOffset();
    }

    protected CsmOffsetable toJumpObject(CsmObject csmObject, CsmFile csmFile, int offset) {
        Object item = null;
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            item = (CsmOffsetable)csmObject;
            if (CsmKindUtilities.isFunctionDeclaration((CsmObject)csmObject)) {
                CsmFunctionDefinition definition = ((CsmFunction)csmObject).getDefinition();
                if (definition != null) {
                    if (csmFile.equals(definition.getContainingFile()) && definition.getStartOffset() <= offset && offset <= definition.getBody().getStartOffset()) {
                        if (definition.getDeclaration() != null) {
                            item = definition.getDeclaration();
                        } else if (csmObject.equals(definition)) {
                            item = (CsmOffsetable)csmObject;
                        }
                    } else {
                        item = definition;
                    }
                } else {
                    CsmReference ref = CsmFunctionDefinitionResolver.getDefault().getFunctionDefinition((CsmFunction)csmObject);
                    if (ref != null) {
                        item = ref;
                    }
                }
            } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject)) {
                CsmFunctionDefinition definition = (CsmFunctionDefinition)csmObject;
                if (csmFile.equals(definition.getContainingFile()) && definition.getStartOffset() <= offset && offset <= definition.getBody().getStartOffset()) {
                    item = definition.getDeclaration() != null ? definition.getDeclaration() : definition;
                }
            } else if (CsmKindUtilities.isVariableDeclaration((CsmObject)csmObject)) {
                CsmVariableDefinition definition = ((CsmVariable)csmObject).getDefinition();
                if (definition != null) {
                    item = definition;
                    if (csmFile.equals(definition.getContainingFile()) && definition.getStartOffset() <= offset && offset <= definition.getEndOffset()) {
                        item = (CsmVariable)csmObject;
                    }
                }
            } else if (CsmClassifierResolver.getDefault().isForwardClassifier(csmObject)) {
                CsmClassifier cls = CsmClassifierResolver.getDefault().getOriginalClassifier((CsmClassifier)csmObject, csmFile);
                if (CsmKindUtilities.isOffsetable((Object)cls)) {
                    item = (CsmOffsetable)cls;
                }
            } else if (CsmKindUtilities.isTypedef((CsmObject)csmObject)) {
                CsmClassifier cls;
                CsmClassifier typeCls;
                CsmTypedef td = (CsmTypedef)csmObject;
                CsmType type = td.getType();
                CsmClassifier csmClassifier = typeCls = type != null ? type.getClassifier() : null;
                if (CsmKindUtilities.isOffsetable((Object)typeCls) && (CsmKindUtilities.isClassForwardDeclaration((CsmObject)typeCls) || CsmKindUtilities.isEnumForwardDeclaration((CsmObject)typeCls)) && td.getQualifiedName().equals(typeCls.getQualifiedName()) && CsmKindUtilities.isOffsetable((Object)(cls = CsmClassifierResolver.getDefault().getOriginalClassifier(typeCls, csmFile)))) {
                    item = (CsmOffsetable)cls;
                }
            }
        } else if (CsmKindUtilities.isNamespace((Object)csmObject)) {
            CsmNamespace nmsp = (CsmNamespace)csmObject;
            Collection defs = nmsp.getDefinitions();
            CsmNamespaceDefinition bestDef = null;
            for (CsmNamespaceDefinition def : defs) {
                CsmFile container;
                if (bestDef == null) {
                    bestDef = def;
                }
                if (!csmFile.equals(container = def.getContainingFile())) continue;
                bestDef = def;
                break;
            }
            item = bestDef;
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getTooltipText(Document doc, TokenItem<TokenId> token, int offset, HyperlinkType type) {
        CsmCacheManager.enter();
        try {
            CharSequence msg;
            CsmObject item = this.findTargetObject(doc, token, offset, false);
            CharSequence charSequence = msg = item == null ? null : CsmDisplayUtilities.getTooltipText((CsmObject)item);
            if (msg != null) {
                if (CsmKindUtilities.isMacro((CsmObject)item)) {
                    msg = this.getAlternativeHyperlinkTip(doc, "AltMacroHyperlinkHint", msg);
                } else if (CsmKindUtilities.isMethod((CsmObject)item)) {
                    msg = this.getAlternativeHyperlinkTip(doc, "AltMethodHyperlinkHint", msg);
                } else if (CsmKindUtilities.isClass((CsmObject)item)) {
                    msg = this.getAlternativeHyperlinkTip(doc, "AltClassHyperlinkHint", msg);
                }
            }
            String string = msg == null ? null : msg.toString();
            return string;
        }
        finally {
            CsmCacheManager.leave();
        }
    }
}

