/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.doxygensupport;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.swing.Action;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectSupport;
import org.netbeans.modules.cnd.completion.doxygensupport.Man2HTML;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ManDocumentation {
    private static final String MAN_PAGES_CACHE_ENCODING = "UTF-8";
    private static final Map<String, String> TRANSLATE = new HashMap<String, String>();

    public static CompletionDocumentation getDocumentation(CsmObject obj, CsmFile file) throws IOException {
        CsmScope scope;
        if (CsmKindUtilities.isFunction((CsmObject)obj) && !CsmKindUtilities.isClassMember((CsmObject)obj)) {
            CsmFunction function = (CsmFunction)obj;
            return ManDocumentation.getDoc(function.getQualifiedName().toString(), file);
        }
        if (CsmKindUtilities.isClass((CsmObject)obj)) {
            CsmClass cls = (CsmClass)obj;
            return ManDocumentation.getDoc(cls.getQualifiedName().toString(), file);
        }
        if (CsmKindUtilities.isClassMember((CsmObject)obj) && CsmKindUtilities.isClass((CsmObject)(scope = ((CsmMember)obj).getScope()))) {
            CsmClass cls = (CsmClass)scope;
            return ManDocumentation.getDoc(cls.getQualifiedName().toString(), file);
        }
        return null;
    }

    private static CompletionDocumentation getDoc(String name, CsmFile file) throws IOException {
        block5: {
            if (name.indexOf(60) > 0) {
                name = name.substring(0, name.indexOf(60));
            }
            try {
                CompletionDocumentation documentation = ManDocumentation.getDocumentation(name, file);
                if (documentation != null) {
                    return documentation;
                }
            }
            catch (IOException ex) {
                if (name.contains("::")) break block5;
                throw ex;
            }
        }
        if (name.contains("::")) {
            name = name.substring(name.lastIndexOf(58) + 1);
            return ManDocumentation.getDocumentation(name, file);
        }
        return null;
    }

    public static CompletionDocumentation getDocumentation(String name, CsmFile file) throws IOException {
        return ManDocumentation.getDocumentation(name, 3, file);
    }

    public static CompletionDocumentation getDocumentation(String name, int chapter, CsmFile file) throws IOException {
        String doc = ManDocumentation.getDocumentationForName(name, chapter, file);
        if (doc == null) {
            return null;
        }
        return new CompletionDocumentationImpl(doc, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDocumentationForName(String name, int chapter, CsmFile file) throws IOException {
        NativeProject np = ManDocumentation.getNativeProject(file);
        if (np == null) {
            return "";
        }
        String platformName = NativeProjectSupport.getPlatformName((NativeProject)np);
        File cache = ManDocumentation.getCacheFile(name, chapter, platformName);
        if (cache.exists()) {
            return ManDocumentation.readFile(cache);
        }
        String doc = ManDocumentation.createDocumentationForName(name, chapter, np);
        if (doc != null) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(cache);
                ((OutputStream)out).write(doc.getBytes(MAN_PAGES_CACHE_ENCODING));
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            finally {
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            return doc;
        }
        return null;
    }

    private static File getCacheFile(String name, int chapter, String platformName) {
        String safeName;
        try {
            safeName = URLEncoder.encode(name, MAN_PAGES_CACHE_ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            safeName = name;
        }
        return Places.getCacheSubfile((String)("cnd/manpages/" + safeName + "." + platformName + "." + chapter));
    }

    static NativeProject getNativeProject(CsmFile csmFile) {
        NativeProject nativeProject = null;
        if (csmFile != null) {
            CsmProject csmProject = csmFile.getProject();
            if (csmProject.getPlatformProject() instanceof NativeProject) {
                nativeProject = (NativeProject)csmProject.getPlatformProject();
            } else {
                block0: for (CsmProject project : CsmModelAccessor.getModel().projects()) {
                    for (CsmProject lib : project.getLibraries()) {
                        if (!lib.equals(csmProject) || !(project.getPlatformProject() instanceof NativeProject)) continue;
                        nativeProject = (NativeProject)project.getPlatformProject();
                        break block0;
                    }
                }
            }
        }
        return nativeProject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String createDocumentationForName(String name, int chapter, NativeProject np) throws IOException {
        NativeProjectSupport.NativeExitStatus exitStatus;
        String platformName = NativeProjectSupport.getPlatformName((NativeProject)np);
        if (platformName == null) {
            exitStatus = NativeProjectSupport.execute((NativeProject)np, (String)"man", (String[])new String[]{"MANWIDTH=65"}, (String[])new String[]{name});
        } else if (platformName.contains("Solaris")) {
            NativeProjectSupport.NativeExitStatus es = NativeProjectSupport.execute((NativeProject)np, (String)"man", (String[])new String[0], (String[])new String[]{"-l", name});
            String section = ManDocumentation.getSection(es.output, "(2");
            if (section == null) {
                section = ManDocumentation.getSection(es.output, "(3");
            }
            exitStatus = section != null ? NativeProjectSupport.execute((NativeProject)np, (String)"man", null, (String[])new String[]{"-s" + section, name}) : NativeProjectSupport.execute((NativeProject)np, (String)"man", null, (String[])new String[]{name});
        } else {
            String DOT_UTF8 = ".UTF-8";
            exitStatus = NativeProjectSupport.execute((NativeProject)np, (String)"man", (String[])new String[]{"MANWIDTH=65", "LANG=" + Locale.getDefault().toString().trim().replace(".UTF-8", "") + ".UTF-8"}, (String[])new String[]{"-S2:3", name});
        }
        if (exitStatus == null) return null;
        if (!exitStatus.isOK() || exitStatus.output.length() <= 0) throw new IOException(exitStatus.error);
        if (exitStatus.output.split("\n").length <= 2) {
            return null;
        }
        StringReader sr = new StringReader(exitStatus.output);
        BufferedReader br = new BufferedReader(sr);
        String text = new Man2HTML(br).getHTML();
        br.close();
        sr.close();
        return text;
    }

    private static String getSection(String output, String number) {
        String section = null;
        int index1 = output.indexOf(number);
        while (index1 >= 0) {
            if (output.charAt(index1 + 2) != 'f') {
                int index2 = output.substring(index1).indexOf(")");
                section = output.substring(index1 + 1, index1 + index2);
                break;
            }
            output = output.substring(index1 + 1);
            index1 = output.indexOf(number);
        }
        return section;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File f) throws IOException {
        FileInputStream fin = null;
        InputStream in = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            fin = new FileInputStream(f);
            in = f.getName().endsWith(".gz") ? new GZIPInputStream(fin) : fin;
            FileUtil.copy((InputStream)in, (OutputStream)out);
            String string = out.toString(MAN_PAGES_CACHE_ENCODING);
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            if (fin != null) {
                try {
                    ((InputStream)fin).close();
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            try {
                out.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static String getString(String s) {
        return NbBundle.getBundle(ManDocumentation.class).getString(s);
    }

    static {
        TRANSLATE.put("&minus;", "-");
        TRANSLATE.put("&lsquo;", "'");
        TRANSLATE.put("&rsquo;", "'");
    }

    private static final class CompletionDocumentationImpl
    implements CompletionDocumentation {
        private String doc;
        private CsmFile file;

        public CompletionDocumentationImpl(String doc, CsmFile file) {
            this.doc = doc;
            this.file = file;
        }

        public String getText() {
            return this.doc;
        }

        public URL getURL() {
            return null;
        }

        public CompletionDocumentation resolveLink(String link) {
            String[] parts = link.split("\\?");
            if (parts.length != 2) {
                return null;
            }
            String[] chapterAndName = parts[1].split("\\+");
            if (chapterAndName.length != 2) {
                return null;
            }
            int chapter = Integer.parseInt(chapterAndName[0]);
            String name = chapterAndName[1];
            try {
                return ManDocumentation.getDocumentation(name, chapter, this.file);
            }
            catch (IOException ioe) {
                return new CompletionDocumentationImpl(ioe.getMessage(), this.file);
            }
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }
}

