/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.apt;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.api.PPIncludeHandler;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageFilter;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.debug.DebugUtils;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContent;
import org.netbeans.modules.cnd.modelimpl.content.project.FileContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FilePreprocessorConditionState;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTBasedPCStateBuilder;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTParseFileWalker;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTRestorePreprocStateWalker;
import org.netbeans.modules.cnd.modelimpl.parser.spi.TokenStreamProducer;
import org.netbeans.modules.cnd.support.Interrupter;
import org.openide.util.Pair;

public final class APTTokenStreamProducer
extends TokenStreamProducer {
    private final APTFile fullAPT;
    private PreprocHandler curPreprocHandler;
    private APTBasedPCStateBuilder pcBuilder;
    private Pair<PreprocHandler.State, APTFileCacheEntry> cachePair;
    private static final boolean REMEMBER_RESTORED = TraceFlags.CLEAN_MACROS_AFTER_PARSE && (DebugUtils.getBoolean((String)"cnd.remember.restored", (boolean)false) || ProjectBase.TRACE_PP_STATE_OUT);
    private static volatile List<String> testRestoredFiles = null;

    private APTTokenStreamProducer(FileImpl file, FileContent newFileContent, APTFile fullAPT, boolean fromEnsureParsed) {
        super(file, newFileContent, fromEnsureParsed);
        this.fullAPT = fullAPT;
    }

    public static TokenStreamProducer createImpl(FileImpl file, FileContent newFileContent, boolean fromEnsureParsed) {
        APTFile fullAPT = APTTokenStreamProducer.getFileAPT(file, true);
        if (fullAPT == null) {
            return null;
        }
        return new APTTokenStreamProducer(file, newFileContent, fullAPT, fromEnsureParsed);
    }

    @Override
    public TokenStream getTokenStreamOfIncludedFile(PreprocHandler.State includeOwnerState, CsmInclude include, Interrupter interrupter) {
        FileImpl includedFile = (FileImpl)include.getIncludeFile();
        if (includedFile == null) {
            return null;
        }
        ProjectBase projectImpl = includedFile.getProjectImpl(true);
        if (projectImpl == null) {
            return null;
        }
        LinkedList reverseInclStack = APTHandlersSupport.extractIncludeStack((PreprocHandler.State)includeOwnerState);
        PPIncludeHandler.IncludeInfo inclInfo = APTTokenStreamProducer.createIncludeInfo(include);
        if (inclInfo == null) {
            return null;
        }
        reverseInclStack.addLast(inclInfo);
        FileImpl ownerFile = this.getInterestedFile();
        CharSequence ownerAbsPath = ownerFile.getAbsolutePath();
        PreprocHandler preprocHandler = projectImpl.createEmptyPreprocHandler(ownerAbsPath);
        PreprocHandler restorePreprocHandlerFromIncludeStack = APTTokenStreamProducer.restorePreprocHandlerFromIncludeStack(projectImpl, reverseInclStack, ownerAbsPath, preprocHandler, includeOwnerState, Interrupter.DUMMY);
        this.resetHandler(restorePreprocHandlerFromIncludeStack);
        TokenStream includedFileTS = this.createParsingTokenStreamForHandler(includedFile, restorePreprocHandlerFromIncludeStack, true);
        return includedFileTS;
    }

    public static List<String> testGetRestoredFiles() {
        return testRestoredFiles;
    }

    public static PreprocHandler restorePreprocHandlerFromIncludeStack(ProjectBase project, LinkedList<PPIncludeHandler.IncludeInfo> reverseInclStack, CharSequence interestedFile, PreprocHandler preprocHandler, PreprocHandler.State state, final Interrupter interrupter) {
        assert (!reverseInclStack.isEmpty()) : "state of stack is " + reverseInclStack;
        LinkedList<PPIncludeHandler.IncludeInfo> inclStack = Utils.reverse(reverseInclStack);
        ProjectBase.StartEntryInfo sei = project.getStartEntryInfo(preprocHandler, state);
        FileImpl csmFile = sei.csmFile;
        ProjectBase startProject = sei.startProject;
        preprocHandler = sei.preprocHandler;
        APTFile aptLight = null;
        try {
            aptLight = csmFile == null ? null : APTTokenStreamProducer.getAPTLight(csmFile);
        }
        catch (IOException ex) {
            System.err.println("can't restore preprocessor state for " + interestedFile + "\nreason: " + ex.getMessage());
            DiagnosticExceptoins.register(ex);
        }
        boolean ppStateRestored = false;
        if (aptLight != null) {
            long time = REMEMBER_RESTORED ? System.currentTimeMillis() : 0L;
            int stackSize = inclStack.size();
            APTFileCacheEntry cacheEntry = csmFile.getAPTCacheEntry(state, Boolean.FALSE);
            APTRestorePreprocStateWalker walker = new APTRestorePreprocStateWalker(startProject, aptLight, csmFile, preprocHandler, inclStack, FileContainer.getFileKey(interestedFile, false).toString(), cacheEntry){

                protected boolean isStopped() {
                    return super.isStopped() || interrupter.cancelled();
                }
            };
            walker.visit();
            if (preprocHandler.isValid()) {
                if (REMEMBER_RESTORED) {
                    if (testRestoredFiles == null) {
                        testRestoredFiles = new ArrayList<String>();
                    }
                    FileImpl interestedFileImpl = project.getFile(interestedFile, false);
                    assert (interestedFileImpl != null);
                    String msg = interestedFile + " [" + (interestedFileImpl.isHeaderFile() ? "H" : (interestedFileImpl.isSourceFile() ? "S" : "U")) + "]";
                    time = System.currentTimeMillis() - time;
                    msg = msg + " within " + time + "ms" + " stack " + stackSize + " elems";
                    System.err.println("#" + testRestoredFiles.size() + " restored: " + msg);
                    testRestoredFiles.add(msg);
                }
                if (ProjectBase.TRACE_PP_STATE_OUT) {
                    System.err.println("after restoring " + preprocHandler);
                }
                ppStateRestored = true;
            }
        }
        if (!ppStateRestored) {
            if (startProject == null) {
                startProject = project;
            }
            preprocHandler = startProject.createDefaultPreprocHandler(interestedFile);
        }
        return preprocHandler;
    }

    private TokenStream createParsingTokenStreamForHandler(FileImpl fileImpl, PreprocHandler preprocHandler, boolean filterOutComments) {
        APTFile apt = APTTokenStreamProducer.getFileAPT(fileImpl, true);
        if (apt == null) {
            return null;
        }
        if (preprocHandler == null) {
            return null;
        }
        PreprocHandler.State ppState = preprocHandler.getState();
        ProjectBase startProject = Utils.getStartProject(ppState);
        if (startProject == null) {
            System.err.println(" null project for " + APTHandlersSupport.extractStartEntry((PreprocHandler.State)ppState) + "\n while getting TS of file " + fileImpl.getAbsolutePath() + "\n of project " + fileImpl.getProject());
            return null;
        }
        this.pcBuilder = new APTBasedPCStateBuilder(fileImpl.getAbsolutePath());
        APTFileCacheEntry cacheEntry = fileImpl.getAPTCacheEntry(ppState, Boolean.FALSE);
        APTParseFileWalker walker = new APTParseFileWalker(startProject, apt, fileImpl, preprocHandler, false, this.pcBuilder, cacheEntry);
        return walker.getTokenStream(filterOutComments);
    }

    @Override
    public TokenStream getTokenStreamForParsingAndCaching(Interrupter interrupter) {
        return this.getTokenStream(false, true, false, interrupter);
    }

    @Override
    public TokenStream getTokenStreamForParsing(String language, Interrupter interrupter) {
        return this.getTokenStream(true, "Fortran Language".equals(language), true, interrupter);
    }

    @Override
    public TokenStream getTokenStreamForCaching(Interrupter interrupter) {
        return this.getTokenStream(false, true, false, interrupter);
    }

    private TokenStream getTokenStream(boolean triggerParsingActivity, boolean needComments, boolean applyLanguageFilter, Interrupter interrupter) {
        TokenStream tsOut;
        PreprocHandler.State ppState;
        ProjectBase startProject;
        FileImpl fileImpl = this.getInterestedFile();
        PreprocHandler preprocHandler = this.getCurrentPreprocHandler();
        if (TraceFlags.TRACE_CACHE) {
            System.err.println("CACHE: parsing using full APT for " + fileImpl.getAbsolutePath());
        }
        if ((startProject = Utils.getStartProject(ppState = preprocHandler.getState())) == null) {
            System.err.println(" null project for " + APTHandlersSupport.extractStartEntry((PreprocHandler.State)ppState) + "\n while parsing file " + fileImpl.getAbsolutePath() + "\n of project " + fileImpl.getProject());
            return null;
        }
        this.pcBuilder = new APTBasedPCStateBuilder(fileImpl.getAbsolutePath());
        APTFileCacheEntry aptCacheEntry = fileImpl.getAPTCacheEntry(ppState, Boolean.FALSE);
        APTParseFileWalker walker = new APTParseFileWalker(startProject, this.fullAPT, fileImpl, preprocHandler, triggerParsingActivity, this.pcBuilder, aptCacheEntry);
        walker.setFileContent(this.getFileContent());
        if (TraceFlags.DEBUG) {
            System.err.println("doParse " + fileImpl.getAbsolutePath() + " with " + ParserQueue.tracePreprocState(ppState));
        }
        if (applyLanguageFilter) {
            APTLanguageFilter languageFilter = fileImpl.getLanguageFilter(ppState);
            tsOut = walker.getFilteredTokenStream(languageFilter);
        } else {
            boolean filterOutComments = !needComments;
            tsOut = walker.getTokenStream(filterOutComments);
        }
        if (this.isAllowedToCacheOnRelease()) {
            this.cachePair = Pair.of((Object)ppState, (Object)aptCacheEntry);
        }
        return tsOut;
    }

    @Override
    public FilePreprocessorConditionState release() {
        if (this.isAllowedToCacheOnRelease()) {
            assert (this.cachePair != null);
            FileImpl fileImpl = this.getInterestedFile();
            fileImpl.setAPTCacheEntry((PreprocHandler.State)this.cachePair.first(), (APTFileCacheEntry)this.cachePair.second(), false);
        }
        return this.pcBuilder.build();
    }

    static final APTFile getAPTLight(CsmFile csmFile) throws IOException {
        CharSequence guardMacro;
        FileImpl fileImpl = (FileImpl)csmFile;
        APTFile aptLight = APTTokenStreamProducer.getFileAPT(fileImpl, false);
        if (aptLight != null && APTUtils.LOG.isLoggable(Level.FINE) && (guardMacro = aptLight.getGuardMacro()).length() == 0 && !fileImpl.isSourceFile()) {
            APTUtils.LOG.log(Level.FINE, "FileImpl: file {0} does not have guard", new Object[]{fileImpl.getAbsolutePath()});
        }
        return aptLight;
    }

    public static APTFile getFileAPT(FileImpl file, boolean full) {
        CharSequence guardMacro;
        APTFile fileAPT = null;
        try {
            fileAPT = full ? APTDriver.findAPT((APTFileBuffer)file.getBuffer(), (String)file.getFileLanguage(), (String)file.getFileLanguageFlavor()) : APTDriver.findAPTLight((APTFileBuffer)file.getBuffer());
        }
        catch (FileNotFoundException ex) {
            APTUtils.LOG.log(Level.WARNING, "FileImpl: file {0} not found, probably removed", new Object[]{file.getBuffer().getAbsolutePath()});
        }
        catch (IOException ex) {
            DiagnosticExceptoins.register(ex);
        }
        if (fileAPT != null && APTUtils.LOG.isLoggable(Level.FINE) && (guardMacro = fileAPT.getGuardMacro()).length() == 0 && !file.isSourceFile()) {
            APTUtils.LOG.log(Level.FINE, "FileImpl: file {0} does not have guard", new Object[]{file.getBuffer().getAbsolutePath()});
        }
        return fileAPT;
    }
}

