/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.platform;

import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;

public class CndIndexer
extends CustomIndexer {
    private static volatile Delegate delegate;
    public static final String NAME = "cnd";

    static void setDelegate(Delegate d) {
        delegate = d;
    }

    protected void index(Iterable<? extends Indexable> files, Context context) {
        if (!CndTraceFlags.USE_INDEXING_API) {
            return;
        }
        if (context.isAllFilesIndexing()) {
            return;
        }
        FileObject root = context.getRoot();
        for (Indexable indexable : files) {
            FileObject fo = root.getFileObject(indexable.getRelativePath());
            if (delegate == null) continue;
            delegate.index(fo);
        }
    }

    public static final class Factory
    extends CustomIndexerFactory {
        public CustomIndexer createIndexer() {
            return new CndIndexer();
        }

        public boolean supportsEmbeddedIndexers() {
            return false;
        }

        public void filesDeleted(Iterable<? extends Indexable> files, Context context) {
            if (!CndTraceFlags.USE_INDEXING_API) {
                return;
            }
            FileObject root = context.getRoot();
            if (delegate != null && root != null) {
                delegate.removed(root);
            }
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
        }

        public String getIndexerName() {
            return CndIndexer.NAME;
        }

        public int getIndexVersion() {
            return 1;
        }
    }

    static interface Delegate {
        public void index(FileObject var1);

        public void removed(FileObject var1);
    }
}

