/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.cli.GitConflictDescriptor;
import org.netbeans.modules.git.remote.cli.GitStatus;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.StatusCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.git.remote.cli.progress.StatusListener;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public abstract class StatusCommandBase
extends GitCommand {
    private final LinkedHashMap<VCSFileProxy, GitStatus> statuses;
    private final VCSFileProxy[] roots;
    private final ProgressMonitor monitor;
    private final StatusListener listener;
    private final String revision;
    private static final Logger LOG = Logger.getLogger(StatusCommand.class.getName());
    private static final Set<VCSFileProxy> logged = new HashSet<VCSFileProxy>();

    public StatusCommandBase(JGitRepository repository, String revision, VCSFileProxy[] roots, GitClassFactory gitFactory, ProgressMonitor monitor, StatusListener listener) {
        super(repository, gitFactory, monitor);
        this.roots = roots;
        this.monitor = monitor;
        this.listener = listener;
        this.revision = revision;
        this.statuses = new LinkedHashMap();
    }

    public Map<VCSFileProxy, GitStatus> getStatuses() {
        return this.statuses;
    }

    protected final void handleConflict(GitStatus[] conflicts, String workTreePath) {
        if (conflicts[0] != null || conflicts[1] != null || conflicts[2] != null) {
            GitStatus status;
            GitConflictDescriptor.Type type;
            if (conflicts[1] == null && conflicts[2] == null) {
                type = GitConflictDescriptor.Type.BOTH_DELETED;
                status = conflicts[0];
            } else if (conflicts[1] == null && conflicts[2] != null) {
                type = GitConflictDescriptor.Type.DELETED_BY_US;
                status = conflicts[2];
            } else if (conflicts[1] != null && conflicts[2] == null) {
                type = GitConflictDescriptor.Type.DELETED_BY_THEM;
                status = conflicts[1];
            } else if (conflicts[0] == null) {
                type = GitConflictDescriptor.Type.BOTH_ADDED;
                status = conflicts[1];
            } else {
                type = GitConflictDescriptor.Type.BOTH_MODIFIED;
                status = conflicts[1];
            }
            GitConflictDescriptor desc = this.getClassFactory().createConflictDescriptor(type);
            status = this.getClassFactory().createStatus(true, status.getRelativePath(), workTreePath, status.getFile(), GitStatus.Status.STATUS_NORMAL, GitStatus.Status.STATUS_NORMAL, GitStatus.Status.STATUS_NORMAL, desc, status.isFolder(), null, status.getIndexEntryModificationDate());
            this.addStatus(status.getFile(), status);
        }
        Arrays.fill(conflicts, null);
    }

    protected final void addStatus(VCSFileProxy file, GitStatus status) {
        GitStatus presentStatus = this.statuses.get(file);
        if (presentStatus == null || !presentStatus.isRenamed()) {
            this.statuses.put(file, status);
        }
        this.listener.notifyStatus(status);
    }
}

