/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.project;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileSearch;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.spi.project.NativeFileSearchProvider;
import org.netbeans.modules.cnd.spi.project.NativeProjectExecutionProvider;
import org.netbeans.modules.cnd.utils.CndLanguageStandards;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.openide.util.lookup.Lookups;

public final class NativeProjectSupport {
    private NativeProjectSupport() {
    }

    public static NativeExitStatus execute(NativeProject project, String executable, String[] env, String ... args) throws IOException {
        for (NativeProjectExecutionProvider provider : Lookups.forPath((String)"CND/NativeProjectExecutionProvider").lookupAll(NativeProjectExecutionProvider.class)) {
            NativeExitStatus result = provider.execute(project, executable, env, args);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String getPlatformName(NativeProject project) {
        for (NativeProjectExecutionProvider provider : Lookups.forPath((String)"CND/NativeProjectExecutionProvider").lookupAll(NativeProjectExecutionProvider.class)) {
            String result = provider.getPlatformName(project);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static NativeFileSearch getNativeFileSearch(NativeProject project) {
        final ArrayList<NativeFileSearch> delegates = new ArrayList<NativeFileSearch>();
        for (NativeFileSearchProvider provider : Lookups.forPath((String)"CND/NativeFileSearchProvider").lookupAll(NativeFileSearchProvider.class)) {
            NativeFileSearch result = provider.getNativeFileSearch(project);
            if (result == null) continue;
            delegates.add(result);
        }
        return new NativeFileSearch(){

            @Override
            public Collection<FSPath> searchFile(NativeProject project, String fileName) {
                LinkedHashSet<FSPath> out = new LinkedHashSet<FSPath>();
                for (NativeFileSearch searcher : delegates) {
                    out.addAll(searcher.searchFile(project, fileName));
                }
                return out;
            }
        };
    }

    public static NativeFileItem.LanguageFlavor getDefaultLanguageFlavor(NativeFileItem.Language lang) {
        NativeFileItem.LanguageFlavor bestFlavor = NativeFileItem.LanguageFlavor.UNKNOWN;
        switch (lang) {
            case C: {
                bestFlavor = NativeProjectSupport.getDefaultCStandard();
                break;
            }
            case CPP: {
                bestFlavor = NativeProjectSupport.getDefaultCppStandard();
                break;
            }
            case C_HEADER: {
                bestFlavor = NativeProjectSupport.getDefaultHeaderStandard();
            }
        }
        return bestFlavor;
    }

    public static NativeFileItem.LanguageFlavor getDefaultCppStandard() {
        MIMEExtensions me = MIMEExtensions.get((String)"text/x-c++");
        CndLanguageStandards.CndLanguageStandard defaultStandard = me.getDefaultStandard();
        if (defaultStandard != null) {
            switch (defaultStandard) {
                case CPP11: {
                    return NativeFileItem.LanguageFlavor.CPP11;
                }
                case CPP14: {
                    return NativeFileItem.LanguageFlavor.CPP14;
                }
                case CPP98: {
                    return NativeFileItem.LanguageFlavor.CPP;
                }
            }
        }
        return NativeFileItem.LanguageFlavor.UNKNOWN;
    }

    public static NativeFileItem.LanguageFlavor getDefaultHeaderStandard() {
        MIMEExtensions me = MIMEExtensions.get((String)"text/x-h");
        CndLanguageStandards.CndLanguageStandard defaultStandard = me.getDefaultStandard();
        if (defaultStandard != null) {
            switch (defaultStandard) {
                case CPP11: {
                    return NativeFileItem.LanguageFlavor.CPP11;
                }
                case CPP14: {
                    return NativeFileItem.LanguageFlavor.CPP14;
                }
                case CPP98: {
                    return NativeFileItem.LanguageFlavor.CPP;
                }
            }
        }
        return NativeFileItem.LanguageFlavor.UNKNOWN;
    }

    public static NativeFileItem.LanguageFlavor getDefaultCStandard() {
        MIMEExtensions me = MIMEExtensions.get((String)"text/x-c");
        CndLanguageStandards.CndLanguageStandard defaultStandard = me.getDefaultStandard();
        if (defaultStandard != null) {
            switch (defaultStandard) {
                case C89: {
                    return NativeFileItem.LanguageFlavor.C89;
                }
                case C99: {
                    return NativeFileItem.LanguageFlavor.C99;
                }
                case C11: {
                    return NativeFileItem.LanguageFlavor.C11;
                }
            }
        }
        return NativeFileItem.LanguageFlavor.UNKNOWN;
    }

    public static final class NativeExitStatus {
        public final int exitCode;
        public final String error;
        public final String output;

        public NativeExitStatus(int exitCode, String output, String error) {
            this.exitCode = exitCode;
            this.error = error;
            this.output = output;
        }

        public boolean isOK() {
            return this.exitCode == 0;
        }
    }
}

