/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.UniqueKeyElement;
import org.netbeans.modules.hibernate.wizards.support.Table;
import org.netbeans.modules.hibernate.wizards.support.TableProvider;

public class DBSchemaTableProvider
implements TableProvider {
    private final SchemaElement schemaElement;
    private final Set<Table> tables;

    public DBSchemaTableProvider(SchemaElement schemaElement) {
        this.schemaElement = schemaElement;
        this.tables = this.buildTables();
    }

    @Override
    public Set<Table> getTables() {
        return this.tables;
    }

    public static boolean isJoinTable(TableElement e) {
        ForeignKeyElement[] foreignKeys = e.getForeignKeys();
        if (foreignKeys == null || foreignKeys.length != 2) {
            return false;
        }
        int foreignKeySize = foreignKeys[0].getColumns().length + foreignKeys[1].getColumns().length;
        if (foreignKeySize < e.getColumns().length) {
            return false;
        }
        String tableName = e.getName().getName();
        for (int i = 0; i < 2; ++i) {
            if (!tableName.equals(foreignKeys[i].getReferencedTable().getName().getName())) continue;
            return false;
        }
        if (DBSchemaTableProvider.isFkUnique(foreignKeys[0]) || DBSchemaTableProvider.isFkUnique(foreignKeys[1])) {
            return false;
        }
        for (ColumnElement c : foreignKeys[0].getColumns()) {
            for (ColumnElement c2 : foreignKeys[1].getColumns()) {
                if (c2 == null || c == null || !c2.equals((Object)c)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isFkUnique(ForeignKeyElement key) {
        UniqueKeyElement[] uk = key.getDeclaringTable().getUniqueKeys();
        if (uk == null) {
            return false;
        }
        ColumnElement[] columns = key.getColumns();
        for (int uin = 0; uin < uk.length; ++uin) {
            if (!DBSchemaTableProvider.containsSameColumns(columns, uk[uin])) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSameColumns(ColumnElement[] fkColumns, UniqueKeyElement uk) {
        if (fkColumns.length == uk.getColumns().length) {
            for (int i = 0; i < fkColumns.length; ++i) {
                if (uk.getColumn(fkColumns[i].getName()) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Set<Table> buildTables() {
        TableElement[] tableElements;
        HashMap<String, DBSchemaTable> name2Table = new HashMap<String, DBSchemaTable>();
        HashMap name2Referenced = new HashMap();
        HashMap name2ReferencedBy = new HashMap();
        HashMap name2Join = new HashMap();
        for (TableElement tableElement : tableElements = this.schemaElement.getTables()) {
            if (!tableElement.isTable()) continue;
            boolean join = DBSchemaTableProvider.isJoinTable(tableElement);
            List<Table.DisabledReason> disabledReasons = DBSchemaTableProvider.getDisabledReasons(tableElement);
            Table.DisabledReason disabledReason = null;
            for (Table.DisabledReason reason : disabledReasons) {
                if (join && reason instanceof Table.NoPrimaryKeyDisabledReason) continue;
                disabledReason = reason;
                break;
            }
            String tableName = tableElement.getName().getName();
            DBSchemaTable table = new DBSchemaTable(tableName, disabledReason);
            name2Table.put(tableName, table);
            name2Referenced.put(tableName, new HashSet());
            name2ReferencedBy.put(tableName, new HashSet());
            name2Join.put(tableName, new HashSet());
        }
        for (TableElement tableElement : tableElements) {
            if (!tableElement.isTable()) continue;
            String tableName = tableElement.getName().getName();
            Table table = (Table)name2Table.get(tableName);
            ForeignKeyElement[] foreignKeyElements = tableElement.getForeignKeys();
            if (foreignKeyElements == null) continue;
            for (ForeignKeyElement foreignKeyElement : foreignKeyElements) {
                TableElement referencedTableElement = foreignKeyElement.getReferencedTable();
                String referencedTableName = referencedTableElement.getName().getName();
                Table referencedTable = (Table)name2Table.get(referencedTableName);
                ((Set)name2Referenced.get(tableName)).add(referencedTable);
                ((Set)name2ReferencedBy.get(referencedTableName)).add(table);
                if (!table.isJoin()) continue;
                ((Set)name2Join.get(referencedTableName)).add(table);
            }
        }
        HashSet<DBSchemaTable> result = new HashSet<DBSchemaTable>();
        for (DBSchemaTable table : name2Table.values()) {
            String tableName = table.getName();
            table.setReferencedTables(Collections.unmodifiableSet((Set)name2Referenced.get(tableName)));
            table.setReferencedByTables(Collections.unmodifiableSet((Set)name2ReferencedBy.get(tableName)));
            table.setJoinTables(Collections.unmodifiableSet((Set)name2Join.get(tableName)));
            result.add(table);
        }
        return Collections.unmodifiableSet(result);
    }

    private static List<Table.DisabledReason> getDisabledReasons(TableElement tableElement) {
        ArrayList<Table.DisabledReason> result = new ArrayList<Table.DisabledReason>();
        if (DBSchemaTableProvider.hasNoPrimaryKey(tableElement)) {
            result.add(new Table.NoPrimaryKeyDisabledReason());
        }
        return result;
    }

    private static boolean hasNoPrimaryKey(TableElement tableElement) {
        return tableElement.getPrimaryKey() == null;
    }

    private static final class DBSchemaTable
    extends Table {
        private Set<Table> referencedTables;
        private Set<Table> referencedByTables;
        private Set<Table> joinTables;

        public DBSchemaTable(String name, Table.DisabledReason disabledReason) {
            super(name, false, disabledReason);
        }

        @Override
        public Set<Table> getReferencedTables() {
            return this.referencedTables;
        }

        private void setReferencedTables(Set<Table> referencedTables) {
            this.referencedTables = referencedTables;
        }

        @Override
        public Set<Table> getReferencedByTables() {
            return this.referencedByTables;
        }

        private void setReferencedByTables(Set<Table> referencedByTables) {
            this.referencedByTables = referencedByTables;
        }

        @Override
        public Set<Table> getJoinTables() {
            return this.joinTables;
        }

        private void setJoinTables(Set<Table> joinTables) {
            this.joinTables = joinTables;
        }
    }
}

