/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.performance;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.modules.cnd.discovery.performance.Bundle;
import org.netbeans.modules.cnd.discovery.performance.PerformanceIssueDetector;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;

public class NotifyProjectProblem
extends JPanel {
    public static final int CREATE_PROBLEM = 1;
    public static final int INFINITE_CREATE_PROBLEM = 2;
    public static final int READ_PROBLEM = 3;
    public static final int PARSE_PROBLEM = 4;
    public static final int INFINITE_PARSE_PROBLEM = 5;
    private JTextPane explanation;
    private JScrollPane scrollPane;

    private NotifyProjectProblem(PerformanceIssueDetector detector, String details) {
        this.initComponents();
        this.explanation.setEditorKit(new HTMLEditorKit());
        this.explanation.setBackground(this.getBackground());
        this.explanation.setForeground(this.getForeground());
        this.explanation.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.explanation.setText(details);
    }

    public static void showNotification(final PerformanceIssueDetector detector, int problem, String details) {
        String title;
        String shortDescription;
        String explanation;
        switch (problem) {
            case 1: {
                explanation = Bundle.NotifyProjectProblem_open_explanation_text("");
                title = shortDescription = Bundle.NotifyProjectProblem_open_message_text();
                break;
            }
            case 2: {
                explanation = Bundle.NotifyProjectProblem_infinite_create_explanation_text(details);
                title = shortDescription = Bundle.NotifyProjectProblem_infinite_create_message_text();
                break;
            }
            case 3: {
                explanation = Bundle.NotifyProjectProblem_read_explanation_text("");
                title = shortDescription = Bundle.NotifyProjectProblem_read_message_text();
                break;
            }
            case 4: {
                explanation = Bundle.NotifyProjectProblem_parse_explanation_text("");
                title = shortDescription = Bundle.NotifyProjectProblem_parse_message_text();
                break;
            }
            case 5: {
                explanation = Bundle.NotifyProjectProblem_infinite_parse_explanation_text(details);
                title = shortDescription = Bundle.NotifyProjectProblem_infinite_parse_message_text();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        ActionListener onClickAction = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                NotifyProjectProblem panel = new NotifyProjectProblem(detector, explanation);
                DialogDescriptor descriptor = new DialogDescriptor((Object)panel, title, true, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, null, null);
                Dialog dlg = DialogDisplayer.getDefault().createDialog(descriptor);
                try {
                    dlg.setVisible(true);
                }
                catch (Throwable th) {
                    if (!(th.getCause() instanceof InterruptedException)) {
                        throw new RuntimeException(th);
                    }
                    descriptor.setValue(DialogDescriptor.CANCEL_OPTION);
                }
                finally {
                    dlg.dispose();
                }
            }
        };
        ImageIcon icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/discovery/performance/exclamation.gif", (boolean)false);
        Notification notification = NotificationDisplayer.getDefault().notify(shortDescription, (Icon)icon, Bundle.NotifyProjectProblem_action_text(), onClickAction, NotificationDisplayer.Priority.HIGH, NotificationDisplayer.Category.WARNING);
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.explanation = new JTextPane();
        this.setPreferredSize(new Dimension(350, 250));
        this.setLayout(new BorderLayout());
        this.scrollPane.setViewportView(this.explanation);
        this.add((Component)this.scrollPane, "Center");
    }
}

