/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.discovery.wizard.api.FileConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.api.FolderConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.tree.FileConfigurationImpl;
import org.netbeans.modules.cnd.discovery.wizard.tree.NodeConfigurationImpl;

public class FolderConfigurationImpl
extends NodeConfigurationImpl
implements FolderConfiguration {
    private final String path;
    private final Map<String, FolderConfigurationImpl> folders = new HashMap<String, FolderConfigurationImpl>();
    private final List<FileConfigurationImpl> files = new ArrayList<FileConfigurationImpl>();

    public FolderConfigurationImpl(String path) {
        this.path = path;
    }

    public FolderConfigurationImpl cut() {
        if (this.folders.size() == 1 && this.files.isEmpty()) {
            return this.folders.values().iterator().next();
        }
        return null;
    }

    @Override
    public List<FolderConfiguration> getFolders() {
        return new ArrayList<FolderConfiguration>(this.folders.values());
    }

    public void addChild(FolderConfigurationImpl subfolder) {
        this.folders.put(subfolder.getFolderName(), subfolder);
    }

    public FolderConfigurationImpl getChild(String name) {
        return this.folders.get(name);
    }

    @Override
    public List<FileConfiguration> getFiles() {
        return new ArrayList<FileConfiguration>(this.files);
    }

    public void addFile(FileConfigurationImpl file) {
        this.files.add(file);
    }

    @Override
    public String getFolderPath() {
        return this.path;
    }

    @Override
    public String getFolderName() {
        int i = this.path.lastIndexOf("/");
        if (i >= 0) {
            return this.path.substring(i + 1);
        }
        return this.path;
    }
}

