/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.projects;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.wsitconf.projects.WebWsitProvider;
import org.netbeans.modules.websvc.wsitconf.spi.ProjectSpecificTransport;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WebProjectSpecificTransport
extends ProjectSpecificTransport {
    private WebWsitProvider wsitProvider;
    private static final String TCP_GF_NONJSR109 = "com.sun.xml.ws.transport.tcp.server.glassfish.WSStartupServlet";
    private static final String TCP_TOMCAT = "com.sun.xml.ws.transport.http.servlet.WSServletContextListener";
    private static final String PROP_CONNECTOR = "Connector";
    private static final String CONN_PROTOCOL = "com.sun.xml.ws.transport.tcp.server.tomcat.grizzly10.WSTCPGrizzly10ProtocolHandler";
    private static final String CONN_PORT = "5773";
    private static final String CONN_TIMEOUT = "20000";
    private static final String CONN_REDIRECT_PORT = "8080";

    public WebProjectSpecificTransport(Project p, WebWsitProvider provider) {
        this.project = p;
        this.wsitProvider = provider;
    }

    @Override
    public void setTCPUrl(String name, String serviceName, String implClass, boolean tomcat) {
        block15: {
            WebModule wm = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
            if (wm != null) {
                try {
                    String listener;
                    WebApp wApp = DDProvider.getDefault().getDDRoot(wm.getDeploymentDescriptor());
                    if (this.wsitProvider.isJsr109Project()) {
                        Servlet servlet = Util.getServlet(wApp, implClass);
                        if (servlet == null) {
                            try {
                                servlet = (Servlet)wApp.addBean("Servlet", new String[]{"ServletName", "ServletClass"}, new Object[]{name, implClass}, "ServletName");
                                servlet.setLoadOnStartup(new BigInteger("1"));
                                if (serviceName == null) {
                                    serviceName = implClass.substring(implClass.lastIndexOf(46) + 1) + "Service";
                                }
                                wApp.addBean("ServletMapping", new String[]{"ServletName", "UrlPattern"}, new Object[]{name, "/" + serviceName}, "ServletName");
                                wApp.write(wm.getDeploymentDescriptor());
                            }
                            catch (NameAlreadyUsedException ex) {
                                ex.printStackTrace();
                            }
                            catch (ClassNotFoundException ex) {
                                ex.printStackTrace();
                            }
                        } else {
                            servlet.setLoadOnStartup(new BigInteger("1"));
                        }
                        break block15;
                    }
                    String string = listener = tomcat ? TCP_TOMCAT : TCP_GF_NONJSR109;
                    if (!WebProjectSpecificTransport.isTcpListener(wApp, listener)) {
                        try {
                            wApp.addBean("Listener", new String[]{"ListenerClass"}, new Object[]{listener}, "ListenerClass");
                            wApp.write(wm.getDeploymentDescriptor());
                        }
                        catch (NameAlreadyUsedException ex) {
                            ex.printStackTrace();
                        }
                        catch (ClassNotFoundException ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (tomcat) {
                        WebProjectSpecificTransport.addConnector(this.project);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private static boolean isTcpListener(WebApp wa, String listener) {
        Listener[] listeners;
        for (Listener l : listeners = wa.getListener()) {
            if (!listener.equals(l.getListenerClass())) continue;
            return true;
        }
        return false;
    }

    public static void addConnector(Project p) {
        FileObject serverXml = ServerUtils.getServerXml(p);
        if (serverXml != null) {
            try {
                XMLDataObject dobj = (XMLDataObject)DataObject.find((FileObject)serverXml);
                Document doc = dobj.getDocument();
                Element root = doc.getDocumentElement();
                NodeList list = root.getElementsByTagName("Service");
                int size = list.getLength();
                if (size > 0) {
                    Element service = (Element)list.item(0);
                    NodeList cons = service.getElementsByTagName(PROP_CONNECTOR);
                    for (int i = 0; i < cons.getLength(); ++i) {
                        Element con = (Element)cons.item(i);
                        String protocol = con.getAttribute("protocol");
                        if (!CONN_PROTOCOL.equals(protocol)) continue;
                        return;
                    }
                    Element e = doc.createElement(PROP_CONNECTOR);
                    e.setAttribute("port", CONN_PORT);
                    e.setAttribute("connectionTimeout", CONN_TIMEOUT);
                    e.setAttribute("protocol", CONN_PROTOCOL);
                    e.setAttribute("redirectHttpPort", CONN_REDIRECT_PORT);
                    e.setAttribute("redirectPort", CONN_REDIRECT_PORT);
                    service.appendChild(e);
                    XMLUtil.write((Document)doc, (OutputStream)new FileOutputStream(FileUtil.toFile((FileObject)serverXml)), (String)"UTF-8");
                }
            }
            catch (SAXException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

