/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2me.project.J2MEProject;
import org.netbeans.modules.j2me.project.J2MEProjectUtils;
import org.netbeans.modules.j2me.project.ui.ManageMIDlets;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathProviderImpl;
import org.netbeans.modules.java.api.common.project.BaseActionProvider;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

final class J2MEActionProvider
extends BaseActionProvider {
    private static final Logger LOG = Logger.getLogger(J2MEActionProvider.class.getName());
    private static final String MIDLET = "javax.microedition.midlet.MIDlet";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "compile.single", "run", "debug", "profile", "javadoc", "debug.fix", "delete", "copy", "move", "rename"};
    private static final String[] platformSensitiveActions = new String[]{"build", "rebuild", "compile.single", "run", "debug", "profile", "javadoc", "debug.fix"};
    private static final Map<String, String[]> commands;
    private static final Set<String> bkgScanSensitiveActions;
    private static final Set<String> needJavaModelActions;
    private final J2MEProject project;

    J2MEActionProvider(@NonNull J2MEProject project, @NonNull UpdateHelper updateHelper, @NonNull SourceRoots src, @NonNull SourceRoots test) {
        super((Project)project, updateHelper, project.evaluator(), src, test, updateHelper.getAntProjectHelper(), (BaseActionProvider.Callback)new CallbackImpl(project.getClassPathProvider(), project));
        this.project = project;
    }

    protected String[] getPlatformSensitiveActions() {
        return platformSensitiveActions;
    }

    protected String[] getActionsDisabledForQuickRun() {
        return supportedActions;
    }

    public Map<String, String[]> getCommands() {
        return commands;
    }

    protected Set<String> getScanSensitiveActions() {
        return bkgScanSensitiveActions;
    }

    protected Set<String> getJavaModelActions() {
        return needJavaModelActions;
    }

    protected boolean isCompileOnSaveEnabled() {
        return false;
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    @CheckForNull
    protected JavaPlatform getProjectPlatform() {
        return CommonProjectUtils.getActivePlatform((String)this.project.evaluator().getProperty("platform.active"), (String)"j2me");
    }

    protected String getProjectMainClass(boolean verify) {
        ClassPath srcPath;
        ClassPath sysPath;
        ClassPath bootPath;
        String rawMidlets = this.project.evaluator().getProperty("manifest.midlets");
        if (rawMidlets == null || rawMidlets.isEmpty()) {
            return null;
        }
        final ArrayList<String> midlets = new ArrayList<String>();
        StringTokenizer tk = new StringTokenizer(rawMidlets, "\n");
        while (tk.hasMoreTokens()) {
            String line = tk.nextToken().trim();
            String[] lineParts = line.split("\\s*,\\s*");
            if (lineParts.length != 3) continue;
            midlets.add(lineParts[2]);
        }
        if (!verify) {
            return midlets.isEmpty() ? null : (String)midlets.iterator().next();
        }
        FileObject[] sourcesRoots = this.project.getSourceRoots().getRoots();
        if (sourcesRoots.length > 0) {
            LOG.log(Level.FINE, "Searching main class {0} using source root {1}", new Object[]{rawMidlets, FileUtil.getFileDisplayName((FileObject)sourcesRoots[0])});
            bootPath = ClassPath.getClassPath((FileObject)sourcesRoots[0], (String)"classpath/boot");
            if (bootPath == null) {
                bootPath = this.project.getClassPathProvider().getProjectSourcesClassPath("classpath/boot");
            }
            if ((sysPath = ClassPath.getClassPath((FileObject)sourcesRoots[0], (String)"classpath/execute")) == null) {
                sysPath = this.project.getClassPathProvider().getProjectSourcesClassPath("classpath/execute");
            }
            srcPath = ClassPath.getClassPath((FileObject)sourcesRoots[0], (String)"classpath/source");
        } else {
            LOG.log(Level.FINE, "Searching main class {0} without source root", rawMidlets);
            bootPath = this.project.getClassPathProvider().getProjectSourcesClassPath("classpath/boot");
            sysPath = this.project.getClassPathProvider().getProjectSourcesClassPath("classpath/execute");
            srcPath = this.project.getClassPathProvider().getProjectSourcesClassPath("classpath/source");
        }
        LOG.log(Level.FINE, "Classpaths used to resolve main class boot: {0}, exec: {1}, src: {2}", new Object[]{bootPath, sysPath, srcPath});
        JavaSource js = JavaSource.create((ClasspathInfo)ClasspathInfo.create((ClassPath)bootPath, (ClassPath)sysPath, (ClassPath)srcPath), (FileObject[])new FileObject[0]);
        if (js == null) {
            return rawMidlets;
        }
        try {
            final String[] res = new String[1];
            js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(@NonNull CompilationController cc) throws Exception {
                    Elements e = cc.getElements();
                    Types t = cc.getTypes();
                    TypeElement midlet = e.getTypeElement(J2MEActionProvider.MIDLET);
                    if (midlet != null) {
                        for (String fqn : midlets) {
                            TypeElement main = e.getTypeElement(fqn);
                            if (main == null || !t.isSubtype(main.asType(), midlet.asType())) continue;
                            res[0] = fqn;
                            break;
                        }
                    }
                }
            }, true);
            LOG.log(Level.FINE, "Main class {0} valid: {1}", new Object[]{rawMidlets, res[0]});
            return res[0];
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return rawMidlets;
        }
    }

    protected boolean showMainClassSelector() {
        ManageMIDlets mm = new ManageMIDlets(this.project);
        DialogDescriptor dd = new DialogDescriptor((Object)mm, NbBundle.getMessage(J2MEActionProvider.class, (String)"TXT_RunProject", (Object)ProjectUtils.getInformation((Project)this.project).getDisplayName()), true, 2, DialogDescriptor.OK_OPTION, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
            return mm.store();
        }
        return false;
    }

    static {
        HashMap<String, String[]> tmp = new HashMap<String, String[]>();
        tmp.put("clean", new String[]{"clean"});
        tmp.put("compile.single", new String[]{"compile-single"});
        tmp.put("run", new String[]{"run"});
        tmp.put("debug", new String[]{"debug"});
        tmp.put("profile", new String[]{"profile"});
        tmp.put("javadoc", new String[]{"javadoc"});
        tmp.put("debug.fix", new String[]{"debug-fix"});
        commands = Collections.unmodifiableMap(tmp);
        bkgScanSensitiveActions = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("run", "run.single", "debug", "debug.single")));
        needJavaModelActions = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("debug.fix")));
    }

    public static final class CallbackImpl
    implements BaseActionProvider.Callback3 {
        private final ClassPathProviderImpl cp;
        private final J2MEProject project;

        public CallbackImpl(ClassPathProviderImpl cp, @NonNull J2MEProject project) {
            this.cp = cp;
            this.project = project;
        }

        public ClassPath getProjectSourcesClassPath(String type) {
            return this.cp.getProjectSourcesClassPath(type);
        }

        public ClassPath findClassPath(FileObject file, String type) {
            return this.cp.findClassPath(file, type);
        }

        public Map<String, String> createAdditionalProperties(String command, Lookup context) {
            String url;
            PropertyEvaluator pe;
            String runMethod;
            HashMap<String, String> result = new HashMap<String, String>();
            if (command.equals("run") && (runMethod = (pe = this.project.evaluator()).getProperty("run.method")) != null && runMethod.equals("OTA") && (url = J2MEProjectUtils.getJadURL(this.project.getHelper())) != null) {
                result.put("dist.jad.url", url);
            }
            return result;
        }

        public Set<String> createConcealedProperties(String command, Lookup context) {
            return Collections.emptySet();
        }

        public void antTargetInvocationStarted(String command, Lookup context) {
        }

        public void antTargetInvocationFinished(String command, Lookup context, int result) {
        }

        public void antTargetInvocationFailed(String command, Lookup context) {
        }
    }
}

