/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver;

import java.util.Iterator;
import org.clang.driver.types;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.iterator_range;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class Action
implements Destructors.ClassWithDestructor,
Iterable<Action> {
    private ActionClass Kind;
    private types.ID Type;
    private SmallVector<Action> Inputs;
    protected int ActiveOffloadKindMask;
    protected int OffloadingDeviceKind;
    protected char.ptr OffloadingArch;

    protected Action() {
    }

    public static char.ptr getClassName(ActionClass AC) {
        switch (AC) {
            case InputClass: {
                return NativePointer.$((String)"input");
            }
            case BindArchClass: {
                return NativePointer.$((String)"bind-arch");
            }
            case OffloadClass: {
                return NativePointer.$((String)"offload");
            }
            case PreprocessJobClass: {
                return NativePointer.$((String)"preprocessor");
            }
            case PrecompileJobClass: {
                return NativePointer.$((String)"precompiler");
            }
            case AnalyzeJobClass: {
                return NativePointer.$((String)"analyzer");
            }
            case MigrateJobClass: {
                return NativePointer.$((String)"migrator");
            }
            case CompileJobClass: {
                return NativePointer.$((String)"compiler");
            }
            case BackendJobClass: {
                return NativePointer.$((String)"backend");
            }
            case AssembleJobClass: {
                return NativePointer.$((String)"assembler");
            }
            case LinkJobClass: {
                return NativePointer.$((String)"linker");
            }
            case LipoJobClass: {
                return NativePointer.$((String)"lipo");
            }
            case DsymutilJobClass: {
                return NativePointer.$((String)"dsymutil");
            }
            case VerifyDebugInfoJobClass: {
                return NativePointer.$((String)"verify-debug-info");
            }
            case VerifyPCHJobClass: {
                return NativePointer.$((String)"verify-pch");
            }
        }
        throw new llvm_unreachable("invalid class");
    }

    protected Action(ActionClass Kind, types.ID Type2) {
        this(Kind, (SmallVector<Action>)new SmallVector(3, (Object)null), Type2);
    }

    protected Action(ActionClass Kind, Action Input, types.ID Type2) {
        this(Kind, (SmallVector<Action>)new SmallVector(3, (Object[])new Action[]{Input}, (Object)null), Type2);
    }

    protected Action(ActionClass Kind, Action Input) {
        this(Kind, (SmallVector<Action>)new SmallVector(3, (Object[])new Action[]{Input}, (Object)null), Input.getType());
    }

    protected Action(ActionClass Kind, SmallVector<Action> Inputs, types.ID Type2) {
        this.Kind = Kind;
        this.Type = Type2;
        this.Inputs = new SmallVector(Inputs);
        this.ActiveOffloadKindMask = 0;
        this.OffloadingDeviceKind = 0;
        this.OffloadingArch = null;
    }

    public void $destroy() {
        this.Inputs.$destroy();
    }

    public char.ptr getClassName() {
        return Action.getClassName(this.getKind());
    }

    public ActionClass getKind() {
        return this.Kind;
    }

    public types.ID getType() {
        return this.Type;
    }

    public SmallVector<Action> getInputs() {
        return this.Inputs;
    }

    public int size() {
        return this.Inputs.size();
    }

    public SmallVectorImpl.iterator<Action> input_begin() {
        return this.Inputs.begin();
    }

    public SmallVectorImpl.iterator<Action> input_end() {
        return this.Inputs.end();
    }

    public iterator_range<Action> inputs() {
        return new iterator_range(this.input_begin(), this.input_end());
    }

    @Override
    public Iterator<Action> iterator() {
        return this.Inputs.iterator();
    }

    public std.string getOffloadingKindPrefix() {
        switch (this.OffloadingDeviceKind) {
            case 0: {
                break;
            }
            case 1: {
                throw new llvm_unreachable("Host kind is not an offloading device kind.");
            }
            case 2: {
                return new std.string((CharSequence)"device-cuda");
            }
        }
        if (this.ActiveOffloadKindMask == 0) {
            return new std.string(NativePointer.$EMPTY);
        }
        std.string Res = new std.string((CharSequence)"host");
        if ((this.ActiveOffloadKindMask & 2) != 0) {
            Res.$addassign((CharSequence)"-cuda");
        }
        return Res;
    }

    public std.string getOffloadingFileNamePrefix(StringRef NormalizedTriple) {
        if (this.OffloadingDeviceKind == 0) {
            return new std.string(NativePointer.$EMPTY);
        }
        std.string Res = new std.string(NativePointer.$MINUS);
        Res.$addassign(this.getOffloadingKindPrefix());
        Res.$addassign((CharSequence)"-");
        llvm.$addassign_str_StringRef((std.string)Res, (StringRef)NormalizedTriple);
        return Res;
    }

    public void propagateDeviceOffloadInfo(int OKind, char.ptr OArch) {
        if (this.Kind == ActionClass.OffloadClass) {
            return;
        }
        assert (this.OffloadingDeviceKind == OKind || this.OffloadingDeviceKind == 0) : "Setting device kind to a different device??";
        assert (this.ActiveOffloadKindMask == 0) : "Setting a device kind in a host action??";
        this.OffloadingDeviceKind = OKind;
        this.OffloadingArch = Native.$tryClone((char.ptr)OArch);
        for (Action A : this.Inputs) {
            A.propagateDeviceOffloadInfo(this.OffloadingDeviceKind, OArch);
        }
    }

    public void propagateHostOffloadInfo(int OKinds, char.ptr OArch) {
        if (this.Kind == ActionClass.OffloadClass) {
            return;
        }
        assert (this.OffloadingDeviceKind == 0) : "Setting a host kind in a device action.";
        this.ActiveOffloadKindMask |= OKinds;
        this.OffloadingArch = Native.$tryClone((char.ptr)OArch);
        for (Action A : this.Inputs) {
            A.propagateHostOffloadInfo(this.ActiveOffloadKindMask, OArch);
        }
    }

    public void propagateOffloadInfo(Action A) {
        int HK = A.getOffloadingHostActiveKinds();
        if (HK != 0) {
            this.propagateHostOffloadInfo(HK, A.getOffloadingArch());
        } else {
            this.propagateDeviceOffloadInfo(A.getOffloadingDeviceKind(), A.getOffloadingArch());
        }
    }

    public int getOffloadingHostActiveKinds() {
        return this.ActiveOffloadKindMask;
    }

    public int getOffloadingDeviceKind() {
        return this.OffloadingDeviceKind;
    }

    public char.ptr getOffloadingArch() {
        return this.OffloadingArch;
    }

    public boolean isHostOffloading(int OKind) {
        return (this.ActiveOffloadKindMask & OKind) != 0;
    }

    public boolean isDeviceOffloading(int OKind) {
        return this.OffloadingDeviceKind == OKind;
    }

    public boolean isOffloading(int OKind) {
        return this.isHostOffloading(OKind) || this.isDeviceOffloading(OKind);
    }

    public String toString() {
        return "Kind=" + (Object)((Object)this.Kind) + ", Type=" + (Object)((Object)this.Type) + ", Inputs=" + this.Inputs + ", ActiveOffloadKindMask=" + this.ActiveOffloadKindMask + ", OffloadingDeviceKind=" + this.OffloadingDeviceKind + ", OffloadingArch=" + this.OffloadingArch;
    }

    public static final class OffloadKind {
        public static final int OFK_None = 0;
        public static final int OFK_Host = 1;
        public static final int OFK_Cuda = 2;
    }

    public static final class ActionClass
    extends Enum<ActionClass>
    implements Native.ComparableLower {
        public static final /* enum */ ActionClass InputClass = new ActionClass(0);
        public static final /* enum */ ActionClass BindArchClass = new ActionClass(InputClass.getValue() + 1);
        public static final /* enum */ ActionClass OffloadClass = new ActionClass(BindArchClass.getValue() + 1);
        public static final /* enum */ ActionClass PreprocessJobClass = new ActionClass(OffloadClass.getValue() + 1);
        public static final /* enum */ ActionClass PrecompileJobClass = new ActionClass(PreprocessJobClass.getValue() + 1);
        public static final /* enum */ ActionClass AnalyzeJobClass = new ActionClass(PrecompileJobClass.getValue() + 1);
        public static final /* enum */ ActionClass MigrateJobClass = new ActionClass(AnalyzeJobClass.getValue() + 1);
        public static final /* enum */ ActionClass CompileJobClass = new ActionClass(MigrateJobClass.getValue() + 1);
        public static final /* enum */ ActionClass BackendJobClass = new ActionClass(CompileJobClass.getValue() + 1);
        public static final /* enum */ ActionClass AssembleJobClass = new ActionClass(BackendJobClass.getValue() + 1);
        public static final /* enum */ ActionClass LinkJobClass = new ActionClass(AssembleJobClass.getValue() + 1);
        public static final /* enum */ ActionClass LipoJobClass = new ActionClass(LinkJobClass.getValue() + 1);
        public static final /* enum */ ActionClass DsymutilJobClass = new ActionClass(LipoJobClass.getValue() + 1);
        public static final /* enum */ ActionClass VerifyDebugInfoJobClass = new ActionClass(DsymutilJobClass.getValue() + 1);
        public static final /* enum */ ActionClass VerifyPCHJobClass = new ActionClass(VerifyDebugInfoJobClass.getValue() + 1);
        public static final /* enum */ ActionClass JobClassFirst = new ActionClass(PreprocessJobClass.getValue());
        public static final /* enum */ ActionClass JobClassLast = new ActionClass(VerifyPCHJobClass.getValue());
        private final int value;
        private static final /* synthetic */ ActionClass[] $VALUES;

        public static ActionClass[] values() {
            return (ActionClass[])$VALUES.clone();
        }

        public static ActionClass valueOf(String name) {
            return Enum.valueOf(ActionClass.class, name);
        }

        public static ActionClass valueOf(int val) {
            ActionClass out;
            ActionClass actionClass = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private ActionClass(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((ActionClass)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((ActionClass)((Object)obj)).value);
        }

        static {
            $VALUES = new ActionClass[]{InputClass, BindArchClass, OffloadClass, PreprocessJobClass, PrecompileJobClass, AnalyzeJobClass, MigrateJobClass, CompileJobClass, BackendJobClass, AssembleJobClass, LinkJobClass, LipoJobClass, DsymutilJobClass, VerifyDebugInfoJobClass, VerifyPCHJobClass, JobClassFirst, JobClassLast};
        }

        private static final class Values {
            private static final ActionClass[] VALUES;
            private static final ActionClass[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (ActionClass kind : ActionClass.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ActionClass[min < 0 ? 1 - min : 0];
                VALUES = new ActionClass[max >= 0 ? 1 + max : 0];
                for (ActionClass kind : ActionClass.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((ActionClass)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((ActionClass)kind).value] = kind;
                }
            }
        }
    }
}

