/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.toolchains.impl;

import org.clang.driver.Driver;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.options;
import org.clang.driver.toolchains.impl.Generic_ELF;
import org.clang.driver.tools.impl.MipsStatics;
import org.clang.driver.tools.impl.NetbsdStatics;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.uint;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;

public class NetBSD
extends Generic_ELF
implements Destructors.ClassWithDestructor {
    public NetBSD(Driver D, Triple Triple2, ArgList Args) {
        super(D, Triple2, Args);
        if (this.getDriver().UseStdLib) {
            block0 : switch (Triple2.getArch()) {
                case x86: {
                    this.getFilePaths().push_back((Object)new std.string((CharSequence)"=/usr/lib/i386"));
                    break;
                }
                case arm: 
                case armeb: 
                case thumb: 
                case thumbeb: {
                    switch (Triple2.getEnvironment()) {
                        case EABI: 
                        case GNUEABI: {
                            this.getFilePaths().push_back((Object)new std.string((CharSequence)"=/usr/lib/eabi"));
                            break block0;
                        }
                        case EABIHF: 
                        case GNUEABIHF: {
                            this.getFilePaths().push_back((Object)new std.string((CharSequence)"=/usr/lib/eabihf"));
                            break block0;
                        }
                    }
                    this.getFilePaths().push_back((Object)new std.string((CharSequence)"=/usr/lib/oabi"));
                    break;
                }
                case mips64: 
                case mips64el: {
                    if (MipsStatics.hasMipsAbiArg(Args, NativePointer.$((String)"o32"))) {
                        this.getFilePaths().push_back((Object)new std.string((CharSequence)"=/usr/lib/o32"));
                        break;
                    }
                    if (!MipsStatics.hasMipsAbiArg(Args, NativePointer.$((String)"64"))) break;
                    this.getFilePaths().push_back((Object)new std.string((CharSequence)"=/usr/lib/64"));
                    break;
                }
                case ppc: {
                    this.getFilePaths().push_back((Object)new std.string((CharSequence)"=/usr/lib/powerpc"));
                    break;
                }
                case sparc: {
                    this.getFilePaths().push_back((Object)new std.string((CharSequence)"=/usr/lib/sparc"));
                    break;
                }
            }
            this.getFilePaths().push_back((Object)new std.string((CharSequence)"=/usr/lib"));
        }
    }

    @Override
    public boolean IsMathErrnoDefault() {
        return false;
    }

    @Override
    public boolean IsObjCNonFragileABIDefault() {
        return true;
    }

    @Override
    public ToolChain.CXXStdlibType GetDefaultCXXStdlibType() {
        uint.ref Major = NativePointer.create_uint$ref();
        uint.ref Minor = NativePointer.create_uint$ref();
        uint.ref Micro = NativePointer.create_uint$ref();
        this.getTriple().getOSVersion(Major, Minor, Micro);
        if (Unsigned.$greatereq_uint((uint.ref)Major, (int)7) || Major.$deref() == 0) {
            switch (this.getArch()) {
                case x86: 
                case arm: 
                case armeb: 
                case thumb: 
                case thumbeb: 
                case ppc: 
                case sparc: 
                case aarch64: 
                case ppc64: 
                case ppc64le: 
                case sparcv9: 
                case x86_64: {
                    return ToolChain.CXXStdlibType.CST_Libcxx;
                }
            }
        }
        return ToolChain.CXXStdlibType.CST_Libstdcxx;
    }

    @Override
    public void AddClangCXXStdlibIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
        if (DriverArgs.hasArg(new OptSpecifier(options.ID.OPT_nostdlibinc.getValue())) || DriverArgs.hasArg(new OptSpecifier(options.ID.OPT_nostdincxx.getValue()))) {
            return;
        }
        switch (this.GetCXXStdlibType(DriverArgs)) {
            case CST_Libcxx: {
                NetBSD.addSystemInclude(DriverArgs, CC1Args, new Twine(std.$add_string$C_T((std.string)this.getDriver().SysRoot, (String)"/usr/include/c++/")));
                break;
            }
            case CST_Libstdcxx: {
                NetBSD.addSystemInclude(DriverArgs, CC1Args, new Twine(std.$add_string$C_T((std.string)this.getDriver().SysRoot, (String)"/usr/include/g++")));
                NetBSD.addSystemInclude(DriverArgs, CC1Args, new Twine(std.$add_string$C_T((std.string)this.getDriver().SysRoot, (String)"/usr/include/g++/backward")));
            }
        }
    }

    @Override
    public boolean IsUnwindTablesDefault() {
        return true;
    }

    @Override
    protected Tool buildAssembler() {
        return new NetbsdStatics.Assembler(this);
    }

    @Override
    protected Tool buildLinker() {
        return new NetbsdStatics.Linker(this);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

