/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.util;

import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Dispatch;
import com.sun.jna.platform.win32.COM.IEnumMoniker;
import com.sun.jna.platform.win32.COM.IRunningObjectTable;
import com.sun.jna.platform.win32.COM.Moniker;
import com.sun.jna.platform.win32.COM.util.ComThread;
import com.sun.jna.platform.win32.COM.util.Factory;
import com.sun.jna.platform.win32.COM.util.IDispatch;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public class EnumMoniker
implements Iterable<IDispatch> {
    ComThread comThread;
    Factory factory;
    IRunningObjectTable rawRot;
    IEnumMoniker raw;
    Moniker rawNext;

    protected EnumMoniker(IEnumMoniker raw, IRunningObjectTable rawRot, Factory factory) {
        this.rawRot = rawRot;
        this.raw = raw;
        this.factory = factory;
        this.comThread = factory.getComThread();
        try {
            WinNT.HRESULT hr = this.comThread.execute(new Callable<WinNT.HRESULT>(){

                @Override
                public WinNT.HRESULT call() throws Exception {
                    return EnumMoniker.this.raw.Reset();
                }
            });
            COMUtils.checkRC(hr);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
        this.cacheNext();
    }

    protected void cacheNext() {
        try {
            final PointerByReference rgelt = new PointerByReference();
            final WinDef.ULONGByReference pceltFetched = new WinDef.ULONGByReference();
            WinNT.HRESULT hr = this.comThread.execute(new Callable<WinNT.HRESULT>(){

                @Override
                public WinNT.HRESULT call() throws Exception {
                    return EnumMoniker.this.raw.Next(new WinDef.ULONG(1L), rgelt, pceltFetched);
                }
            });
            if (WinNT.S_OK.equals((Object)hr) && pceltFetched.getValue().intValue() > 0) {
                this.rawNext = new Moniker(rgelt.getValue());
            } else {
                if (!WinNT.S_FALSE.equals((Object)hr)) {
                    COMUtils.checkRC(hr);
                }
                this.rawNext = null;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<IDispatch> iterator() {
        return new Iterator<IDispatch>(){

            @Override
            public boolean hasNext() {
                return null != EnumMoniker.this.rawNext;
            }

            @Override
            public IDispatch next() {
                try {
                    final Moniker moniker = EnumMoniker.this.rawNext;
                    final PointerByReference ppunkObject = new PointerByReference();
                    WinNT.HRESULT hr = EnumMoniker.this.comThread.execute(new Callable<WinNT.HRESULT>(){

                        @Override
                        public WinNT.HRESULT call() throws Exception {
                            return EnumMoniker.this.rawRot.GetObject(moniker.getPointer(), ppunkObject);
                        }
                    });
                    COMUtils.checkRC(hr);
                    Dispatch dispatch = new Dispatch(ppunkObject.getValue());
                    EnumMoniker.this.cacheNext();
                    IDispatch d = EnumMoniker.this.factory.createProxy(IDispatch.class, dispatch);
                    int n = dispatch.Release();
                    return d;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                catch (TimeoutException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }
}

