/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.NativeFileSearch;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectRegistry;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.spi.configurations.UserOptionsProvider;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;
import org.openide.util.Lookup;

public class MakeProjectFileProvider {
    protected static final ConcurrentMap<Lookup.Provider, ConcurrentMap<Folder, List<CharSequence>>> searchBase = new ConcurrentHashMap<Lookup.Provider, ConcurrentMap<Folder, List<CharSequence>>>();
    protected static final ConcurrentMap<Lookup.Provider, ConcurrentMap<CharSequence, List<CharSequence>>> fileNameSearchBase = new ConcurrentHashMap<Lookup.Provider, ConcurrentMap<CharSequence, List<CharSequence>>>();
    protected static final Collection<? extends UserOptionsProvider> packageSearch = Lookup.getDefault().lookupAll(UserOptionsProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSearchBase(Project project, Folder folder, List<CharSequence> list) {
        ConcurrentMap old;
        ConcurrentMap<Folder, List<Object>> projectSearchBase = (ConcurrentHashMap<Folder, List<Object>>)searchBase.get(project);
        if (projectSearchBase == null && (old = (ConcurrentMap)searchBase.putIfAbsent((Lookup.Provider)project, projectSearchBase = new ConcurrentHashMap<Folder, List<Object>>())) != null) {
            projectSearchBase = old;
        }
        ConcurrentHashMap<Folder, List<Object>> concurrentHashMap = projectSearchBase;
        synchronized (concurrentHashMap) {
            if (list == null) {
                projectSearchBase.remove(folder);
            } else if (list.isEmpty()) {
                projectSearchBase.put(folder, new ArrayList(0));
            } else {
                projectSearchBase.put(folder, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<CharSequence> getSearchBase(Project project, Folder folder) {
        List list;
        HashSet<CharSequence> result = new HashSet<CharSequence>();
        ConcurrentMap projectSearchBase = (ConcurrentMap)searchBase.get(project);
        if (projectSearchBase != null && (list = (List)projectSearchBase.get(folder)) != null) {
            List list2 = list;
            synchronized (list2) {
                result.addAll(list);
            }
        }
        return result;
    }

    public static void removeSearchBase(Project project) {
        searchBase.remove(project);
        fileNameSearchBase.remove(project);
    }

    public static void removeFromSearchBase(Project project, Folder folder, CharSequence item) {
        MakeProjectFileProvider.updateSearchBaseImpl(project, folder, item, true);
    }

    public static void addToSearchBase(Project project, Folder folder, CharSequence item) {
        MakeProjectFileProvider.updateSearchBaseImpl(project, folder, item, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateSearchBaseImpl(Project project, Folder folder, CharSequence item, boolean remove) {
        ConcurrentMap projectFileNames;
        ConcurrentMap projectSearchBase = (ConcurrentMap)searchBase.get(project);
        if (projectSearchBase != null) {
            ConcurrentMap concurrentMap = projectSearchBase;
            synchronized (concurrentMap) {
                List folderItems = (List)projectSearchBase.get(folder);
                if (folderItems != null) {
                    List list = folderItems;
                    synchronized (list) {
                        if (remove) {
                            folderItems.remove(item);
                        } else {
                            folderItems.add(item);
                        }
                    }
                }
            }
        }
        if ((projectFileNames = (ConcurrentMap)fileNameSearchBase.get(project)) != null) {
            Collection res;
            String fileName = item.toString();
            int i = fileName.lastIndexOf(47);
            String name = fileName;
            if (i >= 0) {
                name = fileName.substring(i + 1);
            }
            if ((res = (Collection)projectFileNames.get(CharSequences.create((CharSequence)name))) != null) {
                Collection collection = res;
                synchronized (collection) {
                    if (remove) {
                        res.remove(item);
                    } else {
                        res.add(item);
                    }
                }
            }
        }
    }

    public static class NativeFileSearchImpl
    implements NativeFileSearch {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<FSPath> searchFile(NativeProject project, String fileName) {
            if (MakeOptions.getInstance().isFixUnresolvedInclude()) {
                Collection<FSPath> res;
                for (NativeProject np : NativeProjectRegistry.getDefault().getOpenProjects()) {
                    ExecutionEnvironment env;
                    Collection<FSPath> res2;
                    Lookup.Provider p;
                    if (np != project || !((p = np.getProject()) instanceof Project)) continue;
                    ConcurrentMap<CharSequence, List<CharSequence>> projectSearchBase = (ConcurrentMap<CharSequence, List<CharSequence>>)fileNameSearchBase.get(p);
                    if (projectSearchBase == null) {
                        projectSearchBase = this.computeProjectFiles(p);
                        fileNameSearchBase.put(p, projectSearchBase);
                    }
                    int i = fileName.lastIndexOf(47);
                    String name = fileName;
                    if (i >= 0) {
                        name = fileName.substring(i + 1);
                    }
                    MakeConfiguration conf = ConfigurationSupport.getProjectActiveConfiguration((Lookup.Provider)((Project)p));
                    List list = (List)projectSearchBase.get(CharSequences.create((CharSequence)name));
                    if (list != null) {
                        List list2 = list;
                        synchronized (list2) {
                            if (list.size() > 0) {
                                FileSystem fileSystem = conf != null ? conf.getFileSystem() : FileSystemProvider.getFileSystem((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
                                ArrayList<FSPath> res3 = new ArrayList<FSPath>(list.size());
                                list.forEach(absPath -> res3.add(new FSPath(fileSystem, absPath.toString())));
                                return res3;
                            }
                        }
                    }
                    if ((res2 = this.defaultSearch(project, fileName, env = conf != null ? conf.getDevelopmentHost().getExecutionEnvironment() : ExecutionEnvironmentFactory.getLocal())) != null && res2.size() > 0) {
                        return res2;
                    }
                    return Collections.emptyList();
                }
                ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileSystem)project.getFileSystem());
                if (env == null) {
                    env = ExecutionEnvironmentFactory.getLocal();
                }
                if ((res = this.defaultSearch(project, fileName, env)) != null && res.size() > 0) {
                    return res;
                }
            }
            return Collections.emptyList();
        }

        private Collection<FSPath> defaultSearch(NativeProject project, String fileName, ExecutionEnvironment env) {
            Collection res;
            block5: {
                UserOptionsProvider userOptionsProvider;
                NativeFileSearch search;
                res = null;
                if (env == null) {
                    env = ExecutionEnvironmentFactory.getLocal();
                }
                boolean isDoSearch = false;
                if (env.isLocal()) {
                    isDoSearch = true;
                } else if (Boolean.valueOf(System.getProperty("cnd.pkg.search.enabled", "true")).booleanValue()) {
                    isDoSearch = ConnectionManager.getInstance().isConnectedTo(env);
                }
                if (packageSearch.isEmpty() || !isDoSearch) break block5;
                Iterator<? extends UserOptionsProvider> iterator = packageSearch.iterator();
                while (iterator.hasNext() && ((search = (userOptionsProvider = iterator.next()).getPackageFileSearch(env)) == null || (res = search.searchFile(project, fileName)) == null)) {
                }
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ConcurrentMap<CharSequence, List<CharSequence>> computeProjectFiles(Lookup.Provider project) {
            ConcurrentHashMap<CharSequence, List<CharSequence>> result = new ConcurrentHashMap<CharSequence, List<CharSequence>>();
            ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            if (provider != null && provider.gotDescriptor()) {
                ConcurrentMap projectSearchBase;
                MakeConfigurationDescriptor descriptor = provider.getConfigurationDescriptor();
                for (Item item : descriptor.getProjectItems()) {
                    List prev;
                    CharSequence name = CharSequences.create((CharSequence)item.getName());
                    List<CharSequence> list = (ArrayList<CharSequence>)result.get(name);
                    if (list == null && (prev = (List)result.putIfAbsent(name, list = new ArrayList<CharSequence>(1))) != null) {
                        list = prev;
                    }
                    list.add(CharSequences.create((CharSequence)item.getAbsPath()));
                }
                if (!MakeOptions.getInstance().isFullFileIndexer() && (projectSearchBase = (ConcurrentMap)searchBase.get(project)) != null) {
                    HashMap copy;
                    ConcurrentMap concurrentMap = projectSearchBase;
                    synchronized (concurrentMap) {
                        copy = new HashMap(projectSearchBase);
                    }
                    for (List files : copy.values()) {
                        if (files == null) continue;
                        List list = files;
                        synchronized (list) {
                            for (CharSequence path : files) {
                                List prev;
                                String absPath = path.toString();
                                int i = absPath.lastIndexOf(47);
                                if (i < 0) {
                                    i = absPath.lastIndexOf(92);
                                }
                                if (i < 0) continue;
                                CharSequence name = CharSequences.create((CharSequence)absPath.substring(i + 1));
                                List<CharSequence> list2 = (ArrayList<CharSequence>)result.get(name);
                                if (list2 == null && (prev = (List)result.putIfAbsent(name, list2 = new ArrayList<CharSequence>(1))) != null) {
                                    list2 = prev;
                                }
                                list2.add(path);
                            }
                        }
                    }
                }
            }
            return result;
        }
    }
}

