/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.launchers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.netbeans.modules.cnd.makeproject.api.launchers.Bundle;
import org.netbeans.modules.cnd.makeproject.api.launchers.LaunchersRegistry;
import org.netbeans.modules.cnd.makeproject.api.launchers.LaunchersRegistryFactory;
import org.netbeans.modules.cnd.makeproject.spi.ProjectMetadataFactory;
import org.netbeans.modules.cnd.spi.utils.CndNotifier;
import org.netbeans.modules.cnd.utils.UIGesturesSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;

public class LaunchersProjectMetadataFactory
implements ProjectMetadataFactory {
    public static final String NAME = "launcher.properties";
    private static final String USG_CND_LAUNCHERS = "USG_CND_LAUNCHERS";

    @Override
    public void read(FileObject projectDir) {
        if (projectDir == null || !projectDir.isValid()) {
            return;
        }
        FileObject nbproject = projectDir.getFileObject("nbproject");
        if (nbproject != null && nbproject.isValid()) {
            FileChangeListenerImpl fileChangeListener = new FileChangeListenerImpl(projectDir);
            nbproject.addRecursiveListener((FileChangeListener)fileChangeListener);
            LaunchersRegistryFactory.getInstance(projectDir).setPrivateLaucnhersListener(fileChangeListener);
        }
        LaunchersProjectMetadataFactory.reload(projectDir);
    }

    @Override
    public void write(FileObject projectDir) {
    }

    private static void reload(FileObject projectDir) {
        Throwable throwable;
        InputStream inputStream2;
        LaunchersRegistry launchersRegistry = LaunchersRegistryFactory.getInstance(projectDir);
        Properties properties = new Properties();
        FileObject nbProjectFolder = projectDir.getFileObject("nbproject");
        if (nbProjectFolder == null || !nbProjectFolder.isValid()) {
            return;
        }
        FileObject publicLaunchers = nbProjectFolder.getFileObject(NAME);
        FileObject privateNbFolder = projectDir.getFileObject("nbproject/private");
        FileObject privateLaunchers = privateNbFolder != null && privateNbFolder.isValid() ? privateNbFolder.getFileObject(NAME) : null;
        if (publicLaunchers != null && publicLaunchers.isValid()) {
            try {
                inputStream2 = publicLaunchers.getInputStream();
                throwable = null;
                try {
                    properties.load(inputStream2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream2 != null) {
                        if (throwable != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            inputStream2.close();
                        }
                    }
                }
            }
            catch (IOException inputStream2) {
            }
            catch (IllegalArgumentException ex) {
                CndNotifier.getDefault().notifyErrorLater(Bundle.illegal_string(publicLaunchers.getPath(), ex.getMessage()));
            }
        }
        if (privateLaunchers != null && privateLaunchers.isValid()) {
            try {
                inputStream2 = privateLaunchers.getInputStream();
                throwable = null;
                try {
                    properties.load(inputStream2);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (inputStream2 != null) {
                        if (throwable != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            inputStream2.close();
                        }
                    }
                }
            }
            catch (IOException inputStream3) {
            }
            catch (IllegalArgumentException ex) {
                CndNotifier.getDefault().notifyErrorLater(Bundle.illegal_string(privateLaunchers.getPath(), ex.getMessage()));
            }
        }
        if (launchersRegistry.load(properties)) {
            UIGesturesSupport.submit((String)USG_CND_LAUNCHERS, (Object[])new Object[]{launchersRegistry.getLaunchers().size()});
        }
    }

    private static class FileChangeListenerImpl
    implements FileChangeListener {
        private final FileObject projectDir;

        public FileChangeListenerImpl(FileObject projectDir) {
            this.projectDir = projectDir;
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
            if (fe.getFile().getPath().endsWith(LaunchersProjectMetadataFactory.NAME)) {
                LaunchersProjectMetadataFactory.reload(this.projectDir);
            }
        }

        public void fileChanged(FileEvent fe) {
            if (fe.getFile().getPath().endsWith(LaunchersProjectMetadataFactory.NAME)) {
                LaunchersProjectMetadataFactory.reload(this.projectDir);
            }
        }

        public void fileDeleted(FileEvent fe) {
            if (fe.getFile().getPath().endsWith(LaunchersProjectMetadataFactory.NAME)) {
                LaunchersProjectMetadataFactory.reload(this.projectDir);
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
            if (fe.getFile().getPath().endsWith(LaunchersProjectMetadataFactory.NAME)) {
                LaunchersProjectMetadataFactory.reload(this.projectDir);
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

