/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.refactoring.api.CsmContext;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public final class EncapsulateFieldsRefactoring
extends AbstractRefactoring {
    private Collection<EncapsulateFieldInfo> refactorFields = Collections.emptyList();
    private Set<CsmVisibility> methodModifiers = Collections.emptySet();
    private Set<CsmVisibility> fieldModifiers = Collections.emptySet();
    private CsmFile classDeclFile = null;
    private CsmFile classDefFile = null;
    private boolean alwaysUseAccessors;
    private boolean methodInline;

    public EncapsulateFieldsRefactoring(CsmObject selectedObject, CsmContext editorContext) {
        super(EncapsulateFieldsRefactoring.createLookup(selectedObject, editorContext));
    }

    private static Lookup createLookup(CsmObject selectedObject, CsmContext editorContext) {
        assert (selectedObject != null || editorContext != null) : "must be non null object to refactor";
        if (editorContext == null) {
            return Lookups.fixed((Object[])new Object[]{selectedObject});
        }
        if (selectedObject == null) {
            return Lookups.fixed((Object[])new Object[]{editorContext});
        }
        return Lookups.fixed((Object[])new Object[]{selectedObject, editorContext});
    }

    public Collection<EncapsulateFieldInfo> getRefactorFields() {
        return this.refactorFields;
    }

    public Set<CsmVisibility> getMethodModifiers() {
        return this.methodModifiers;
    }

    public Set<CsmVisibility> getFieldModifiers() {
        return this.fieldModifiers;
    }

    public boolean isAlwaysUseAccessors() {
        return this.alwaysUseAccessors;
    }

    public boolean isMethodInline() {
        return this.methodInline;
    }

    public void setMethodInline(boolean methodInline) {
        this.methodInline = methodInline;
    }

    public void setRefactorFields(Collection<EncapsulateFieldInfo> refactorFields) {
        this.refactorFields = Collections.unmodifiableCollection(new ArrayList<EncapsulateFieldInfo>(refactorFields));
    }

    public void setMethodModifiers(Set<CsmVisibility> methodModifier) {
        this.methodModifiers = methodModifier;
    }

    public void setFieldModifiers(Set<CsmVisibility> fieldModifier) {
        this.fieldModifiers = fieldModifier;
    }

    public void setAlwaysUseAccessors(boolean alwaysUseAccessors) {
        this.alwaysUseAccessors = alwaysUseAccessors;
    }

    public CsmFile getClassDeclarationFile() {
        return this.classDeclFile;
    }

    public void setClassDeclarationFile(CsmFile classDeclFile) {
        this.classDeclFile = classDeclFile;
    }

    public CsmFile getClassDefinitionFile() {
        return this.classDefFile;
    }

    public void setClassDefinitonFile(CsmFile classDefFile) {
        this.classDefFile = classDefFile;
    }

    public static final class EncapsulateFieldInfo {
        final CsmField field;
        final CsmMethod defaultGetter;
        final CsmMethod defaultSetter;
        final String getterName;
        final String setterName;

        public EncapsulateFieldInfo(CsmField field, String getterName, String setterName, CsmMethod defaultGetter, CsmMethod defaultSetter) {
            this.field = field;
            this.getterName = getterName;
            this.setterName = setterName;
            this.defaultGetter = defaultGetter;
            this.defaultSetter = defaultSetter;
        }

        public String getGetterName() {
            return this.getterName;
        }

        public String getSetterName() {
            return this.setterName;
        }

        public CsmField getField() {
            return this.field;
        }

        public CsmMethod getDefaultGetter() {
            return this.defaultGetter;
        }

        public CsmMethod getDefaultSetter() {
            return this.defaultSetter;
        }
    }
}

