/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.support;

import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.refactoring.support.GeneratorUtils;

public final class DeclarationGenerator {
    public static final String INLINE_PROPERTY = "inline_method";
    public static final String INSERT_CODE_INLINE_PROPERTY = "insert_code_inline_method";

    private DeclarationGenerator() {
    }

    public static String createGetter(CsmField field, String gName, Kind kind) {
        StringBuilder out = new StringBuilder();
        if (field.isStatic()) {
            out.append("static ");
        }
        if (kind == Kind.INLINE_DEFINITION_MAKRED_INLINE) {
            out.append("inline ");
        }
        out.append(field.getType().getText()).append(" ");
        if (kind == Kind.EXTERNAL_DEFINITION) {
            out.append(field.getContainingClass().getName()).append("::");
        }
        out.append(gName).append("() ");
        if (!field.isStatic()) {
            out.append("const ");
        }
        if (kind == Kind.DECLARATION) {
            out.append(";");
        } else {
            out.append("{ ").append("return ").append(field.getName()).append(";}");
        }
        return out.toString();
    }

    public static String createSetter(CsmField field, String sName, Kind kind) {
        StringBuilder out = new StringBuilder();
        CharSequence fldName = field.getName();
        String paramName = GeneratorUtils.stripFieldPrefix(fldName.toString());
        CharSequence clsName = field.getContainingClass().getName();
        out.append("\n");
        if (field.isStatic()) {
            out.append("static ");
        }
        if (kind == Kind.INLINE_DEFINITION_MAKRED_INLINE) {
            out.append("inline ");
        }
        out.append("void ");
        if (kind == Kind.EXTERNAL_DEFINITION) {
            out.append(clsName).append("::");
        }
        out.append(sName).append("(");
        out.append(field.getType().getText());
        out.append(" ").append(paramName);
        out.append(")");
        if (kind == Kind.DECLARATION) {
            out.append(";");
        } else {
            out.append("{ ");
            if (paramName.contentEquals(fldName)) {
                if (field.isStatic()) {
                    out.append(clsName).append("::");
                } else {
                    out.append("this->");
                }
            }
            out.append(fldName).append("=").append(paramName).append(";}");
        }
        return out.toString();
    }

    public static enum Kind {
        INLINE_DEFINITION,
        INLINE_DEFINITION_MAKRED_INLINE,
        DECLARATION,
        EXTERNAL_DEFINITION;

    }
}

