/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.callgraph;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.netbeans.modules.cnd.callgraph.api.Call;
import org.netbeans.modules.cnd.callgraph.api.Function;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.callgraph.FunctionImpl;
import org.netbeans.modules.cnd.navigation.callgraph.VariableImpl;
import org.openide.text.PositionBounds;

public class CallImpl
implements Call {
    private final Function owner;
    private final Function callee;
    private final boolean nameOrder;
    private final int firstOccurrenceOffset;
    private final ArrayList<Call.Occurrence> occurrences;
    private final CharSequence description;
    private final CharSequence htmlName;

    public CallImpl(CsmOffsetableDeclaration owner, ArrayList<CsmReference> references, CsmOffsetableDeclaration callee, boolean nameOrder) {
        this.nameOrder = nameOrder;
        this.owner = CallImpl.implementationResolver(owner);
        this.callee = CallImpl.implementationResolver(callee);
        this.occurrences = this.initOccurrences(references);
        this.firstOccurrenceOffset = references.get(0).getStartOffset();
        this.description = this.initDescription(references.get(0));
        this.htmlName = this.initHtmlDisplayName(references.get(0));
    }

    public void open() {
        if (this.occurrences.isEmpty()) {
            return;
        }
        this.occurrences.get(0).open();
    }

    public Function getCallee() {
        return this.callee;
    }

    public Function getCaller() {
        return this.owner;
    }

    public Collection<Call.Occurrence> getOccurrences() {
        return this.occurrences;
    }

    public String getHtmlDisplayName() {
        if (this.htmlName != null) {
            return this.htmlName.toString();
        }
        return null;
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description.toString();
        }
        return null;
    }

    public String toString() {
        if (this.nameOrder) {
            return this.getCallee().getName() + "<-" + this.getCaller().getName();
        }
        return this.getCaller().getName() + "->" + this.getCallee().getName();
    }

    public int compareTo(Call o) {
        if (this.nameOrder) {
            return this.getCaller().getName().compareTo(o.getCaller().getName());
        }
        int diff = this.firstOccurrenceOffset - ((CallImpl)o).firstOccurrenceOffset;
        if (diff == 0) {
            return this.getCallee().getName().compareTo(o.getCallee().getName());
        }
        return diff;
    }

    private CharSequence initHtmlDisplayName(CsmReference reference) {
        return CsmReferenceSupport.getContextLineHtml((CsmReference)reference, (boolean)true);
    }

    private CharSequence initDescription(CsmReference reference) {
        return CsmReferenceSupport.getContextLine((CsmReference)reference);
    }

    private ArrayList<Call.Occurrence> initOccurrences(ArrayList<CsmReference> references) {
        ArrayList<Call.Occurrence> result = new ArrayList<Call.Occurrence>(references.size());
        for (CsmReference ref : references) {
            result.add(new OccurrenceImpl(ref));
        }
        return result;
    }

    private static Function implementationResolver(CsmOffsetableDeclaration entity) {
        if (CsmKindUtilities.isFunction((CsmObject)entity)) {
            return new FunctionImpl((CsmFunction)entity);
        }
        if (CsmKindUtilities.isVariable((CsmObject)entity)) {
            return new VariableImpl((CsmOffsetableDeclaration)((CsmVariable)entity));
        }
        if (CsmKindUtilities.isEnumerator((Object)entity)) {
            return new VariableImpl((CsmOffsetableDeclaration)((CsmEnumerator)entity));
        }
        return null;
    }

    private static class OccurrenceImpl
    implements Call.Occurrence {
        private final PositionBounds positions;
        private final CharSequence description;
        private final CharSequence htmlName;

        private OccurrenceImpl(CsmReference reference) {
            this.positions = CsmUtilities.createPositionBounds((CsmOffsetable)reference);
            this.description = this.initDescription(reference);
            this.htmlName = this.initHtmlDisplayName(reference);
        }

        public void open() {
            CsmUtilities.openSource((PositionBounds)this.positions);
        }

        public String getHtmlDisplayName() {
            if (this.htmlName != null) {
                return this.htmlName.toString();
            }
            return null;
        }

        public String getDescription() {
            if (this.description != null) {
                return this.description.toString();
            }
            return null;
        }

        private CharSequence initHtmlDisplayName(CsmReference ref) {
            return CsmReferenceSupport.getContextLineHtml((CsmReference)ref, (boolean)true);
        }

        private CharSequence initDescription(CsmReference ref) {
            return CsmReferenceSupport.getContextLine((CsmReference)ref);
        }
    }
}

