/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apdutool;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.apduio.CadDevice;
import com.sun.javacard.apdutool.Msg;
import com.sun.javacard.apdutool.MultiInputStream;
import com.sun.javacard.apdutool.ReaderWriter;
import com.sun.javacard.apdutool.ReaderWriterError;
import com.sun.javacard.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Main {
    public static boolean noBanner = false;
    public static boolean printATR = true;
    public static boolean verbose = false;
    private static boolean formatOutput = false;
    public static byte protocolType = 1;
    private static Vector<String> inputList = new Vector();
    private static String logSpec = "-";
    private static PrintWriter logWriter;
    static String hostName;
    static boolean multipleInterfaces;
    static int port;
    private static int timeout;
    static String serialPortName;
    static boolean keepPreprocessedFiles;
    private static int readerNumber;

    public static void main(String[] stringArray) {
        Closeable closeable;
        Object object;
        Object[] objectArray;
        int n;
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
            if (stringArray[n].equals("-help")) {
                Main.usage(false);
                System.exit(0);
                continue;
            }
            if (stringArray[n].equals("-h")) {
                if (++n < stringArray.length) {
                    hostName = stringArray[n];
                    continue;
                }
                Main.usage(true);
                continue;
            }
            if (stringArray[n].startsWith("-h")) {
                hostName = stringArray[n].substring(2);
                continue;
            }
            if (stringArray[n].equals("-nobanner")) {
                noBanner = true;
                continue;
            }
            if (stringArray[n].equals("-verbose")) {
                verbose = true;
                continue;
            }
            if (stringArray[n].equals("-noatr")) {
                printATR = false;
                continue;
            }
            if (stringArray[n].equals("-d") || stringArray[n].equals("--descriptiveoutput")) {
                formatOutput = true;
                continue;
            }
            if (stringArray[n].equals("-t0")) {
                if (protocolType == -85) {
                    Msg.warn("pcsc.2", null);
                    continue;
                }
                protocolType = 0;
                continue;
            }
            if (stringArray[n].equals("-mi")) {
                multipleInterfaces = true;
                continue;
            }
            if (stringArray[n].equals("-p")) {
                if (++n < stringArray.length) {
                    try {
                        port = Integer.parseInt(stringArray[n]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Main.usage(true);
                    }
                    continue;
                }
                Main.usage(true);
                continue;
            }
            if (stringArray[n].startsWith("-p")) {
                try {
                    port = Integer.parseInt(stringArray[n].substring(2));
                }
                catch (NumberFormatException numberFormatException) {
                    Main.usage(true);
                }
                continue;
            }
            if (stringArray[n].equals("-o")) {
                if (++n < stringArray.length) {
                    logSpec = stringArray[n];
                    continue;
                }
                Main.usage(true);
                continue;
            }
            if (stringArray[n].startsWith("-o")) {
                logSpec = stringArray[n].substring(2);
                continue;
            }
            if (stringArray[n].equals("-s")) {
                if (++n < stringArray.length) {
                    serialPortName = stringArray[n];
                    continue;
                }
                Main.usage(true);
                continue;
            }
            if (stringArray[n].startsWith("-s")) {
                serialPortName = stringArray[n].substring(2);
                continue;
            }
            if (stringArray[n].startsWith("-k")) {
                keepPreprocessedFiles = true;
                continue;
            }
            if (stringArray[n].equals("-version")) {
                Main.banner();
                System.exit(0);
                continue;
            }
            if (stringArray[n].equals("--")) {
                ++n;
                break;
            }
            objectArray = new Object[]{stringArray[n]};
            Msg.error("main.6", objectArray);
            Main.usage(true);
        }
        if (!noBanner) {
            Main.banner();
        }
        try {
            while (n < stringArray.length) {
                if ((objectArray = stringArray[n++]).equals("-")) {
                    inputList.addElement(stringArray[n]);
                    continue;
                }
                if (objectArray.startsWith("@")) {
                    Main.readListFromFile(inputList, objectArray.substring(1));
                    continue;
                }
                inputList.addElement(new File((String)objectArray).getCanonicalPath());
            }
            if (inputList.isEmpty()) {
                inputList.addElement("-");
            }
            logWriter = logSpec.equals("-") ? new PrintWriter(System.out, true) : new PrintWriter(new FileWriter(new File(logSpec).getCanonicalPath()));
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            System.exit(1);
        }
        objectArray = null;
        if (inputList.size() == 1 && "-".equals(inputList.elementAt(0))) {
            objectArray = System.in;
        } else {
            object = new MultiInputStream();
            for (String object2 : inputList) {
                try {
                    closeable = object2.equals("-") ? new BufferedInputStream(System.in) : new BufferedInputStream(new ByteArrayInputStream(Main.preprocess(object2)));
                    ((MultiInputStream)object).addStream((InputStream)closeable);
                }
                catch (FileNotFoundException exception) {
                    System.err.println("Input file \"" + object2 + "\" not found");
                    Main.usage(true);
                    System.exit(1);
                }
                catch (Exception exception) {
                    System.err.println(exception);
                    System.exit(1);
                }
            }
            objectArray = object;
        }
        try {
            Object[] objectArray2;
            if (protocolType == -85) {
                object = new ReaderWriter((InputStream)objectArray, CadDevice.getPCSCClientInstance(readerNumber), logWriter);
            } else if (serialPortName == null) {
                if (!noBanner) {
                    objectArray2 = new Object[]{hostName, "" + port};
                    Msg.info("main.0", objectArray2);
                }
                if (!noBanner) {
                    Msg.info("main.2", null);
                }
                if (multipleInterfaces) {
                    object = new ReaderWriter((InputStream)objectArray, null, logWriter);
                } else {
                    objectArray2 = Main.openSocket(hostName, port);
                    objectArray2.setTcpNoDelay(true);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(objectArray2.getInputStream());
                    closeable = new BufferedOutputStream(objectArray2.getOutputStream());
                    object = new ReaderWriter((InputStream)objectArray, CadDevice.getCadClientInstance(protocolType, bufferedInputStream, (OutputStream)closeable), logWriter);
                }
            } else {
                if (!noBanner) {
                    objectArray2 = new Object[]{serialPortName};
                    Msg.info("main.1", objectArray2);
                }
                object = Main.connectToSerialPort((InputStream)objectArray, serialPortName, logWriter);
            }
            ((ReaderWriter)object).setPrintATR(printATR);
            ((ReaderWriter)object).setFormatOutput(formatOutput);
            ((ReaderWriter)object).run();
        }
        catch (ReaderWriterError readerWriterError) {
            System.err.println(readerWriterError.getMessage());
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        logWriter.flush();
        if (!logSpec.equals("-")) {
            logWriter.close();
        }
        System.exit(0);
    }

    private static byte[] preprocess(String string) throws Exception {
        Object object;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Object object2 = null;
        String string2 = null;
        int n = 0;
        String string3 = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
        while ((string3 = bufferedReader.readLine()) != null) {
            ++n;
            if ((string3 = string3.trim()).length() <= 0) {
                byteArrayOutputStream.write("\n".getBytes());
                continue;
            }
            if (string3.startsWith("#define ")) {
                object = string3.substring(8);
                if (((String)(object = ((String)object).trim())).length() <= 0) {
                    throw new Exception("Empty #define statement at " + string + "#" + n);
                }
                int n2 = ((String)object).indexOf(" ");
                if (n2 == -1) {
                    n2 = ((String)object).indexOf("\t");
                }
                if (n2 == -1) {
                    object2 = object;
                    string2 = "";
                } else {
                    object2 = ((String)object).substring(0, n2).trim();
                    string2 = ((String)object).substring(n2 + 1).trim();
                }
                if (!StringUtils.isValidAPDUScriptDefine((String)object2)) {
                    throw new Exception("Invalid/Illegal define symbol '" + (String)object2 + "' at " + string + "#" + n);
                }
                string2 = Main.replaceDefines(string2, hashtable);
                hashtable.put((String)object2, string2);
                byteArrayOutputStream.write("\n".getBytes());
                continue;
            }
            string3 = Main.replaceDefines(string3, hashtable);
            byteArrayOutputStream.write(string3.getBytes());
            byteArrayOutputStream.write("\n".getBytes());
        }
        object = byteArrayOutputStream.toByteArray();
        if (keepPreprocessedFiles) {
            FileOutputStream fileOutputStream = new FileOutputStream(string + ".preprocessed");
            fileOutputStream.write((byte[])object);
        }
        return object;
    }

    private static void banner() {
        Msg.info(ToolsVersion.getToolName(6) + ToolsVersion.getVersion(6));
        Msg.info(ToolsVersion.getCopyrightBanner());
        if (protocolType == -85) {
            Msg.warn("pcsc.1", null);
        }
        System.out.flush();
    }

    private static void usage(boolean bl) {
        if (bl) {
            Msg.error("main.5", null);
            System.exit(1);
        } else {
            Msg.info("main.5", null);
        }
    }

    private static Socket openSocket(String string, int n) {
        Socket socket = null;
        try {
            socket = new Socket(hostName, n);
        }
        catch (UnknownHostException unknownHostException) {
            Object[] objectArray = new Object[]{hostName};
            Msg.error("main.4", objectArray);
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            System.exit(1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray = new Object[]{illegalArgumentException.getLocalizedMessage()};
            Msg.error("main.8", objectArray);
            System.exit(1);
        }
        return socket;
    }

    static void readListFromFile(Vector<String> vector, String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).length() <= 0) continue;
                vector.addElement(string2);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReaderWriter connectToSerialPort(InputStream inputStream, String string, PrintWriter printWriter) {
        try {
            Class<?> clazz = Class.forName("javax.comm.CommPort");
            Class<?> clazz2 = Class.forName("javax.comm.CommPortIdentifier");
            Class[] classArray = new Class[]{String.class};
            Method method = clazz2.getMethod("getPortIdentifier", classArray);
            Object object = method.invoke(null, string);
            classArray = new Class[]{String.class, Integer.TYPE};
            Method method2 = clazz2.getMethod("open", classArray);
            Object object2 = method2.invoke(object, "apdutool", new Integer(30000));
            Method method3 = clazz.getMethod("getInputStream", new Class[0]);
            Method method4 = clazz.getMethod("getOutputStream", new Class[0]);
            InputStream inputStream2 = (InputStream)method3.invoke(object2, new Object[0]);
            OutputStream outputStream = (OutputStream)method4.invoke(object2, new Object[0]);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            if (!noBanner) {
                Msg.info("main.2", null);
            }
            return new ReaderWriter(inputStream, CadDevice.getCadClientInstance(protocolType, bufferedInputStream, bufferedOutputStream), printWriter);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Msg.info("main.9", null);
            System.exit(1);
        }
        catch (Exception exception) {
            Msg.info("main.10", null);
            try {
                Class<?> clazz = Class.forName("javax.comm.CommPortIdentifier");
                Method method = clazz.getMethod("getPortIdentifiers", new Class[0]);
                Method method5 = clazz.getMethod("getName", new Class[0]);
                Enumeration enumeration = (Enumeration)method.invoke(null, new Object[0]);
                Msg.info("main.11", null);
                if (enumeration != null && enumeration.hasMoreElements()) {
                    while (enumeration.hasMoreElements()) {
                        Object e = enumeration.nextElement();
                        System.out.println(method5.invoke(e, new Object[0]));
                    }
                } else {
                    Msg.info("main.12", null);
                }
            }
            catch (Exception exception2) {
            }
            finally {
                System.exit(1);
            }
        }
        return null;
    }

    private static String replaceDefines(String string, Hashtable<String, String> hashtable) {
        String string2 = null;
        for (String string3 : hashtable.keySet()) {
            string2 = "[ \\t]*" + string3 + "[ \\t]*";
            string = string.replaceAll(string2, " " + hashtable.get(string3) + " ");
        }
        return string;
    }

    static {
        hostName = "localhost";
        port = 9025;
        timeout = 0;
        serialPortName = null;
        keepPreprocessedFiles = false;
        readerNumber = 0;
    }
}

