/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.history.CVSRepository;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.util.Executor;

class CVSHistoryParser
implements Executor.StreamHandler {
    private History history;
    private CVSRepository repository = new CVSRepository();

    CVSHistoryParser() {
    }

    @Override
    public void processStream(InputStream input) throws IOException {
        DateFormat df = this.repository.getDateFormat();
        ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        BufferedReader in = new BufferedReader(new InputStreamReader(input));
        this.history = new History();
        HistoryEntry entry = null;
        HashMap<String, String> tags = null;
        ParseState state = ParseState.NAMES;
        String s = in.readLine();
        while (s != null) {
            if (state == ParseState.NAMES && s.startsWith("symbolic names:")) {
                tags = new HashMap<String, String>();
                state = ParseState.TAG;
                s = in.readLine();
            }
            if (state == ParseState.TAG) {
                if (s.startsWith("\t")) {
                    String[] pair = s.trim().split(": ");
                    if (pair.length != 2) {
                        OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to parse tag: ''{0}''", s);
                    } else if (tags.containsKey(pair[1])) {
                        String oldtag = (String)tags.get(pair[1]);
                        tags.remove(pair[1]);
                        tags.put(pair[1], oldtag + " " + pair[0]);
                    } else {
                        tags.put(pair[1], pair[0]);
                    }
                } else {
                    state = ParseState.REVISION;
                    s = in.readLine();
                }
            }
            if (state == ParseState.REVISION && s.startsWith("revision")) {
                if (entry != null) {
                    entries.add(entry);
                }
                entry = new HistoryEntry();
                entry.setActive(true);
                String commit = s.substring("revision".length()).trim();
                entry.setRevision(commit);
                if (tags.containsKey(commit)) {
                    entry.setTags((String)tags.get(commit));
                }
                state = ParseState.METADATA;
                s = in.readLine();
            }
            if (state == ParseState.METADATA && s.startsWith("date:")) {
                for (String pair : s.split(";")) {
                    String[] keyVal = pair.split(":", 2);
                    String key = keyVal[0].trim();
                    String val = keyVal[1].trim();
                    if ("date".equals(key)) {
                        try {
                            val = val.replace('/', '-');
                            entry.setDate(df.parse(val));
                        }
                        catch (ParseException pe) {
                            OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to parse date: '" + val + "'", pe);
                        }
                        continue;
                    }
                    if (!"author".equals(key)) continue;
                    entry.setAuthor(val);
                }
                state = ParseState.COMMENT;
                s = in.readLine();
            }
            if (state == ParseState.COMMENT) {
                if (s.startsWith("--------")) {
                    state = ParseState.REVISION;
                } else if (s.startsWith("========")) {
                    state = ParseState.NAMES;
                } else if (entry != null) {
                    entry.appendMessage(s);
                }
            }
            s = in.readLine();
        }
        if (entry != null) {
            entries.add(entry);
        }
        this.history.setHistoryEntries(entries);
    }

    History parse(File file, Repository repos) throws HistoryException {
        this.repository = (CVSRepository)repos;
        try {
            Executor executor = this.repository.getHistoryLogExecutor(file);
            int status = executor.exec(true, this);
            if (status != 0) {
                throw new HistoryException("Failed to get history for: \"" + file.getAbsolutePath() + "\" Exit code: " + status);
            }
        }
        catch (IOException e) {
            throw new HistoryException("Failed to get history for: \"" + file.getAbsolutePath() + "\"", e);
        }
        return this.history;
    }

    History parse(String buffer) throws IOException {
        this.processStream(new ByteArrayInputStream(buffer.getBytes("UTF-8")));
        return this.history;
    }

    private static enum ParseState {
        NAMES,
        TAG,
        REVISION,
        METADATA,
        COMMENT;

    }
}

