/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.manipulators;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssString;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CssStringManipulator
implements ElementManipulator<CssString> {
    public CssString handleContentChange(@NotNull CssString element, String newContent) throws IncorrectOperationException {
        if (element == null) {
            CssStringManipulator.$$$reportNull$$$0(0);
        }
        return this.handleContentChange(element, this.getRangeInElement(element), newContent);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull CssString element) {
        if (element == null) {
            CssStringManipulator.$$$reportNull$$$0(1);
        }
        String text = element.getText();
        int length = text.length();
        int start = 0;
        if (length == 0) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                CssStringManipulator.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        char c = text.charAt(0);
        if (c == '~' && length > 1) {
            c = text.charAt(1);
            start = 1;
        }
        if (c == '\'' || c == '\"') {
            if (length == 1) {
                TextRange textRange = new TextRange(1, 1);
                if (textRange == null) {
                    CssStringManipulator.$$$reportNull$$$0(3);
                }
                return textRange;
            }
            ++start;
        } else {
            start = 0;
        }
        c = text.charAt(length - 1);
        TextRange textRange = new TextRange(start, c == '\'' || c == '\"' ? length - 1 : length);
        if (textRange == null) {
            CssStringManipulator.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    public CssString handleContentChange(@NotNull CssString element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            CssStringManipulator.$$$reportNull$$$0(5);
        }
        if (range == null) {
            CssStringManipulator.$$$reportNull$$$0(6);
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{element})) {
            return element;
        }
        String newText = range.replace(element.getText(), newContent);
        char quoteChar = !newText.isEmpty() && newText.charAt(0) == '\'' && newText.charAt(newText.length() - 1) == '\'' ? (char)'\'' : '\"';
        CssElementFactory elementFactory = CssElementFactory.getInstance((Project)element.getProject());
        element.getFirstChild().replace(elementFactory.createStringToken(quoteChar, StringUtil.unquoteString((String)newText), CssPsiUtil.getStylesheetLanguage((PsiElement)element)));
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/manipulators/CssStringManipulator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/manipulators/CssStringManipulator";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

