/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssKeyframesRuleImpl;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssFixFactory;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CssInvalidPseudoSelectorInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssInvalidPseudoSelectorInspection.$$$reportNull$$$0(0);
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitPseudoSelector(@NotNull CssPseudoSelector pseudoSelector) {
                if (pseudoSelector == null) {
                    1.$$$reportNull$$$0(0);
                }
                String name = pseudoSelector.getName();
                PsiElement nameIdentifier = pseudoSelector.getNameIdentifier();
                if (StringUtil.isEmpty((String)name) || nameIdentifier == null) {
                    return;
                }
                Collection descriptors = CssDescriptorsUtil.getPseudoSelectorDescriptors((String)name, (PsiElement)pseudoSelector);
                if (descriptors.isEmpty()) {
                    holder.registerProblem(nameIdentifier, CssBundle.message((String)"css.inspections.invalid.pseudo.unknown.message", (Object[])new Object[]{name}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    return;
                }
                Collection filteredByContextDescriptors = CssInspectionsUtil.filterDescriptorsByContextAndCheck(descriptors, nameIdentifier, holder);
                CssInvalidPseudoSelectorInspection.filterByPrefixAndCheck(filteredByContextDescriptors, pseudoSelector, holder);
            }

            public void visitAtRule(CssAtRule atRule) {
                if (atRule instanceof CssKeyframesRuleImpl) {
                    CssKeyframesRuleImpl keyframesRule = (CssKeyframesRuleImpl)atRule;
                    PsiElement colon = keyframesRule.findPsiChildByType(CssElementTypes.CSS_COLON);
                    if (colon == null) {
                        return;
                    }
                    PsiElement element = colon.getNextSibling();
                    if (element == null || element.getNode().getElementType() != CssElementTypes.CSS_FUNCTION_TOKEN) {
                        return;
                    }
                    String name = element.getText();
                    if (!"local".equals(name) && !"global".equals(name)) {
                        holder.registerProblem(element, CssBundle.message((String)"css.inspections.invalid.pseudo.keyframes.message", (Object[])new Object[]{name}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pseudoSelector", "com/intellij/psi/css/inspections/invalid/CssInvalidPseudoSelectorInspection$1", "visitPseudoSelector"));
            }
        };
        if (cssElementVisitor == null) {
            CssInvalidPseudoSelectorInspection.$$$reportNull$$$0(1);
        }
        return cssElementVisitor;
    }

    private static Collection<CssPseudoSelectorDescriptor> filterByPrefixAndCheck(@NotNull Collection<? extends CssPseudoSelectorDescriptor> descriptors, @NotNull CssPseudoSelector selector, @NotNull ProblemsHolder holder) {
        if (descriptors == null) {
            CssInvalidPseudoSelectorInspection.$$$reportNull$$$0(2);
        }
        if (selector == null) {
            CssInvalidPseudoSelectorInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            CssInvalidPseudoSelectorInspection.$$$reportNull$$$0(4);
        }
        TextRange givenPrefixRange = selector.getColonPrefixRange();
        int givenPrefixLength = selector.getColonPrefixLength();
        Collection filteredByColonPrefix = CssDescriptorsUtil.filterPseudoSelectorDescriptorsByColonPrefix(descriptors, (int)givenPrefixLength);
        if (filteredByColonPrefix.isEmpty()) {
            for (CssPseudoSelectorDescriptor cssPseudoSelectorDescriptor : descriptors) {
                int expectedPrefixLength = cssPseudoSelectorDescriptor.getColonPrefixLength();
                holder.registerProblem((PsiElement)selector, CssBundle.message((String)"css.inspections.invalid.pseudo.prefix", (Object[])new Object[]{StringUtil.repeatSymbol((char)':', (int)expectedPrefixLength)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, givenPrefixRange, new LocalQuickFix[]{CssFixFactory.getInstance().replacePseudoPrefixQuickFix(givenPrefixLength, expectedPrefixLength)});
            }
        }
        return filteredByColonPrefix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/invalid/CssInvalidPseudoSelectorInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/invalid/CssInvalidPseudoSelectorInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "filterByPrefixAndCheck";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

