/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.util.MemoryDumpHelper;
import com.jetbrains.performancePlugin.Timer;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class MemoryDumpCommand
extends AbstractCommand {
    public static final String PREFIX = "%memoryDump";

    public MemoryDumpCommand(@NotNull String text, int line) {
        if (text == null) {
            MemoryDumpCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        if (MemoryDumpHelper.memoryDumpAvailable()) {
            System.gc();
            String memoryDumpPath = System.getProperties().getProperty("memory.snapshots.path");
            String path = "";
            if (memoryDumpPath != null) {
                path = path + memoryDumpPath + File.separator;
            }
            String currentTime = new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
            path = path + Timer.instance.getActivityName() + '-' + currentTime + ".zip";
            try {
                MemoryDumpHelper.captureMemoryDumpZipped((String)path);
                context.message("Memory snapshot is saved at " + path, this.getLine());
                return Promises.resolvedPromise();
            }
            catch (Exception e) {
                return Promises.rejectedPromise((String)"Memory dump can't be collected");
            }
        }
        return Promises.rejectedPromise((String)"Memory dump can't be collected");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/performancePlugin/commands/MemoryDumpCommand", "<init>"));
    }
}

