/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.HashMap;
import java.util.Map;

public class ApplyPatchContext {
    private final VirtualFile myBaseDir;
    private final int mySkipTopDirs;
    private final boolean myCreateDirectories;
    private final boolean myAllowRename;
    private final Map<VirtualFile, FilePath> myPathsBeforeRename = new HashMap<VirtualFile, FilePath>();

    public ApplyPatchContext(VirtualFile baseDir, int skipTopDirs, boolean createDirectories, boolean allowRename) {
        this.myBaseDir = baseDir;
        this.mySkipTopDirs = skipTopDirs;
        this.myCreateDirectories = createDirectories;
        this.myAllowRename = allowRename;
    }

    public VirtualFile getBaseDir() {
        return this.myBaseDir;
    }

    public int getSkipTopDirs() {
        return this.mySkipTopDirs;
    }

    public boolean isAllowRename() {
        return this.myAllowRename;
    }

    public boolean isCreateDirectories() {
        return this.myCreateDirectories;
    }

    public ApplyPatchContext getPrepareContext() {
        return new ApplyPatchContext(this.myBaseDir, this.mySkipTopDirs, false, false);
    }

    public void registerBeforeRename(VirtualFile file2) {
        FilePath path = VcsUtil.getFilePath((VirtualFile)file2);
        this.myPathsBeforeRename.put(file2, path);
    }

    public FilePath getPathBeforeRename(VirtualFile file2) {
        FilePath path = this.myPathsBeforeRename.get(file2);
        if (path != null) {
            return path;
        }
        return VcsUtil.getFilePath((VirtualFile)file2);
    }
}

