/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.SLRUMap;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.heap.calculation.ByteArrayWrapper;
import com.jetbrains.nodejs.run.profile.heap.calculation.Flags;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapInMemoryIndexes;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8ImportantStringsHolder;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8StringIndex;
import com.jetbrains.nodejs.run.profile.heap.data.Aggregate;
import com.jetbrains.nodejs.run.profile.heap.data.LinkedByNameId;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapGraphEdgeType;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapHeader;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapNodeType;
import com.jetbrains.nodejs.run.profile.heap.io.RandomRawReader;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReader;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReaderFactory;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8CachingReader
implements Closeable {
    @NotNull
    private final File myOriginalFile;
    @NotNull
    private final ByteArrayWrapper myDigest;
    @NotNull
    private final V8StringIndex myStringIndex;
    @NotNull
    private final File myNodeIndexFile;
    @NotNull
    private final File myEdgeIndexFile;
    @NotNull
    private final LinksReaderFactory<LinkedByNameId> myStringReverseIndexProcessor;
    @NotNull
    private final LinksReaderFactory<V8HeapEdge> myReverseLinkIndexProcessor;
    private final SLRUMap<Long, V8HeapEntry> myNodeMap;
    private final SLRUMap<Long, V8HeapEdge> myEdgeMap;
    private final SLRUMap<Long, List<V8HeapEdge>> myChildrenMap;
    private final SLRUMap<Long, List<Long>> myChildrenByAggregateMap;
    private final SLRUMap<Long, List<V8HeapEdge>> myParentsMap;
    private final SLRUMap<Long, String> myStringMap;
    private final RandomRawReader<V8HeapEntry> myNodeReader;
    private final RandomRawReader<V8HeapEdge> myEdgeReader;
    private final LinksReader<LinkedByNameId> myReverseStringIndexReader;
    private final LinksReader<V8HeapEdge> myReverseLinksReader;
    private final CompositeCloseable myResourses;
    private final V8HeapHeader myHeader;
    @Nullable
    private final Consumer<? super String> myErrorNotificator;
    private final Comparator<V8HeapEdge> myRetainersComparator;
    @NotNull
    private final V8ImportantStringsHolder myStringsHolder;
    private LinksReader<Long> myAggregatesLinksReader;
    private final Comparator<V8HeapEdge> myChildrenComparator;
    private final Object myLock;
    private LinksReaderFactory<Long> myAggregatesLinksReaderFactory;
    private final Comparator<Long> myByRetained;
    private V8HeapEntry myRootNode;
    private boolean myShowHidden;
    private V8HeapInMemoryIndexes myInMemoryIndexes;

    public V8CachingReader(@NotNull File originalFile, @NotNull ByteArrayWrapper digest, CompositeCloseable resourses, V8HeapHeader header, @Nullable Consumer<? super String> errorNotificator, @NotNull V8StringIndex stringIndex, @NotNull File nodeIndexFile, @NotNull File edgeIndexFile, @NotNull LinksReaderFactory<LinkedByNameId> stringReverseIndexProcessor, @NotNull LinksReaderFactory<V8HeapEdge> reverseLinkIndexProcessor, @NotNull V8ImportantStringsHolder stringsHolder) throws IOException {
        if (originalFile == null) {
            V8CachingReader.$$$reportNull$$$0(0);
        }
        if (digest == null) {
            V8CachingReader.$$$reportNull$$$0(1);
        }
        if (stringIndex == null) {
            V8CachingReader.$$$reportNull$$$0(2);
        }
        if (nodeIndexFile == null) {
            V8CachingReader.$$$reportNull$$$0(3);
        }
        if (edgeIndexFile == null) {
            V8CachingReader.$$$reportNull$$$0(4);
        }
        if (stringReverseIndexProcessor == null) {
            V8CachingReader.$$$reportNull$$$0(5);
        }
        if (reverseLinkIndexProcessor == null) {
            V8CachingReader.$$$reportNull$$$0(6);
        }
        if (stringsHolder == null) {
            V8CachingReader.$$$reportNull$$$0(7);
        }
        this.myOriginalFile = originalFile;
        this.myDigest = digest;
        this.myStringsHolder = stringsHolder;
        this.myShowHidden = true;
        this.myResourses = resourses;
        this.myHeader = header;
        this.myErrorNotificator = errorNotificator;
        this.myStringIndex = stringIndex;
        this.myNodeIndexFile = nodeIndexFile;
        this.myEdgeIndexFile = edgeIndexFile;
        this.myStringReverseIndexProcessor = stringReverseIndexProcessor;
        this.myReverseLinkIndexProcessor = reverseLinkIndexProcessor;
        this.myNodeMap = new SLRUMap(600, 1500);
        this.myChildrenMap = new SLRUMap(600, 1500);
        this.myParentsMap = new SLRUMap(200, 500);
        this.myStringMap = new SLRUMap(200, 500);
        this.myEdgeMap = new SLRUMap(200, 500);
        this.myChildrenByAggregateMap = new SLRUMap(200, 500);
        this.myLock = new Object();
        this.myNodeReader = this.myResourses.register(new RandomRawReader<V8HeapEntry>(nodeIndexFile, V8HeapEntry.MyRawSerializer.getInstance()));
        this.myEdgeReader = this.myResourses.register(new RandomRawReader<V8HeapEdge>(edgeIndexFile, V8HeapEdge.MyRawSerializer.getInstance()));
        this.myReverseLinksReader = this.myResourses.register(reverseLinkIndexProcessor.create(false));
        this.myReverseStringIndexReader = this.myResourses.register(stringReverseIndexProcessor.create(false));
        this.fillInitial();
        this.myChildrenComparator = (o1, o2) -> Long.compare(this.getRetainedSize((int)o2.getToIndex()), this.getRetainedSize((int)o1.getToIndex()));
        this.myRetainersComparator = Comparator.comparingInt(o -> this.getDistance((int)o.getFromIndex()));
        this.myByRetained = (o1, o2) -> Long.compare(this.myInMemoryIndexes.getRetainedSizes().get(o2.intValue()), this.myInMemoryIndexes.getRetainedSizes().get(o1.intValue()));
    }

    @NotNull
    public File getOriginalFile() {
        File file = this.myOriginalFile;
        if (file == null) {
            V8CachingReader.$$$reportNull$$$0(8);
        }
        return file;
    }

    @NotNull
    public ByteArrayWrapper getDigest() {
        ByteArrayWrapper byteArrayWrapper = this.myDigest;
        if (byteArrayWrapper == null) {
            V8CachingReader.$$$reportNull$$$0(9);
        }
        return byteArrayWrapper;
    }

    public CompositeCloseable getResourses() {
        return this.myResourses;
    }

    @NotNull
    public LinksReaderFactory<LinkedByNameId> getStringReverseIndexReaderFactory() {
        LinksReaderFactory<LinkedByNameId> linksReaderFactory = this.myStringReverseIndexProcessor;
        if (linksReaderFactory == null) {
            V8CachingReader.$$$reportNull$$$0(10);
        }
        return linksReaderFactory;
    }

    public V8HeapHeader getHeader() {
        return this.myHeader;
    }

    @NotNull
    public LinksReaderFactory<V8HeapEdge> getReverseLinkIndexReaderFactory() {
        LinksReaderFactory<V8HeapEdge> linksReaderFactory = this.myReverseLinkIndexProcessor;
        if (linksReaderFactory == null) {
            V8CachingReader.$$$reportNull$$$0(11);
        }
        return linksReaderFactory;
    }

    @NotNull
    public File getNodeIndexFile() {
        File file = this.myNodeIndexFile;
        if (file == null) {
            V8CachingReader.$$$reportNull$$$0(12);
        }
        return file;
    }

    @NotNull
    public File getEdgeIndexFile() {
        File file = this.myEdgeIndexFile;
        if (file == null) {
            V8CachingReader.$$$reportNull$$$0(13);
        }
        return file;
    }

    @Override
    public void close() throws IOException {
        this.myResourses.close();
    }

    private void fillInitial() throws IOException {
        this.myRootNode = this.myNodeReader.read(0L);
        this.myNodeMap.put((Object)0L, (Object)this.myRootNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V8HeapEntry getNode(long id) {
        Object object = this.myLock;
        synchronized (object) {
            V8HeapEntry cached = (V8HeapEntry)this.myNodeMap.get((Object)id);
            if (cached != null) {
                return cached;
            }
            try {
                V8HeapEntry node = this.myNodeReader.read(id);
                this.myNodeMap.put((Object)id, (Object)node);
                return node;
            }
            catch (IOException e) {
                this.reportError(e.getMessage());
                return V8CachingReader.errorNode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<V8HeapEdge> getChildrenByNodeId(@NotNull Long parentId) {
        if (parentId == null) {
            V8CachingReader.$$$reportNull$$$0(14);
        }
        Object object = this.myLock;
        synchronized (object) {
            List list = (List)this.myChildrenMap.get((Object)parentId);
            if (list != null) {
                return list;
            }
            return this.getChildren(this.getNode(parentId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<V8HeapEdge> getChildren(@NotNull V8HeapEntry parent) {
        if (parent == null) {
            V8CachingReader.$$$reportNull$$$0(15);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (parent.getChildrenCount() == 0L) {
                return Collections.emptyList();
            }
            ArrayList list = (ArrayList)this.myChildrenMap.get((Object)parent.getId());
            if (list == null) {
                try {
                    list = new ArrayList((int)parent.getChildrenCount());
                    long edgesOffset = parent.getEdgesOffset();
                    ArrayList finalList = list;
                    this.myEdgeReader.read(edgesOffset, (int)parent.getChildrenCount(), (Processor<V8HeapEdge>)((Processor)edge -> {
                        if (this.myShowHidden || !V8HeapGraphEdgeType.kHidden.equals((Object)edge.getType()) && !V8HeapNodeType.kHidden.equals((Object)this.getNode(edge.getToIndex()).getType())) {
                            finalList.add(edge);
                        }
                        return true;
                    }));
                    if (this.myInMemoryIndexes != null) {
                        Collections.sort(list, this.myChildrenComparator);
                    }
                    this.myChildrenMap.put((Object)parent.getId(), list);
                    for (V8HeapEdge edge2 : list) {
                        this.myEdgeMap.put((Object)edge2.getId(), (Object)edge2);
                    }
                }
                catch (IOException e) {
                    this.reportError(e.getMessage());
                    return null;
                }
            }
            return Collections.unmodifiableList(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V8HeapEdge getEdge(long id) {
        Object object = this.myLock;
        synchronized (object) {
            V8HeapEdge edge = (V8HeapEdge)this.myEdgeMap.get((Object)id);
            if (edge != null) {
                return edge;
            }
            try {
                edge = this.myEdgeReader.read(id);
                this.myEdgeMap.put((Object)id, (Object)edge);
            }
            catch (IOException e) {
                this.reportError(e.getMessage());
                return null;
            }
            return edge;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<V8HeapEdge> getParents(@NotNull V8HeapEntry child) {
        if (child == null) {
            V8CachingReader.$$$reportNull$$$0(16);
        }
        Object object = this.myLock;
        synchronized (object) {
            ArrayList edges = (ArrayList)this.myParentsMap.get((Object)child.getId());
            if (edges == null) {
                if (!this.myShowHidden && V8HeapNodeType.kHidden.equals((Object)child.getType())) {
                    return Collections.emptyList();
                }
                try {
                    ArrayList finalEdges = edges = new ArrayList();
                    this.myReverseLinksReader.read(child.getId(), (Processor<V8HeapEdge>)((Processor)edge -> {
                        if (this.myShowHidden || !V8HeapGraphEdgeType.kHidden.equals((Object)edge.getType())) {
                            finalEdges.add(edge);
                        }
                        return true;
                    }));
                    if (this.myInMemoryIndexes != null) {
                        Collections.sort(edges, this.myRetainersComparator);
                    }
                    this.myParentsMap.put((Object)child.getId(), edges);
                }
                catch (IOException e) {
                    this.reportError(e.getMessage());
                    return null;
                }
            }
            return edges;
        }
    }

    public int getRetainersCount(@NotNull V8HeapEntry child) {
        List<V8HeapEdge> parents;
        if (child == null) {
            V8CachingReader.$$$reportNull$$$0(17);
        }
        return (parents = this.getParents(child)) == null ? 0 : parents.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<V8HeapEntry, V8HeapEdge> getRetainerChild(@NotNull V8HeapEntry entry, long idx) {
        if (entry == null) {
            V8CachingReader.$$$reportNull$$$0(18);
        }
        Object object = this.myLock;
        synchronized (object) {
            List<V8HeapEdge> retainers = this.getParents(entry);
            if (retainers == null || (long)retainers.size() <= idx) {
                return Pair.create((Object)V8CachingReader.errorNode(), (Object)this.errorEdge());
            }
            V8HeapEdge edge = retainers.get((int)idx);
            V8HeapEntry node = this.getNode(edge.getFromIndex());
            return Pair.create((Object)node, (Object)edge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<V8HeapEntry, V8HeapEdge> getChildById(@NotNull V8HeapEntry parent, long id) {
        if (parent == null) {
            V8CachingReader.$$$reportNull$$$0(19);
        }
        Object object = this.myLock;
        synchronized (object) {
            List<V8HeapEdge> list = this.getChildren(parent);
            if (list != null) {
                for (V8HeapEdge edge : list) {
                    if (edge.getToIndex() != id) continue;
                    return Pair.create((Object)this.getNode(edge.getToIndex()), (Object)edge);
                }
            }
            return Pair.create((Object)V8CachingReader.errorNode(), (Object)this.errorEdge());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<V8HeapEntry, V8HeapEdge> getChildByLinkId(@NotNull V8HeapEntry parent, long linkId) {
        if (parent == null) {
            V8CachingReader.$$$reportNull$$$0(20);
        }
        Object object = this.myLock;
        synchronized (object) {
            List<V8HeapEdge> list = this.getChildren(parent);
            if (list != null) {
                for (V8HeapEdge edge : list) {
                    if (edge.getId() != linkId) continue;
                    return Pair.create((Object)this.getNode(edge.getToIndex()), (Object)edge);
                }
            }
            return Pair.create((Object)V8CachingReader.errorNode(), (Object)this.errorEdge());
        }
    }

    @NotNull
    private V8HeapEdge errorEdge() {
        V8HeapEdge v8HeapEdge = V8HeapEdge.createFromJson(2, -1L, -1L, -1L);
        if (v8HeapEdge == null) {
            V8CachingReader.$$$reportNull$$$0(21);
        }
        return v8HeapEdge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<V8HeapEntry, V8HeapEdge> getChild(@NotNull V8HeapEntry parent, long idx) {
        if (parent == null) {
            V8CachingReader.$$$reportNull$$$0(22);
        }
        Object object = this.myLock;
        synchronized (object) {
            List<V8HeapEdge> list = this.getChildren(parent);
            if (list == null || (long)list.size() <= idx) {
                return Pair.create((Object)V8CachingReader.errorNode(), (Object)this.errorEdge());
            }
            V8HeapEdge edge = list.get((int)idx);
            V8HeapEntry node = this.getNode(edge.getToIndex());
            return Pair.create((Object)node, (Object)edge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRetainersChildIdx(@NotNull V8HeapEntry child, long parentId) {
        if (child == null) {
            V8CachingReader.$$$reportNull$$$0(23);
        }
        Object object = this.myLock;
        synchronized (object) {
            List<V8HeapEdge> parents = this.getParents(child);
            if (parents != null) {
                for (int i = 0; i < parents.size(); ++i) {
                    V8HeapEdge edge = parents.get(i);
                    if (edge.getFromIndex() != parentId) continue;
                    return i;
                }
            }
            return 0;
        }
    }

    public List<Pair<V8HeapEdge, V8HeapEntry>> getNodesByNameId(long nameId) {
        this.getString(nameId);
        ArrayList<Pair<V8HeapEdge, V8HeapEntry>> result = new ArrayList<Pair<V8HeapEdge, V8HeapEntry>>();
        try {
            this.myReverseStringIndexReader.read(nameId, (Processor<LinkedByNameId>)((Processor)id -> {
                if (id.isNode()) {
                    result.add(Pair.create(null, (Object)this.getNode(id.getId())));
                } else {
                    V8HeapEdge heapEdge = this.getEdge(id.getId());
                    if (heapEdge != null) {
                        V8HeapEntry node = this.getNode(heapEdge.getToIndex());
                        result.add(Pair.create((Object)heapEdge, (Object)node));
                    }
                }
                return true;
            }));
        }
        catch (IOException e) {
            this.reportError(e.getMessage());
            return Collections.emptyList();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildIndex(@NotNull V8HeapEntry parent, long childOffset) {
        if (parent == null) {
            V8CachingReader.$$$reportNull$$$0(24);
        }
        Object object = this.myLock;
        synchronized (object) {
            List<V8HeapEdge> children = this.getChildren(parent);
            if (children != null) {
                for (int i = 0; i < children.size(); ++i) {
                    V8HeapEdge edge = children.get(i);
                    if (edge.getFileOffset() != childOffset) continue;
                    return i;
                }
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(long id) {
        if (id == -1L) {
            return "Error";
        }
        Object object = this.myLock;
        synchronized (object) {
            String name = (String)this.myStringMap.get((Object)id);
            if (name != null) {
                return name;
            }
            try {
                String readString = this.myStringIndex.readString(id);
                this.myStringMap.put((Object)id, (Object)readString);
                return readString;
            }
            catch (IOException e) {
                this.reportError(e.getMessage());
                return "Error";
            }
        }
    }

    public int getNodeParent(int nodeIdx) {
        return this.myInMemoryIndexes.getParents().get(nodeIdx);
    }

    public long getRetainedSize(int nodeIdx) {
        return this.myInMemoryIndexes.getRetainedSizes().get(nodeIdx);
    }

    private void reportError(String message) {
        if (this.myErrorNotificator != null) {
            this.myErrorNotificator.consume((Object)message);
        }
    }

    private static V8HeapEntry errorNode() {
        return V8HeapEntry.createFromJson(V8HeapNodeType.kObject.getNumber(), -1L, -1L, 0L, 0L, 0L, 0L);
    }

    @NotNull
    public V8StringIndex getStringIndex() {
        V8StringIndex v8StringIndex = this.myStringIndex;
        if (v8StringIndex == null) {
            V8CachingReader.$$$reportNull$$$0(25);
        }
        return v8StringIndex;
    }

    public List<Integer> getBiggestObjects() {
        return this.myInMemoryIndexes.getBiggest();
    }

    public int getDistance(int nodexIdx) {
        return this.myInMemoryIndexes.getDistances().get(nodexIdx);
    }

    public void resortChildren() {
        this.myChildrenMap.clear();
        this.myParentsMap.clear();
    }

    public void setAggregatesLinksReaderFactory(LinksReaderFactory<Long> aggregatesLinksReaderFactory) throws FileNotFoundException {
        this.myAggregatesLinksReaderFactory = aggregatesLinksReaderFactory;
        this.myAggregatesLinksReader = this.myResourses.register(this.myAggregatesLinksReaderFactory.create(false));
    }

    public TreeMap<Long, Aggregate> getAggregatesMap() {
        return this.myInMemoryIndexes.getAggregateMap();
    }

    public LinksReaderFactory<Long> getAggregatesLinksReaderFactory() {
        return this.myAggregatesLinksReaderFactory;
    }

    public List<Long> getAggregatesChildren(long aggregateId) {
        ArrayList<Long> ids = (ArrayList<Long>)this.myChildrenByAggregateMap.get((Object)aggregateId);
        if (ids != null) {
            return ids;
        }
        ids = new ArrayList<Long>();
        this.myChildrenByAggregateMap.put((Object)aggregateId, ids);
        try {
            ArrayList<Long> finalIds = ids;
            this.myAggregatesLinksReader.read(aggregateId, (Processor<Long>)((Processor)aLong -> {
                finalIds.add((Long)aLong);
                return true;
            }));
        }
        catch (IOException e) {
            this.reportError(e.getMessage());
            return Collections.emptyList();
        }
        Collections.sort(ids, this.myByRetained);
        return ids;
    }

    @Nullable
    public TreePath translateIntoPathFromNodesChain(Object[] path) {
        V8HeapEntry current = this.myRootNode;
        Object[] resPath = new Object[path.length];
        resPath[0] = new V8HeapContainmentTreeTableModel.NamedEntry(current, "", "", -1L);
        for (int i = 1; i < path.length; ++i) {
            V8HeapContainmentTreeTableModel.NamedEntry namedEntry = (V8HeapContainmentTreeTableModel.NamedEntry)path[i];
            if (!this.myShowHidden && V8HeapNodeType.kHidden.equals((Object)namedEntry.getEntry().getType())) {
                return null;
            }
            Pair<V8HeapEntry, V8HeapEdge> pair = this.getChildByLinkId(current, namedEntry.getLinkOffset() / 37L);
            if (((V8HeapEntry)pair.getFirst()).getSnapshotObjectId() == -1L) {
                return null;
            }
            resPath[i] = new V8HeapContainmentTreeTableModel.NamedEntry((V8HeapEntry)pair.getFirst(), this.getString(((V8HeapEntry)pair.getFirst()).getNameId()), ((V8HeapEdge)pair.getSecond()).getPresentation(this), ((V8HeapEdge)pair.getSecond()).getFileOffset());
            current = (V8HeapEntry)pair.getFirst();
        }
        return new TreePath(resPath);
    }

    public int getNodeCount() {
        return (int)this.myHeader.getNodesCnt();
    }

    public boolean isUnreachable(int id) {
        return this.myInMemoryIndexes.getUnreachable().contains(id);
    }

    public boolean isOnlyWeak(int id) {
        return this.myInMemoryIndexes.getOnlyWeak().contains(id);
    }

    public Flags getFlags() {
        return this.myInMemoryIndexes.getFlags();
    }

    public void resetDoNotShowHidden() {
        this.myShowHidden = false;
        this.myChildrenMap.clear();
        this.myParentsMap.clear();
    }

    public boolean isShowHidden() {
        return this.myShowHidden;
    }

    public boolean isDetached(int nodeIdx) {
        return this.myInMemoryIndexes.getFlags().isDetached(nodeIdx);
    }

    public boolean isReachableFromWindow(V8HeapEntry entry) {
        return V8HeapNodeType.kString.equals((Object)entry.getType()) || V8HeapNodeType.kObject.equals((Object)entry.getType()) && this.myStringsHolder.isWindowString(entry.getNameId()) || this.myInMemoryIndexes.getFlags().isQueriable((int)entry.getId());
    }

    @NotNull
    public V8ImportantStringsHolder getImportantStringsHolder() {
        V8ImportantStringsHolder v8ImportantStringsHolder = this.myStringsHolder;
        if (v8ImportantStringsHolder == null) {
            V8CachingReader.$$$reportNull$$$0(26);
        }
        return v8ImportantStringsHolder;
    }

    public V8HeapInMemoryIndexes getInMemoryIndexes() {
        return this.myInMemoryIndexes;
    }

    public void setInMemoryIndexes(V8HeapInMemoryIndexes inMemoryIndexes) {
        this.myInMemoryIndexes = inMemoryIndexes;
        TreeMap<Long, Aggregate> aggregateMap = this.myInMemoryIndexes.getAggregateMap();
        this.myInMemoryIndexes.sortAggregates((o1, o2) -> {
            Aggregate second = (Aggregate)aggregateMap.get(o2);
            Aggregate first = (Aggregate)aggregateMap.get(o1);
            int bySizes = Long.compare(second.getRetained(), first.getRetained());
            if (bySizes != 0) {
                return bySizes;
            }
            return first.getPresentation(this).compareTo(second.getPresentation(this));
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "digest";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringIndex";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeIndexFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeIndexFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringReverseIndexProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reverseLinkIndexProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringsHolder";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/heap/V8CachingReader";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentId";
                break;
            }
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 16: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/V8CachingReader";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDigest";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringReverseIndexReaderFactory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getReverseLinkIndexReaderFactory";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeIndexFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeIndexFile";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "errorEdge";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringIndex";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportantStringsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: 
            case 25: 
            case 26: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenByNodeId";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getParents";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRetainersCount";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRetainerChild";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getChildById";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getChildByLinkId";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getChild";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getRetainersChildIdx";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getChildIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

