/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.Convertor;
import com.jetbrains.nodejs.run.profile.heap.calculation.PortionProcessor;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawReader;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawWriter;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReaderFactory;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.SizeOffset;
import com.jetbrains.nodejs.util.CloseableThrowableConsumer;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ProcessInPortions<In, Out>
implements Closeable {
    private static final int PORTION_SIZE = 10000;
    @NotNull
    private final RawSerializer<Out> myOutSerializer;
    private final long myPortionSize;
    private long myNodesCnt;
    @NotNull
    private final RawSerializer<In> mySerializer;
    @NotNull
    private final Convertor<? super In, Long> myIndexConvertor;
    @NotNull
    private final Convertor<? super In, ? extends Out> myInOutConvertor;
    private final File myNumLinksFile;
    private final File myLinksFile;
    private final SequentialRawWriter<SizeOffset> myNumLinksWriter;
    private final SequentialRawWriter<Out> myReverseLinksWriter;
    private long myOffset;
    private PairConsumer<Long, Set<Out>> myFilter;

    /*
     * WARNING - void declaration
     */
    public ProcessInPortions(long nodesCnt, long portionSize, @NotNull RawSerializer<In> inSerializer, @NotNull RawSerializer<Out> outSerializer, @NotNull Convertor<? super In, Long> indexConvertor, @NotNull Convertor<? super In, ? extends Out> inOutConvertor, File file, File file2) throws IOException {
        void linksFile;
        void numLinksFile;
        if (inSerializer == null) {
            ProcessInPortions.$$$reportNull$$$0(0);
        }
        if (outSerializer == null) {
            ProcessInPortions.$$$reportNull$$$0(1);
        }
        if (indexConvertor == null) {
            ProcessInPortions.$$$reportNull$$$0(2);
        }
        if (inOutConvertor == null) {
            ProcessInPortions.$$$reportNull$$$0(3);
        }
        this.myOutSerializer = outSerializer;
        this.myNodesCnt = nodesCnt <= 0L ? 10000L : nodesCnt;
        this.mySerializer = inSerializer;
        this.myIndexConvertor = indexConvertor;
        this.myInOutConvertor = inOutConvertor;
        this.myNumLinksFile = numLinksFile;
        this.myLinksFile = linksFile;
        this.myNumLinksWriter = new SequentialRawWriter<SizeOffset>(this.myNumLinksFile, SizeOffset.MySerializer.getInstance());
        this.myReverseLinksWriter = new SequentialRawWriter<Out>(this.myLinksFile, outSerializer);
        this.myPortionSize = portionSize <= 0L ? 10000L : portionSize;
        this.myOffset = 0L;
    }

    public void setFilter(@NotNull PairConsumer<Long, Set<Out>> filter) {
        if (filter == null) {
            ProcessInPortions.$$$reportNull$$$0(4);
        }
        this.myFilter = filter;
    }

    public void correctSize(long value) {
        this.myNodesCnt = value;
    }

    public void continueCalculation(@NotNull File inFile, long size) throws IOException {
        long from;
        if (inFile == null) {
            ProcessInPortions.$$$reportNull$$$0(5);
        }
        int steps = (int)(this.myNodesCnt / this.myPortionSize);
        for (int i = 1; i <= steps && (from = (long)i * this.myPortionSize) < this.myNodesCnt; ++i) {
            long to = from + this.myPortionSize - 1L;
            to = Math.min(to, this.myNodesCnt - 1L);
            new SequentialRawReader<In>(inFile, this.mySerializer, size).iterate(this.getStageCalculator(from, to));
        }
    }

    public void continueCalculation(@NotNull ThrowableConsumer<CloseableThrowableConsumer<In, IOException>, IOException> consumer) throws IOException {
        long from;
        if (consumer == null) {
            ProcessInPortions.$$$reportNull$$$0(6);
        }
        int steps = (int)(this.myNodesCnt / this.myPortionSize);
        for (int i = 1; i <= steps && (from = (long)i * this.myPortionSize) < this.myNodesCnt; ++i) {
            long to = from + this.myPortionSize - 1L;
            to = Math.min(to, this.myNodesCnt - 1L);
            consumer.consume(this.getStageCalculator(from, to));
        }
    }

    public CloseableThrowableConsumer<In, IOException> getFirstStageCalculator() {
        return this.getStageCalculator(0L, Math.min(this.myPortionSize - 1L, this.myNodesCnt - 1L));
    }

    @NotNull
    public CloseableThrowableConsumer<In, IOException> getStageCalculator(long from, long to) {
        final PortionProcessor<In, Out> calculator = new PortionProcessor<In, Out>(from, to, this.myInOutConvertor);
        if (this.myFilter != null) {
            calculator.setFilter(this.myFilter);
        }
        CloseableThrowableConsumer closeableThrowableConsumer = new CloseableThrowableConsumer<In, IOException>(){

            public void consume(In in) throws IOException {
                calculator.accept((Long)ProcessInPortions.this.myIndexConvertor.convert(in), in);
            }

            @Override
            public void close() throws IOException {
                calculator.flush((ThrowableConsumer<Long, IOException>)((ThrowableConsumer)size -> {
                    ProcessInPortions.this.myNumLinksWriter.write(new SizeOffset(size.intValue(), ProcessInPortions.this.myOffset));
                    ProcessInPortions.this.myOffset = ProcessInPortions.this.myOffset + size;
                }), out -> ProcessInPortions.this.myReverseLinksWriter.write(out));
            }
        };
        if (closeableThrowableConsumer == null) {
            ProcessInPortions.$$$reportNull$$$0(7);
        }
        return closeableThrowableConsumer;
    }

    @Override
    public void close() throws IOException {
        this.myNumLinksWriter.close();
        this.myReverseLinksWriter.close();
    }

    public LinksReaderFactory<Out> getLinksReaderFactory() throws FileNotFoundException {
        return new LinksReaderFactory<Out>(this.myOutSerializer, this.myNumLinksFile, this.myLinksFile);
    }

    public File getNumLinksFile() {
        return this.myNumLinksFile;
    }

    public File getLinksFile() {
        return this.myLinksFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inSerializer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outSerializer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexConvertor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inOutConvertor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/heap/calculation/ProcessInPortions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/calculation/ProcessInPortions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStageCalculator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setFilter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "continueCalculation";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

