/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragment;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpWorkaroundUtil {
    private PhpWorkaroundUtil() {
    }

    public static boolean isAssignByReference(@NotNull AssignmentExpression assignmentExpression) {
        PsiElement opBitAnd;
        if (assignmentExpression == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(0);
        }
        if ((opBitAnd = PhpPsiUtil.getChildOfType((PsiElement)assignmentExpression, PhpTokenTypes.opBIT_AND)) == null) {
            PsiElement opAssgn = PhpPsiUtil.getChildOfType((PsiElement)assignmentExpression, PhpTokenTypes.opASGN);
            if (opAssgn != null) {
                return opAssgn.getText().contains("&");
            }
            return false;
        }
        return true;
    }

    public static PhpAccessInstruction.Access getArrayAccess(@NotNull PhpAccessVariableInstruction instruction) {
        ArrayAccessExpression arrayExpression;
        PsiElement anchorParent;
        PhpPsiElement anchor;
        if (instruction == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(1);
        }
        if ((anchor = instruction.getAnchor()) instanceof Variable && (anchorParent = anchor.getParent()) instanceof ArrayAccessExpression && (arrayExpression = (ArrayAccessExpression)anchorParent).getValue() == anchor) {
            ArrayAccessExpression outerArray = PhpPsiUtil.getOuterParentOfType(arrayExpression, ArrayAccessExpression.class);
            PhpAccessInstruction.Access outerArrayAccess = PhpCodeInsightUtil.getAccess((PhpPsiElement)outerArray);
            if (outerArray.getParent() instanceof PhpUnset) {
                return PhpAccessInstruction.Access.UNSET_ACCESS;
            }
            if (!outerArrayAccess.isRead()) {
                return PhpAccessInstruction.Access.WRITE_ACCESS;
            }
        }
        return PhpAccessInstruction.Access.READ_ACCESS;
    }

    public static boolean isReadReference(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(2);
        }
        return PhpPsiUtil.isOfType(PhpPsiUtil.getPrevSiblingIgnoreWhitespace(anchor, true), PhpTokenTypes.opBIT_AND);
    }

    @Nullable
    public static PhpPsiElement getForeachArray(@NotNull ForeachStatement foreachStatement) {
        if (foreachStatement == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(3);
        }
        return PhpWorkaroundUtil.findNextPhpPsiElement(foreachStatement.getFirstChild());
    }

    @Nullable
    public static Variable getForeachKey(@NotNull ForeachStatement foreachStatement) {
        PhpPsiElement array;
        if (foreachStatement == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(4);
        }
        if ((array = PhpWorkaroundUtil.getForeachArray(foreachStatement)) != null) {
            PhpPsiElement v2;
            PhpPsiElement v1 = PhpWorkaroundUtil.getNextPsiSibling(array);
            PhpPsiElement phpPsiElement = v2 = v1 != null ? PhpWorkaroundUtil.getNextPsiSibling(v1) : null;
            if (v2 instanceof Variable && v1 instanceof Variable) {
                return (Variable)v1;
            }
        }
        return null;
    }

    @Nullable
    public static PhpReference getForeachValue(@NotNull ForeachStatement foreachStatement) {
        if (foreachStatement == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(5);
        }
        for (PsiElement lastChild = foreachStatement.getLastChild(); lastChild != null; lastChild = lastChild.getPrevSibling()) {
            if (!(lastChild instanceof PhpReference)) continue;
            return (PhpReference)lastChild;
        }
        return null;
    }

    @Nullable
    public static PhpPsiElement getNextPsiSibling(@NotNull PhpPsiElement psiElement) {
        if (psiElement == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(6);
        }
        return PhpWorkaroundUtil.findNextPhpPsiElement(psiElement.getNextSibling());
    }

    @Nullable
    public static PhpPsiElement findNextPhpPsiElement(@Nullable PsiElement element) {
        for (PsiElement currElement = element; currElement != null; currElement = currElement.getNextSibling()) {
            if (!(currElement.getNode() instanceof CompositeElement)) continue;
            if (currElement instanceof PhpPsiElement) {
                PhpPsiElement phpPsiElement = (PhpPsiElement)currElement;
                if (phpPsiElement instanceof PhpDocComment || PhpPsiUtil.isOfType((PsiElement)phpPsiElement, PhpElementTypes.HTML)) continue;
                return phpPsiElement;
            }
            return null;
        }
        return null;
    }

    public static boolean isIntentionAvailable(@NotNull PsiElement element) {
        if (element == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(7);
        }
        return !(element.getContainingFile() instanceof PhpExpressionCodeFragment) && element.getContainingFile() instanceof PhpFile;
    }

    @Nullable
    public static Parameter getFunctionParameter(@NotNull PsiElement position) {
        PsiElement parent;
        Object ref;
        ParameterList parameterList;
        if (position == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(8);
        }
        if ((parameterList = (ParameterList)PhpPsiUtil.getParentByCondition(position, false, (Condition<? super PsiElement>)ParameterList.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF)) != null && (ref = (parent = parameterList.getParent()) instanceof FunctionReference ? (FunctionReference)parent : (parent instanceof NewExpression ? ((NewExpression)parent).getClassReference() : null)) != null) {
            int index = -1;
            PsiElement[] refParameters = parameterList.getParameters();
            for (int i = 0; i < refParameters.length; ++i) {
                if (!PsiTreeUtil.isAncestor((PsiElement)refParameters[i], (PsiElement)position, (boolean)true)) continue;
                index = i;
                break;
            }
            if (index != -1) {
                for (PhpNamedElement element : ref.resolveGlobal(true)) {
                    Parameter lastParameter;
                    if (!(element instanceof Function)) continue;
                    Parameter[] funcParameters = ((Function)element).getParameters();
                    if (index < funcParameters.length) {
                        return funcParameters[index];
                    }
                    if (funcParameters.length <= 0 || !(lastParameter = funcParameters[funcParameters.length - 1]).isVariadic()) continue;
                    return lastParameter;
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreachStatement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/PhpWorkaroundUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAssignByReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getArrayAccess";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isReadReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getForeachArray";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getForeachKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getForeachValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getNextPsiSibling";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isIntentionAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getFunctionParameter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

