/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.zend.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueModifier;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.zend.connection.ZendDebuggerConnection;
import com.jetbrains.php.debug.zend.debugger.ZendDebuggerValue;
import com.jetbrains.php.debug.zend.debugger.valueModel.ZendDebuggerExpression;
import com.jetbrains.php.debug.zend.debugger.valueModel.ZendDebuggerExpressionValue;
import com.jetbrains.php.debug.zend.handlers.ZendDebuggerResponseHandler;
import com.jetbrains.php.debug.zend.messages.GetStackVarRequest;
import com.jetbrains.php.debug.zend.messages.GetStackVarResponse;
import org.jetbrains.annotations.NotNull;

public class ZendDebuggerStackValue
extends ZendDebuggerValue {
    private final int myStackDepth;

    public ZendDebuggerStackValue(@NotNull PhpDebugProcess<ZendDebuggerConnection> debugProcess, @NotNull ZendDebuggerExpression expression, int stackDepth) {
        if (debugProcess == null) {
            ZendDebuggerStackValue.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            ZendDebuggerStackValue.$$$reportNull$$$0(1);
        }
        super(debugProcess, expression);
        this.myStackDepth = stackDepth;
    }

    @Override
    public XValueModifier getModifier() {
        return null;
    }

    @Override
    public void computeChildren(final @NotNull XCompositeNode node) {
        ZendDebuggerExpressionValue expressionValue;
        if (node == null) {
            ZendDebuggerStackValue.$$$reportNull$$$0(2);
        }
        if ((expressionValue = this.myExpression.getValue()).isFullyLoaded()) {
            XValueChildrenList children = new XValueChildrenList();
            for (ZendDebuggerExpression childExpression : this.myExpression.getValue().getChildren()) {
                children.add(childExpression.getLastName(), (XValue)new ZendDebuggerStackValue(this.myDebugProcess, childExpression, this.myStackDepth));
            }
            node.addChildren(children, true);
        } else {
            ZendDebuggerConnection connection = (ZendDebuggerConnection)this.myDebugProcess.getConnection();
            if (connection == null) {
                node.addChildren(XValueChildrenList.EMPTY, true);
                return;
            }
            connection.send(new GetStackVarRequest(this.myStackDepth, this.myExpression.getPath()), new ZendDebuggerResponseHandler<GetStackVarResponse>(){

                @Override
                public void onSuccessResponse(@NotNull GetStackVarResponse message) {
                    if (message == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String variableContent = message.getVariableContent();
                    Project project = ZendDebuggerStackValue.this.myDebugProcess.getSession().getProject();
                    ZendDebuggerStackValue.this.myExpression.setValue(ZendDebuggerExpressionValue.deserialize(project, ZendDebuggerStackValue.this.myExpression, variableContent.getBytes()));
                    ZendDebuggerStackValue.this.computeChildren(node);
                }

                @Override
                public void onErrorResponse(@NotNull GetStackVarResponse message) {
                    if (message == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    node.setErrorMessage("error");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "message";
                    objectArray2[1] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerStackValue$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onSuccessResponse";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onErrorResponse";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerStackValue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "computeChildren";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

