/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.findUsages;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpCallbackElement;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.refactoring.rename.PhpRenameSearchParameters;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PhpConstructorReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public PhpConstructorReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement refElement;
        if (queryParameters == null) {
            PhpConstructorReferenceSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PhpConstructorReferenceSearcher.$$$reportNull$$$0(1);
        }
        if ((refElement = queryParameters.getElementToSearch()) instanceof PhpClass) {
            if (!(queryParameters instanceof PhpCodeInsightUtil.PhpAliasSearchParameters)) {
                PhpClass clazz = (PhpClass)refElement;
                PhpConstructorReferenceSearcher.searchClassAndChildren(queryParameters, refElement, clazz, new HashSet<PhpClass>());
                PhpConstructorReferenceSearcher.searchForCallbacks(queryParameters, (PhpNamedElement)clazz);
            }
        } else if (refElement instanceof Method) {
            Method method = (Method)refElement;
            if ("__construct".equalsIgnoreCase(method.getName())) {
                PhpClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                PhpConstructorReferenceSearcher.searchClassAndChildren(queryParameters, refElement, containingClass, new HashSet<PhpClass>());
            } else {
                PhpConstructorReferenceSearcher.searchForCallbacks(queryParameters, (PhpNamedElement)method);
            }
        } else if (refElement instanceof PhpCallbackElement) {
            PhpConstructorReferenceSearcher.searchForCallbacks(queryParameters, (PhpNamedElement)((PhpCallbackElement)refElement));
        }
    }

    private static void searchForCallbacks(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull PhpNamedElement refElement) {
        String text;
        if (queryParameters == null) {
            PhpConstructorReferenceSearcher.$$$reportNull$$$0(2);
        }
        if (refElement == null) {
            PhpConstructorReferenceSearcher.$$$reportNull$$$0(3);
        }
        if (StringUtil.isNotEmpty((String)(text = refElement.getName()))) {
            SearchScope searchScope = PhpConstructorReferenceSearcher.getEffectiveSearchScope(queryParameters);
            queryParameters.getOptimizer().searchWord(text, searchScope, (short)4, false, (PsiElement)refElement);
        }
    }

    private static void searchClassAndChildren(ReferencesSearch.SearchParameters queryParameters, PsiElement refElement, PhpClass containingClass, Set<PhpClass> visited) {
        String textToSearch = containingClass.getName();
        if (StringUtil.isEmptyOrSpaces((String)textToSearch)) {
            return;
        }
        SearchScope searchScope = PhpConstructorReferenceSearcher.getEffectiveSearchScope(queryParameters);
        queryParameters.getOptimizer().searchWord(textToSearch, searchScope, (short)1, false, refElement);
        if (!(queryParameters instanceof PhpRenameSearchParameters)) {
            queryParameters.getOptimizer().searchWord("self", searchScope, (short)1, false, refElement);
            queryParameters.getOptimizer().searchWord("parent", searchScope, (short)1, false, refElement);
            queryParameters.getOptimizer().searchWord("static", searchScope, (short)1, false, refElement);
            queryParameters.getOptimizer().searchWord("this", searchScope, (short)1, false, refElement);
        }
        Collection directSubclasses = PhpIndex.getInstance((Project)containingClass.getProject()).getDirectSubclasses(containingClass.getFQN());
        for (PhpClass directSubclass : directSubclasses) {
            if (visited.contains(directSubclass)) continue;
            visited.add(directSubclass);
            if (directSubclass.getOwnConstructor() != null) continue;
            PhpConstructorReferenceSearcher.searchClassAndChildren(queryParameters, refElement, directSubclass, visited);
        }
    }

    static SearchScope getEffectiveSearchScope(ReferencesSearch.SearchParameters queryParameters) {
        SearchScope searchScope = queryParameters.getEffectiveSearchScope();
        if (searchScope instanceof GlobalSearchScope) {
            searchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)searchScope), (FileType[])new FileType[]{PhpFileType.INSTANCE});
        }
        return searchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/findUsages/PhpConstructorReferenceSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processQuery";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "searchForCallbacks";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

