/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.classes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpAddMethodStubsQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpChangeMethodModifiersQuickFix;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class PhpHierarchyChecksInspection
extends PhpInspection {
    private static final PhpAddMethodStubsQuickFix FIX = new PhpAddMethodStubsQuickFix();
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{FIX};

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpClass(PhpClass clazz) {
                for (Method method : clazz.getOwnMethods()) {
                    String name = method.getName();
                    PhpClass containingClass = method.getContainingClass();
                    PsiElement node = method.getNameIdentifier();
                    if (containingClass == null || node == null || name.equalsIgnoreCase(containingClass.getName()) || method instanceof PhpDocMethod) continue;
                    if (method.isStatic() && ("__clone".equalsIgnoreCase(name) || "__construct".equalsIgnoreCase(name) || "__destruct".equalsIgnoreCase(name))) {
                        String text = "__construct".equalsIgnoreCase(name) ? "Constructor cannot be static" : ("__destruct".equalsIgnoreCase(name) ? "Destructor cannot be static" : "Clone method cannot be static");
                        PhpModifier oldMod = method.getModifier();
                        PhpModifier newMod = PhpModifier.instance((PhpModifier.Access)oldMod.getAccess(), (PhpModifier.Abstractness)oldMod.getAbstractness(), (PhpModifier.State)PhpModifier.State.DYNAMIC);
                        holder.registerProblem(node, text, new LocalQuickFix[]{new PhpChangeMethodModifiersQuickFix(containingClass.isInterface() ? null : newMod)});
                    }
                    PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)method, (classMember, superClass, baseClass) -> {
                        String name1;
                        Method superMethod;
                        if (holder == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((superMethod = (Method)classMember) instanceof PhpDocMethod) {
                            return true;
                        }
                        PhpClass superContainingClass = superMethod.getContainingClass();
                        if (superContainingClass == null || superContainingClass.isTrait()) {
                            return true;
                        }
                        String string = name1 = isOnTheFly ? PhpHierarchyChecksInspection.buildSuperName(superMethod, superContainingClass) : null;
                        if (superMethod.isStatic() != method.isStatic()) {
                            holder.registerProblem(node, isOnTheFly ? "Cannot make" + (superMethod.isStatic() ? "" : " non") + " static method " + name1 + (method.isStatic() ? "" : " non") + " static" : "Cannot make static method non static and vice versa", new LocalQuickFix[0]);
                        }
                        if (!baseClass.isInterface() && !baseClass.isTrait() && !superMethod.isAbstract() && method.isAbstract()) {
                            holder.registerProblem(node, isOnTheFly ? "Cannot make non abstract method " + name1 + " abstract" : "Cannot make non abstract method abstract", new LocalQuickFix[0]);
                        }
                        if (superMethod.isFinal()) {
                            holder.registerProblem(node, isOnTheFly ? "Cannot override final method " + name1 : "Cannot override final method ", new LocalQuickFix[0]);
                        }
                        if (!(superMethod.getAccess().getLevel() <= method.getAccess().getLevel() || ("__construct".equals(superMethod.getName()) || "__destruct".equals(superMethod.getName())) && (PhpLangUtil.isObject(superContainingClass) || "__construct".equals(superMethod.getName()) && PhpProjectConfigurationFacade.getInstance(superMethod.getProject()).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP720)))) {
                            holder.registerProblem(node, isOnTheFly ? "Cannot make " + superMethod.getAccess() + " method " + name1 + " " + method.getAccess() : "Cannot make method visibility lower than super's ", new LocalQuickFix[0]);
                        }
                        if (superMethod.isAbstract() && (!"__construct".equalsIgnoreCase(name) || superClass == clazz || baseClass.isInterface())) {
                            Pair<Boolean, Parameter> result = PhpHierarchyChecksInspection.checkDeclarationsCompatibility(superMethod, method);
                            if (!((Boolean)result.first).booleanValue()) {
                                if (isOnTheFly) {
                                    holder.registerProblem(result.second != null ? (PsiElement)result.second : node, "Declaration must be compatible with " + name1, new LocalQuickFix[0]);
                                } else {
                                    holder.registerProblem(result.second != null ? (PsiElement)result.second : node, "Declaration must be compatible with super", new LocalQuickFix[0]);
                                }
                            }
                        }
                        PhpType type = method.getDeclaredType();
                        PhpType superType = superMethod.getDeclaredType();
                        if (!PhpType.intersects((PhpType)PhpType.NULL, (PhpType)type)) {
                            superType = superType.filterNull();
                        }
                        if (!superType.isUndefined() && !PhpHierarchyChecksInspection.returnTypeSuperCompatible(type, superType, holder.getProject())) {
                            PhpReturnType returnType = method.getReturnType();
                            if (isOnTheFly) {
                                holder.registerProblem((PsiElement)(returnType != null ? returnType : node), "Return type declaration must be compatible with " + name1 + " : " + superType.toString(), new LocalQuickFix[0]);
                            } else {
                                holder.registerProblem((PsiElement)(returnType != null ? returnType : node), "Return type declaration must be compatible with super", new LocalQuickFix[0]);
                            }
                        }
                        return true;
                    });
                }
                if (clazz.isAbstract() || clazz.isInterface() || clazz.isTrait()) {
                    return;
                }
                Collection methods = clazz.getMethods();
                ArrayList<Method> abstractMethods = new ArrayList<Method>();
                for (Method method : methods) {
                    if (!method.isAbstract()) continue;
                    abstractMethods.add(method);
                }
                if (abstractMethods.size() > 0) {
                    StringBuilder methodList = new StringBuilder();
                    if (abstractMethods.size() == 1) {
                        methodList.append("method '").append(((Method)abstractMethods.get(0)).getName()).append("'");
                    } else {
                        methodList.append("methods ");
                        Iterator methodIterator = abstractMethods.iterator();
                        while (methodIterator.hasNext()) {
                            Method abstractMethod = (Method)methodIterator.next();
                            methodList.append("'").append(abstractMethod.getName()).append("'");
                            if (!methodIterator.hasNext()) continue;
                            methodList.append(", ");
                        }
                    }
                    PsiElement endNode = clazz.getImplementedInterfaces().length > 0 ? PsiTreeUtil.getChildOfType((PsiElement)clazz, ImplementsList.class) : (clazz.getSuperClass() != null ? PsiTreeUtil.getChildOfType((PsiElement)clazz, ExtendsList.class) : (clazz.getNameNode() != null ? clazz.getNameNode().getPsi() : clazz.getFirstChild()));
                    ProblemDescriptorImpl descriptor = new ProblemDescriptorImpl(clazz.getFirstChild(), endNode, PhpBundle.message("inspection.hierarchyChecks.descr", methodList.toString()), isOnTheFly ? FIXES : LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, isOnTheFly);
                    holder.registerProblem((ProblemDescriptor)descriptor);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$1", "lambda$visitPhpClass$0"));
            }
        };
        if (phpElementVisitor == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    @NotNull
    public static String buildSuperName(@NotNull Method superMethod, @NotNull PhpClass superContainingClass) {
        if (superMethod == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(2);
        }
        if (superContainingClass == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(3);
        }
        String string = PhpPresentationUtil.formatParameters(new StringBuilder().append(superContainingClass.getName()).append(superMethod.isStatic() ? "::" : "->").append(superMethod.getName()), superMethod.getParameters()).toString();
        if (string == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static Pair<Boolean, Parameter> checkDeclarationsCompatibility(Method superMethod, Method method) {
        Parameter lastParameter;
        boolean superVariadic;
        Parameter parameter;
        Parameter[] superParameters;
        if (superMethod.isReturningByReference() && !method.isReturningByReference()) {
            Pair pair = Pair.create((Object)false, null);
            if (pair == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(5);
            }
            return pair;
        }
        Parameter[] parameters = method.getParameters();
        if (parameters.length < (superParameters = superMethod.getParameters()).length) {
            Pair pair = Pair.create((Object)false, null);
            if (pair == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(6);
            }
            return pair;
        }
        int sLength = superParameters.length;
        for (int i = 0; i < sLength; ++i) {
            Parameter superParameter = superParameters[i];
            parameter = parameters[i];
            if (parameter.getName().isEmpty() || superParameter.getName().isEmpty()) {
                Pair pair = Pair.create((Object)false, null);
                if (pair == null) {
                    PhpHierarchyChecksInspection.$$$reportNull$$$0(7);
                }
                return pair;
            }
            if (parameter.isPassByRef() != superParameter.isPassByRef()) {
                Pair pair = Pair.create((Object)false, (Object)parameter);
                if (pair == null) {
                    PhpHierarchyChecksInspection.$$$reportNull$$$0(8);
                }
                return pair;
            }
            if (superParameter.isOptional() && !parameter.isOptional()) {
                Pair pair = Pair.create((Object)false, (Object)parameter);
                if (pair == null) {
                    PhpHierarchyChecksInspection.$$$reportNull$$$0(9);
                }
                return pair;
            }
            if (PhpHierarchyChecksInspection.compatibleByType(parameter, superParameter)) continue;
            Pair pair = Pair.create((Object)false, (Object)parameter);
            if (pair == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(10);
            }
            return pair;
        }
        boolean bl = superVariadic = superParameters.length > 0 && superParameters[superParameters.length - 1].isVariadic();
        if (superVariadic && !(lastParameter = parameters[parameters.length - 1]).isVariadic()) {
            Pair pair = Pair.create((Object)false, (Object)(!lastParameter.getName().isEmpty() ? lastParameter : null));
            if (pair == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(11);
            }
            return pair;
        }
        int sLength2 = parameters.length;
        for (int i = superParameters.length; i < sLength2; ++i) {
            parameter = parameters[i];
            if (parameter.getName().isEmpty()) {
                Pair pair = Pair.create((Object)false, null);
                if (pair == null) {
                    PhpHierarchyChecksInspection.$$$reportNull$$$0(12);
                }
                return pair;
            }
            if (superVariadic && !PhpHierarchyChecksInspection.compatibleByType(parameter, superParameters[superParameters.length - 1])) {
                Pair pair = Pair.create((Object)false, (Object)parameter);
                if (pair == null) {
                    PhpHierarchyChecksInspection.$$$reportNull$$$0(13);
                }
                return pair;
            }
            if (parameter.isOptional() || parameter.isVariadic()) continue;
            Pair pair = Pair.create((Object)false, (Object)parameter);
            if (pair == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(14);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)true, null);
        if (pair == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(15);
        }
        return pair;
    }

    private static boolean compatibleByType(@NotNull Parameter parameter, @NotNull Parameter superParameter) {
        boolean superVariadic;
        boolean variadic;
        if (parameter == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(16);
        }
        if (superParameter == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(17);
        }
        PhpType superType = PhpHierarchyChecksInspection.getParameterType(superParameter);
        PhpType type = PhpHierarchyChecksInspection.getParameterType(parameter);
        if (!PhpType.intersects((PhpType)PhpType.NULL, (PhpType)superType)) {
            type = type.filterNull();
        }
        if ((variadic = parameter.isVariadic()) == (superVariadic = superParameter.isVariadic())) {
            return PhpHierarchyChecksInspection.parameterTypeSuperCompatible(type, superType, parameter.getProject());
        }
        return superVariadic && PhpHierarchyChecksInspection.isVarargExtension(type, superType);
    }

    @NotNull
    private static PhpType getParameterType(@NotNull Parameter parameter) {
        PsiElement defaultValue;
        if (parameter == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(18);
        }
        PhpType type = parameter.getDeclaredType();
        if (PhpProjectConfigurationFacade.getInstance(parameter.getProject()).getLanguageLevel().hasFeature(PhpLanguageFeature.NULLABLES) && (defaultValue = parameter.getDefaultValue()) instanceof ConstantReference && PhpLangUtil.isNull((ConstantReference)defaultValue)) {
            type = new PhpType().add(type).add(PhpType.NULL);
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(19);
        }
        return phpType;
    }

    private static boolean typeSuperCompatible(PhpType type, PhpType superType, Project project) {
        return type.equals((Object)superType) || PhpHierarchyChecksInspection.unwrapAlias(type, project).equals((Object)PhpHierarchyChecksInspection.unwrapAlias(superType, project));
    }

    private static boolean returnTypeSuperCompatible(PhpType type, PhpType superType, Project project) {
        return PhpHierarchyChecksInspection.typeSuperCompatible(type, superType, project) || type.isComplete() && superType.isComplete() && PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel().hasFeature(PhpLanguageFeature.ITERABLE_TYPE_HINT) && ("array".equals(type.toString()) || "\\Traversable".equals(type.toString())) && "iterable".equals(superType.toString());
    }

    private static boolean parameterTypeSuperCompatible(PhpType type, PhpType superType, Project project) {
        return PhpHierarchyChecksInspection.typeSuperCompatible(type, superType, project) || type.isEmpty() && PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP720) || type.isComplete() && superType.isComplete() && PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel().hasFeature(PhpLanguageFeature.ITERABLE_TYPE_HINT) && "iterable".equals(type.toString()) && ("array".equals(superType.toString()) || "\\Traversable".equals(superType.toString()));
    }

    private static PhpType unwrapAlias(@NotNull PhpType type, @NotNull Project project) {
        PhpClass original2;
        PhpClass phpClass;
        Collection classes;
        String fqn;
        if (type == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(20);
        }
        if (project == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(21);
        }
        if (type.isComplete() && type.getTypes().size() == 1 && !PhpType.isPrimitiveType((String)(fqn = (String)ContainerUtil.getFirstItem((Collection)type.getTypes()))) && !PhpType.isPluralType((String)fqn) && (classes = PhpIndex.getInstance((Project)project).getAnyByFQN(fqn)).size() == 1 && (phpClass = (PhpClass)ContainerUtil.getFirstItem((Collection)classes)) instanceof PhpClassAlias && (original2 = ((PhpClassAlias)phpClass).getOriginal()) != null) {
            return original2.getType();
        }
        return type;
    }

    private static boolean isVarargExtension(@NotNull PhpType type, @NotNull PhpType superType) {
        if (type == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(22);
        }
        if (superType == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(23);
        }
        return type.isEmpty() && superType.getTypes().stream().allMatch(PhpType::isArray) || type.equals((Object)superType.unpluralize());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superContainingClass";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superParameter";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSuperName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "checkDeclarationsCompatibility";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildSuperName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "compatibleByType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "unwrapAlias";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isVarargExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

