/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpIllegalStringOffsetInspection
extends PhpInspection {
    private static final String WARNING_KEY = "inspection.illegal.string.offset.problem";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpIllegalStringOffsetInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpArrayAccessExpression(@NotNull ArrayAccessExpression element) {
                PhpPsiElement value;
                ArrayIndex index;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((index = element.getIndex()) != null && !index.getTextRange().isEmpty() && !PhpIllegalStringOffsetInspection.isIntTypeOrAmbiguous((PsiElement)index.getValue()) && PhpIllegalStringOffsetInspection.isStringType((PsiElement)(value = element.getValue()))) {
                    String warning = PhpBundle.message(PhpIllegalStringOffsetInspection.WARNING_KEY, index.getText());
                    holder.registerProblem((PsiElement)index, warning, new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/inspections/type/PhpIllegalStringOffsetInspection$1", "visitPhpArrayAccessExpression"));
            }
        };
        if (phpElementVisitor == null) {
            PhpIllegalStringOffsetInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static boolean isStringType(@Nullable PsiElement value) {
        PhpType valueType;
        if (PhpPsiUtil.isOfType(value, PhpElementTypes.STRING)) {
            return true;
        }
        return value instanceof PhpTypedElement && PhpType.STRING.equals((Object)(valueType = ((PhpTypedElement)value).getType().global(value.getProject()).filterUnknown()));
    }

    private static boolean isIntTypeOrAmbiguous(@Nullable PsiElement index) {
        PhpType valueType;
        if (PhpPsiUtil.isOfType(index, PhpElementTypes.STRING)) {
            return false;
        }
        if (PhpPsiUtil.isOfType(index, PhpElementTypes.NUMBER)) {
            return true;
        }
        return index instanceof PhpTypedElement && (PhpType.intersects((PhpType)(valueType = ((PhpTypedElement)index).getType().global(index.getProject())), (PhpType)PhpType.INT) || valueType.isUndefined() || valueType.hasUnknown());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpIllegalStringOffsetInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpIllegalStringOffsetInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

