/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.PhpInconsistentReturnPointsInspection;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeReturnTypeQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpExtendReturnTypeQuickFix;
import com.jetbrains.php.lang.inspections.type.PhpStrictTypeCheckingInspection;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class PhpIncompatibleReturnTypeInspection
extends PhpInspection {
    public boolean STRICT_TYPE_CHECKING = false;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpIncompatibleReturnTypeInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpReturn(PhpReturn returnStatement) {
                Condition stopAt = Conditions.or((Condition)PhpClass.INSTANCEOF, (Condition)PhpNamespace.INSTANCEOF);
                Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)returnStatement, true, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)stopAt);
                if (function != null) {
                    Project project = returnStatement.getProject();
                    PhpType declaredType = new PhpType().add(function.getDeclaredType()).add(function.getDocType()).globalLocationAware((PsiElement)function);
                    List<PsiElement> arguments = PhpIncompatibleReturnTypeInspection.collectArguments(returnStatement);
                    for (PsiElement argument : arguments) {
                        Object inferredType;
                        if (argument instanceof PhpTypedElement) {
                            inferredType = ((PhpTypedElement)argument).getType().globalLocationAware(argument);
                            if (!PhpIncompatibleReturnTypeInspection.this.STRICT_TYPE_CHECKING) {
                                inferredType = inferredType.filterNull();
                            }
                        } else {
                            inferredType = argument == null ? PhpType.VOID : null;
                        }
                        if (inferredType == null || this.canAccept(project, declaredType, (PhpType)inferredType) || this.isGenerator(function, declaredType)) continue;
                        String ns = function.getNamespaceName();
                        holder.registerProblem((PsiElement)(arguments.size() == 1 || argument == null ? returnStatement : argument), isOnTheFly ? PhpBundle.message("inspection.incompatible.return.type", declaredType.toStringRelativized(ns), inferredType.toStringRelativized(ns)) : PhpBundle.message("inspection.incompatible.return.type.batch", new Object[0]), this.getQuickFixes(function, declaredType, (PhpType)inferredType));
                    }
                }
            }

            private boolean canAccept(@NotNull Project project, @NotNull PhpType declaredType, @NotNull PhpType inferredType) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (declaredType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (inferredType == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (PhpIncompatibleReturnTypeInspection.this.STRICT_TYPE_CHECKING && PhpStrictTypeCheckingInspection.isScalar(declaredType)) {
                    return PhpStrictTypeCheckingInspection.canAccept(declaredType, inferredType);
                }
                return declaredType.isConvertibleFrom(inferredType, PhpIndex.getInstance((Project)project));
            }

            private boolean isGenerator(@NotNull Function function, @NotNull PhpType declaredType) {
                if (function == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (declaredType == null) {
                    1.$$$reportNull$$$0(4);
                }
                return PhpType.intersects((PhpType)PhpInconsistentReturnPointsInspection.GENERATOR_TYPE, (PhpType)declaredType) || PhpType.intersects((PhpType)PhpInconsistentReturnPointsInspection.PROBABLY_GENERATOR_TYPE, (PhpType)declaredType) && PhpType.intersects((PhpType)PhpInconsistentReturnPointsInspection.GENERATOR_TYPE, (PhpType)function.getInferredType());
            }

            private LocalQuickFix[] getQuickFixes(@NotNull Function function, @NotNull PhpType declaredType, @NotNull PhpType inferredType) {
                if (function == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (declaredType == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (inferredType == null) {
                    1.$$$reportNull$$$0(7);
                }
                List fixes = ContainerUtil.newSmartList();
                PhpDocComment phpDoc = function.getDocComment();
                if (phpDoc != null && phpDoc.getReturnTag() != null) {
                    fixes.add(new PhpChangeReturnTypeQuickFix(declaredType, inferredType));
                    fixes.add(new PhpExtendReturnTypeQuickFix(declaredType, new PhpType().add(declaredType).add(inferredType)));
                } else if (inferredType.getTypes().size() == 1) {
                    fixes.add(new PhpChangeReturnTypeQuickFix(declaredType, inferredType));
                }
                return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "declaredType";
                        break;
                    }
                    case 2: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inferredType";
                        break;
                    }
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "function";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpIncompatibleReturnTypeInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canAccept";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isGenerator";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getQuickFixes";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (phpElementVisitor == null) {
            PhpIncompatibleReturnTypeInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    @NotNull
    static List<PsiElement> collectArguments(@NotNull PhpReturn returnStatement) {
        if (returnStatement == null) {
            PhpIncompatibleReturnTypeInspection.$$$reportNull$$$0(2);
        }
        List arguments = ContainerUtil.newSmartList();
        LinkedList expressions = ContainerUtil.newLinkedList((Object[])new PsiElement[]{returnStatement.getArgument()});
        while (!expressions.isEmpty()) {
            PsiElement expression = (PsiElement)expressions.pop();
            if (expression instanceof ParenthesizedExpression) {
                PhpPsiElement unparenthesized = ((ParenthesizedExpression)expression).unparenthesize();
                if (unparenthesized instanceof ParenthesizedExpression) continue;
                expressions.push(unparenthesized);
                continue;
            }
            if (expression instanceof TernaryExpression) {
                expressions.push(((TernaryExpression)expression).getTrueVariant());
                expressions.push(((TernaryExpression)expression).getFalseVariant());
                continue;
            }
            if (PhpPsiUtil.isOfType(expression, PhpElementTypes.COALESCE_EXPRESSION)) {
                expressions.push(((BinaryExpression)expression).getLeftOperand());
                expressions.push(((BinaryExpression)expression).getRightOperand());
                continue;
            }
            arguments.add(expression);
        }
        List list = arguments;
        if (list == null) {
            PhpIncompatibleReturnTypeInspection.$$$reportNull$$$0(3);
        }
        return list;
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpIncompatibleReturnTypeInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpIncompatibleReturnTypeInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectArguments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class OptionsPanel {
        private JPanel myOptionsPanel;
        private JCheckBox myStrictTypeChecking;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myStrictTypeChecking.setSelected(PhpIncompatibleReturnTypeInspection.this.STRICT_TYPE_CHECKING);
            this.myStrictTypeChecking.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpIncompatibleReturnTypeInspection.this.STRICT_TYPE_CHECKING = OptionsPanel.this.myStrictTypeChecking.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JBCheckBox jBCheckBox = new JBCheckBox();
            this.myStrictTypeChecking = jBCheckBox;
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.incompatible.return.type.strict.type.checking"));
            jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

