/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkHelpersManager;
import com.jetbrains.php.config.library.PhpIncludePathManager;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phpunit.PhpUnitConsoleProperties;
import com.jetbrains.php.phpunit.PhpUnitExecutionUtil;
import com.jetbrains.php.phpunit.PhpUnitFrameworkType;
import com.jetbrains.php.phpunit.PhpUnitQualifiedNameLocationProvider;
import com.jetbrains.php.phpunit.PhpUnitRunConfigurationEditor;
import com.jetbrains.php.phpunit.PhpUnitRunConfigurationSettings;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.phpunit.PhpUnitSettingsManager;
import com.jetbrains.php.phpunit.PhpUnitTestPattern;
import com.jetbrains.php.phpunit.PhpUnitTestRunnerConfigurationEditor;
import com.jetbrains.php.phpunit.PhpUnitTestRunnerSettings;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.phpunit.PhpUnitVersion;
import com.jetbrains.php.phpunit.PhpUnitVersionDetector;
import com.jetbrains.php.phpunit.actions.PhpUnitRerunFailedTestsAction;
import com.jetbrains.php.run.PhpRefactoringListenerRunConfiguration;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkVersionCache;
import com.jetbrains.php.testFramework.PhpTestFrameworksConfigurable;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.util.PhpConfigurationUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitLocalRunConfiguration
extends PhpRefactoringListenerRunConfiguration<PhpUnitRunConfigurationSettings>
implements LocatableConfiguration,
SMRunnerConsolePropertiesProvider {
    private static final Logger LOG = Logger.getInstance(PhpUnitLocalRunConfiguration.class);
    private static final String PHPSTORM_PRINTER_OPTION = "--teamcity";

    protected PhpUnitLocalRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @Override
    @NotNull
    protected PhpUnitRunConfigurationSettings createSettings() {
        PhpUnitRunConfigurationSettings phpUnitRunConfigurationSettings = new PhpUnitRunConfigurationSettings();
        if (phpUnitRunConfigurationSettings == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(0);
        }
        return phpUnitRunConfigurationSettings;
    }

    @Override
    protected void fixSettingsAfterDeserialization(@NotNull PhpUnitRunConfigurationSettings settings) {
        if (settings == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(1);
        }
        PhpUnitTestRunnerSettings testRunnerSettings = settings.getTestRunnerSettings();
        testRunnerSettings.setDirectoryPath(PhpConfigurationUtil.deserializePath(testRunnerSettings.getDirectoryPath()));
        testRunnerSettings.setFilePath(PhpConfigurationUtil.deserializePath(testRunnerSettings.getFilePath()));
        testRunnerSettings.setConfigurationFilePath(PhpConfigurationUtil.deserializePath(testRunnerSettings.getConfigurationFilePath()));
    }

    @Override
    protected void fixSettingsBeforeSerialization(@NotNull PhpUnitRunConfigurationSettings settings) {
        if (settings == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(2);
        }
        PhpUnitTestRunnerSettings testRunnerSettings = settings.getTestRunnerSettings();
        testRunnerSettings.setDirectoryPath(PhpConfigurationUtil.serializePath(testRunnerSettings.getDirectoryPath()));
        testRunnerSettings.setFilePath(PhpConfigurationUtil.serializePath(testRunnerSettings.getFilePath()));
        testRunnerSettings.setConfigurationFilePath(PhpConfigurationUtil.serializePath(testRunnerSettings.getConfigurationFilePath()));
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        PhpInterpreter interpreter;
        if (executor == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(3);
        }
        if (env == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(4);
        }
        if ((interpreter = PhpProjectConfigurationFacade.getInstance(this.getProject()).getInterpreter()) == null) {
            throw new ExecutionException(PhpCommandSettingsBuilder.INTERPRETER_NOT_FOUND_ERROR);
        }
        return this.checkAndGetState(env, this.createCommand(interpreter, Collections.emptyMap(), false));
    }

    public RunProfileState checkAndGetState(@NotNull ExecutionEnvironment env, @NotNull PhpCommandSettings command) throws ExecutionException {
        if (env == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(5);
        }
        if (command == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(6);
        }
        try {
            this.checkConfiguration();
        }
        catch (RuntimeConfigurationWarning runtimeConfigurationWarning) {
        }
        catch (RuntimeConfigurationException e) {
            throw new ExecutionException(e.getMessage() + " for " + this.getName() + " run-configuration");
        }
        return this.getState(env, command);
    }

    @NotNull
    public RunProfileState getState(@NotNull ExecutionEnvironment env, final @NotNull PhpCommandSettings command) {
        if (env == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(7);
        }
        if (command == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(8);
        }
        CommandLineState commandLineState = new CommandLineState(env){

            @NotNull
            protected ProcessHandler startProcess() throws ExecutionException {
                ProcessHandler processHandler = PhpUnitLocalRunConfiguration.this.createProcessHandler(PhpUnitLocalRunConfiguration.this.getProject(), command);
                PhpRunUtil.attachProcessOutputDebugDumper(processHandler);
                ProcessTerminatedListener.attach((ProcessHandler)processHandler, (Project)PhpUnitLocalRunConfiguration.this.getProject());
                ProcessHandler processHandler2 = processHandler;
                if (processHandler2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return processHandler2;
            }

            @NotNull
            public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
                if (executor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (runner == null) {
                    1.$$$reportNull$$$0(2);
                }
                ProcessHandler processHandler = this.startProcess();
                PhpUnitConsoleProperties properties = PhpUnitLocalRunConfiguration.this.createTestConsoleProperties(executor, command.getPathProcessor());
                ConsoleView consoleView = PhpUnitExecutionUtil.createConsole(PhpUnitLocalRunConfiguration.this.getProject(), processHandler, properties);
                if (!command.hasInvalidPathArguments()) {
                    PhpUnitLocalRunConfiguration.this.notifyIfTestSuitIsEmpty(PhpUnitLocalRunConfiguration.this.getProject(), consoleView, processHandler);
                }
                DefaultExecutionResult result = new DefaultExecutionResult((ExecutionConsole)consoleView, processHandler);
                PhpUnitRerunFailedTestsAction rerunFailedTestsAction = new PhpUnitRerunFailedTestsAction((ComponentContainer)consoleView, properties);
                rerunFailedTestsAction.setModelProvider(() -> {
                    if (consoleView instanceof SMTRunnerConsoleView) {
                        return ((SMTRunnerConsoleView)consoleView).getResultsViewer();
                    }
                    return null;
                });
                result.setRestartActions(new AnAction[]{rerunFailedTestsAction, new ToggleAutoTestAction()});
                DefaultExecutionResult defaultExecutionResult = result;
                if (defaultExecutionResult == null) {
                    1.$$$reportNull$$$0(3);
                }
                return defaultExecutionResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "runner";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "startProcess";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "execute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "execute";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (commandLineState == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(9);
        }
        return commandLineState;
    }

    public void notifyIfTestSuitIsEmpty(final @NotNull Project project, final @NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        String name;
        PhpUnitSettings phpUnitSettings;
        PhpInterpreter interpreter;
        if (project == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(10);
        }
        if (consoleView == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(11);
        }
        if (processHandler == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(12);
        }
        if (consoleView instanceof SMTRunnerConsoleView && (interpreter = PhpProjectConfigurationFacade.getInstance(project).getInterpreter()) != null && ((phpUnitSettings = PhpUnitLocalRunConfiguration.getPhpUnitSettings(project, name = interpreter.getName(), interpreter.isRemote())) == null || phpUnitSettings.getLoadMethod() == PhpUnitSettings.LoadMethod.INCLUDE_PATH)) {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    SMTestRunnerResultsForm resultViewer;
                    AbstractTestProxy proxy;
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if ((proxy = (resultViewer = ((SMTRunnerConsoleView)consoleView).getResultsViewer()).getRoot()) instanceof SMTestProxy.SMRootTestProxy && ((SMTestProxy.SMRootTestProxy)proxy).isEmptySuite() && !((SMTestProxy.SMRootTestProxy)proxy).isTestsReporterAttached()) {
                        String title = PhpBundle.message("phpunit.not.tests.was.executed.title", new Object[0]);
                        String env = interpreter.isRemote() ? "'" + name + "' interpreter" : "'Local' configuration";
                        String message = PhpBundle.message("phpunit.not.tests.was.executed.message", env);
                        NotificationListener listener = new NotificationListener(){

                            public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                                if (notification2 == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (event == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                    PhpUiUtil.editConfigurable(project, (Configurable)new PhpTestFrameworksConfigurable(project, phpUnitSettings));
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "notification";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "event";
                                        break;
                                    }
                                }
                                objectArray[1] = "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration$2$1";
                                objectArray[2] = "hyperlinkUpdate";
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        };
                        PhpUnitUtil.showWarningBalloon(project, title, message, listener);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration$2", "processTerminated"));
                }
            });
        }
    }

    public PhpUnitConsoleProperties createTestConsoleProperties(Executor executor) {
        PhpRemoteInterpreterManager manager;
        PhpCommandLinePathProcessor pathProcessor = null;
        PhpInterpreter interpreter = PhpProjectConfigurationFacade.getInstance(this.getProject()).getInterpreter();
        if (interpreter != null && interpreter.isRemote() && (manager = PhpRemoteInterpreterManager.getInstance()) != null) {
            try {
                pathProcessor = manager.createPathMapper(this.getProject(), interpreter.getPhpSdkAdditionalData());
            }
            catch (ExecutionException e) {
                LOG.info("Can not detect path mappings for selected interpreter: '" + interpreter.getName() + "'");
            }
        }
        return this.createTestConsoleProperties(executor, pathProcessor == null ? PhpCommandLinePathProcessor.LOCAL : pathProcessor);
    }

    @NotNull
    public PhpUnitConsoleProperties createTestConsoleProperties(Executor executor, @NotNull PhpCommandLinePathProcessor processor) {
        if (processor == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(13);
        }
        PhpPathMapper pathMapper = processor.createPathMapper(this.getProject());
        PhpUnitQualifiedNameLocationProvider locationProvider = PhpUnitQualifiedNameLocationProvider.create(pathMapper);
        PhpUnitConsoleProperties<PhpUnitLocalRunConfiguration> phpUnitConsoleProperties = new PhpUnitConsoleProperties<PhpUnitLocalRunConfiguration>(this, executor, locationProvider, true);
        if (phpUnitConsoleProperties == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(14);
        }
        return phpUnitConsoleProperties;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        Project project = this.getProject();
        PhpUnitRunConfigurationSettings settings = (PhpUnitRunConfigurationSettings)this.getSettings();
        PhpRunUtil.checkCommandLineSettings(project, settings.getCommandLineSettings());
        PhpUnitTestRunnerSettings testRunnerSettings = settings.getTestRunnerSettings();
        PhpInterpreter interpreter = PhpProjectConfigurationFacade.getInstance(project).getInterpreter();
        if (interpreter == null) {
            throw new RuntimeConfigurationError(PhpCommandSettingsBuilder.INTERPRETER_NOT_FOUND_ERROR);
        }
        PhpUnitSettings phpUnitConfiguration = PhpUnitLocalRunConfiguration.getPhpUnitSettings(project, interpreter.getName(), interpreter.isRemote());
        switch (testRunnerSettings.getScope()) {
            case Directory: {
                if (PhpRunUtil.findDirectory(testRunnerSettings.getDirectoryPath()) != null) break;
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid", "Directory"));
            }
            case Class: {
                PsiFile file = PhpRunUtil.findPsiFile(project, testRunnerSettings.getFilePath());
                if (file == null) {
                    throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid", "File"));
                }
                if (DumbService.getInstance((Project)project).isDumb()) break;
                PhpUnitUtil.getAndCheckClass(testRunnerSettings.getClassName(), file, project);
                break;
            }
            case Method: {
                PsiFile file = PhpRunUtil.findPsiFile(project, testRunnerSettings.getFilePath());
                if (file == null) {
                    throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid", "File"));
                }
                if (DumbService.getInstance((Project)project).isDumb()) break;
                PhpClass clazz = PhpUnitUtil.getAndCheckClass(testRunnerSettings.getClassName(), file, project);
                PhpUnitUtil.getAndCheckMethod(testRunnerSettings.getMethodName(), clazz);
                break;
            }
            case XML: {
                if (testRunnerSettings.isUseAlternativeConfigurationFile() || phpUnitConfiguration != null && phpUnitConfiguration.isUseConfigurationFile()) break;
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.press.fix.project.configuration", "Default Configuration file", "PHPUnit"), PhpTestFrameworksConfigurable.createFix(project, PhpUnitFrameworkType.getInstance()));
            }
            case Pattern: {
                if (testRunnerSettings.getTestPatterns().isEmpty()) {
                    throw new RuntimeConfigurationError(PhpBundle.message("validation.test.no.test.patterns", new Object[0]));
                }
                if (PhpRunUtil.findDirectory(testRunnerSettings.getDirectoryPath()) != null || PhpRunUtil.findFile(testRunnerSettings.getFilePath()) != null) break;
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid", "File/Directory"));
            }
        }
        if (testRunnerSettings.isUseAlternativeConfigurationFile()) {
            String configFile = testRunnerSettings.getConfigurationFilePath();
            if (StringUtil.isEmpty((String)configFile)) {
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.path.to.value.should.be.specified", "configuration file", "\"Use alternative configuration file\" field"));
            }
            if (!PhpRunUtil.isValidFilePath(configFile)) {
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.path.to.value.is.invalid", "configuration file", "\"Use alternative configuration file\" field"));
            }
        }
        if (!interpreter.isRemote() && phpUnitConfiguration != null) {
            if (phpUnitConfiguration.isUseConfigurationFile() && !PhpRunUtil.isValidFilePath(phpUnitConfiguration.getConfigurationFilePath())) {
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.path.to.value.is.invalid.press.fix.project.configuration", "configuration file", "\"Default Configuration file\" field", "PHPUnit"), PhpTestFrameworksConfigurable.createFix(project, PhpUnitFrameworkType.getInstance()));
            }
            if (phpUnitConfiguration.isUseBootstrapFile() && !PhpRunUtil.isValidFilePath(phpUnitConfiguration.getBootstrapFilePath())) {
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid.press.fix.project.configuration", "Bootstrap file"), PhpTestFrameworksConfigurable.createFix(project, PhpUnitFrameworkType.getInstance()));
            }
            if (phpUnitConfiguration.getLoadMethod() == PhpUnitSettings.LoadMethod.CUSTOM_LOADER && !PhpRunUtil.isValidFilePath(phpUnitConfiguration.getCustomLoaderPath())) {
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid.press.fix.project.configuration", "Custom loader"), PhpTestFrameworksConfigurable.createFix(project, PhpUnitFrameworkType.getInstance()));
            }
            if (phpUnitConfiguration.getLoadMethod() == PhpUnitSettings.LoadMethod.PHPUNIT_PHAR && !PhpRunUtil.isValidFilePath(phpUnitConfiguration.getPhpUnitPharPath())) {
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid.press.fix.project.configuration", "phpunit.phar"), PhpTestFrameworksConfigurable.createFix(project, PhpUnitFrameworkType.getInstance()));
            }
        }
    }

    @Nullable
    public static PhpUnitSettings getPhpUnitSettings(@NotNull Project project, @NotNull String interpreterName, boolean isRemote) {
        if (project == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(15);
        }
        if (interpreterName == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(16);
        }
        PhpUnitSettingsManager manager = PhpUnitSettingsManager.getInstance(project);
        return isRemote ? manager.getSettingsByName("Interpreter: " + interpreterName) : manager.getLocalSettings();
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        PhpUnitRunConfigurationEditor phpUnitRunConfigurationEditor = new PhpUnitRunConfigurationEditor(this.getProject());
        if (phpUnitRunConfigurationEditor == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(17);
        }
        return phpUnitRunConfigurationEditor;
    }

    public boolean isGeneratedName() {
        return PhpRunUtil.isGeneratedName(this);
    }

    public String suggestedName() {
        PhpUnitTestRunnerSettings testRunnerSettings = ((PhpUnitRunConfigurationSettings)this.getSettings()).getTestRunnerSettings();
        PhpUnitTestRunnerSettings.Scope scope = testRunnerSettings.getScope();
        switch (scope) {
            case Class: {
                return PhpLangUtil.toShortName(StringUtil.notNullize((String)testRunnerSettings.getClassName()));
            }
            case Directory: {
                return PathUtil.getFileName((String)StringUtil.notNullize((String)testRunnerSettings.getDirectoryPath()));
            }
            case Method: {
                String shortName = PhpLangUtil.toShortName(StringUtil.notNullize((String)testRunnerSettings.getClassName()));
                return shortName + "." + StringUtil.notNullize((String)testRunnerSettings.getMethodName());
            }
            case XML: {
                return PathUtil.getFileName((String)StringUtil.notNullize((String)testRunnerSettings.getConfigurationFilePath()));
            }
            case Pattern: {
                List<PhpUnitTestPattern> patterns = testRunnerSettings.getTestPatterns();
                PhpUnitTestPattern firstItem = (PhpUnitTestPattern)ContainerUtil.getFirstItem(patterns);
                if (firstItem == null) {
                    return "Empty pattern";
                }
                StringBuilder result = new StringBuilder();
                if (StringUtil.isNotEmpty((String)firstItem.getMethodName())) {
                    result.append(firstItem.getMethodName());
                } else {
                    result.append(PhpLangUtil.toShortName(firstItem.getClassFqn()));
                }
                if (patterns.size() > 1) {
                    result.append(" and ");
                    result.append(patterns.size() - 1);
                    result.append(" more");
                }
                return result.toString();
            }
        }
        assert (false) : "Unknown scope: " + (Object)((Object)scope);
        return null;
    }

    @Nullable
    public String getActionName() {
        PhpUnitTestRunnerSettings testRunnerSettings = ((PhpUnitRunConfigurationSettings)this.getSettings()).getTestRunnerSettings();
        PhpUnitTestRunnerSettings.Scope scope = testRunnerSettings.getScope();
        if (scope == PhpUnitTestRunnerSettings.Scope.Method && StringUtil.isNotEmpty((String)testRunnerSettings.getMethodName())) {
            String methodName = testRunnerSettings.getMethodName();
            return methodName.length() < 20 ? methodName : methodName.substring(0, 20) + "...";
        }
        return super.getActionName();
    }

    @Nullable
    private static String getWorkingDirectory(@NotNull PhpUnitRunConfigurationSettings settings) {
        PhpUnitTestRunnerSettings testRunnerSettings;
        String configurationFilePath;
        if (settings == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(18);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(configurationFilePath = (testRunnerSettings = settings.getTestRunnerSettings()).getConfigurationFilePath()))) {
            return PathUtil.getParentPath((String)configurationFilePath);
        }
        PhpUnitTestRunnerSettings.Scope scope = testRunnerSettings.getScope();
        switch (scope) {
            case Directory: {
                String directoryPath = testRunnerSettings.getDirectoryPath();
                if (StringUtil.isEmptyOrSpaces((String)directoryPath)) break;
                return PathUtil.getParentPath((String)directoryPath);
            }
            case Class: 
            case Method: {
                String filePath = testRunnerSettings.getFilePath();
                if (StringUtil.isEmptyOrSpaces((String)filePath)) break;
                return PathUtil.getParentPath((String)filePath);
            }
        }
        return null;
    }

    public final PhpCommandSettings createCommand(@NotNull PhpInterpreter interpreter, @NotNull Map<String, String> envParameters, boolean enableDebug) throws ExecutionException {
        if (interpreter == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(19);
        }
        if (envParameters == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(20);
        }
        return this.createCommand(interpreter, (PhpUnitRunConfigurationSettings)this.getSettings(), envParameters, (List<String>)new SmartList(), enableDebug);
    }

    public PhpCommandSettings createCommand(@NotNull PhpInterpreter interpreter, @NotNull PhpUnitRunConfigurationSettings settings, @NotNull Map<String, String> envParameters, @NotNull List<String> arguments, boolean enableDebug) throws ExecutionException {
        if (interpreter == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(21);
        }
        if (settings == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(22);
        }
        if (envParameters == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(23);
        }
        if (arguments == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(24);
        }
        Project project = this.getProject();
        PhpCommandSettings command = new PhpCommandSettingsBuilder(project, interpreter).loadAndStartDebug(enableDebug).build();
        return this.fillTestArguments(interpreter, command, settings, envParameters, arguments);
    }

    @NotNull
    public PhpCommandSettings fillTestArguments(@NotNull PhpInterpreter interpreter, @NotNull PhpCommandSettings command, @NotNull PhpUnitRunConfigurationSettings settings, @NotNull Map<String, String> envParameters, @NotNull List<String> arguments) throws ExecutionException {
        boolean isNewPhpUnit;
        if (interpreter == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(25);
        }
        if (command == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(26);
        }
        if (settings == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(27);
        }
        if (envParameters == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(28);
        }
        if (arguments == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(29);
        }
        Project project = this.getProject();
        PhpUnitSettings phpUnitSettings = PhpUnitLocalRunConfiguration.getPhpUnitSettings(project, interpreter.getName(), command.isRemote());
        String executable = PhpUnitLocalRunConfiguration.findPathToExecutable(phpUnitSettings, interpreter.isRemote());
        PhpUnitVersion version = null;
        if (executable != null) {
            String cachedVersion = PhpTestFrameworkVersionCache.getCache(project, phpUnitSettings);
            if (cachedVersion == null) {
                try {
                    version = (PhpUnitVersion)PhpUnitVersionDetector.getInstance().getVersion(project, interpreter, executable);
                    PhpTestFrameworkVersionCache.setCache(project, phpUnitSettings, version.getVersion());
                }
                catch (ExecutionException e) {
                    LOG.warn("Cannot detect PHPUnit version by " + executable, (Throwable)e);
                }
            } else {
                version = PhpUnitVersion.create(cachedVersion);
            }
        }
        boolean bl = isNewPhpUnit = version != null && version.isAfterPrinterChange();
        if (isNewPhpUnit) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("PHPUnit " + version.getVersion() + " was detected. Execute tests with " + executable);
            }
            command.setScript(executable, false);
        } else {
            String script = PhpUnitLocalRunConfiguration.getPathToScript(project, command);
            if (StringUtil.isEmpty((String)script)) {
                String message = PhpBundle.message("php.interpreter.base.configuration.interpreter.is.invalid", "PHPUnit tests", "PHPUnit");
                throw new ExecutionException(message);
            }
            command.setScript(script, false);
        }
        command.importCommandLineSettings(settings.getCommandLineSettings(), PhpUnitLocalRunConfiguration.getWorkingDirectory(settings));
        if (phpUnitSettings != null) {
            PhpUnitLocalRunConfiguration.fillPhpUnitConfigurationSettings(project, phpUnitSettings, command, version == null ? null : version.getVersion());
        }
        command.addEnvs(envParameters);
        PhpUnitExecutionUtil.fillPhpUnitTestRunnerArguments(project, settings.getTestRunnerSettings(), arguments, command, phpUnitSettings);
        if (isNewPhpUnit) {
            command.addArgument(PHPSTORM_PRINTER_OPTION);
        }
        PhpCommandSettings phpCommandSettings = command;
        if (phpCommandSettings == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(30);
        }
        return phpCommandSettings;
    }

    @Nullable
    private static String findPathToExecutable(@Nullable PhpUnitSettings settings, boolean isRemote) {
        if (settings != null) {
            String loader;
            if (settings.getLoadMethod() == PhpUnitSettings.LoadMethod.PHPUNIT_PHAR) {
                return settings.getPhpUnitPharPath();
            }
            if (settings.getLoadMethod() == PhpUnitSettings.LoadMethod.CUSTOM_LOADER && StringUtil.isNotEmpty((String)(loader = settings.getCustomLoaderPath()))) {
                String directory = PathUtil.getParentPath((String)loader);
                String fullExePath = FileUtil.join((String[])new String[]{directory, "phpunit", "phpunit", "phpunit"});
                if (isRemote) {
                    return FileUtil.toSystemIndependentName((String)fullExePath);
                }
                VirtualFile binary = PhpRunUtil.findFile(fullExePath);
                if (binary == null) {
                    binary = PhpRunUtil.findFile(FileUtil.join((String[])new String[]{directory, "bin", "phpunit"}));
                }
                return binary == null ? null : binary.getPath();
            }
        }
        return null;
    }

    private static void fillPhpUnitConfigurationSettings(@NotNull Project project, @NotNull PhpUnitSettings phpUnitConfiguration, @NotNull PhpCommandSettings command, @Nullable String version) {
        if (project == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(31);
        }
        if (phpUnitConfiguration == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(32);
        }
        if (command == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(33);
        }
        switch (phpUnitConfiguration.getLoadMethod()) {
            case INCLUDE_PATH: {
                String includePath = StringUtil.join(PhpIncludePathManager.getInstance(project).getIncludePath(), (String)File.pathSeparator);
                if (!StringUtil.isNotEmpty((String)includePath)) break;
                command.addEnv("IDE_PHPUNIT_PHPUNIT_INCLUDE", includePath);
                break;
            }
            case CUSTOM_LOADER: {
                command.addEnv("IDE_PHPUNIT_CUSTOM_LOADER", StringUtil.notNullize((String)phpUnitConfiguration.getCustomLoaderPath()));
                break;
            }
            case PHPUNIT_PHAR: {
                String pathToPhar = StringUtil.notNullize((String)phpUnitConfiguration.getPhpUnitPharPath());
                command.addEnv("IDE_PHPUNIT_PHPUNIT_PHAR", pathToPhar);
                if (!StringUtil.isNotEmpty((String)version)) break;
                command.addEnv("IDE_PHPUNIT_VERSION", version);
                break;
            }
        }
    }

    @Nullable
    private static String getPathToScript(@NotNull Project project, @NotNull PhpCommandSettings command) throws ExecutionException {
        if (project == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(34);
        }
        if (command == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(35);
        }
        if (command.isRemote()) {
            PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
            if (manager == null) {
                throw new ExecutionException("Remote interpreter can't be executed. Please enable the PHP Remote Interpreter plugin.");
            }
            try {
                PhpSdkAdditionalData data = command.getAdditionalData();
                assert (data != null);
                return PhpSdkHelpersManager.getHelpersManager(data).getHelperScript(project, "phpunit.php", null);
            }
            catch (InterruptedException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
        return PhpUnitExecutionUtil.getPhpUnitHelperScriptFile().getPath();
    }

    @Override
    @NotNull
    protected List<PhpRefactoringListenerRunConfiguration.PhpRefValue<String>> getPathsToUpdate() {
        List<PhpRefactoringListenerRunConfiguration.PhpRefValue<String>> toUpdate = super.getPathsToUpdate();
        toUpdate.add(new PhpRefactoringListenerRunConfiguration.PhpRefValue<String>(){

            @Override
            @Nullable
            public String getValue() {
                return ((PhpUnitRunConfigurationSettings)PhpUnitLocalRunConfiguration.this.getSettings()).getTestRunnerSettings().getDirectoryPath();
            }

            @Override
            public void setValue(@Nullable String newValue) {
                ((PhpUnitRunConfigurationSettings)PhpUnitLocalRunConfiguration.this.getSettings()).getTestRunnerSettings().setDirectoryPath(newValue);
            }
        });
        toUpdate.add(new PhpRefactoringListenerRunConfiguration.PhpRefValue<String>(){

            @Override
            @Nullable
            public String getValue() {
                return ((PhpUnitRunConfigurationSettings)PhpUnitLocalRunConfiguration.this.getSettings()).getTestRunnerSettings().getFilePath();
            }

            @Override
            public void setValue(@Nullable String newValue) {
                ((PhpUnitRunConfigurationSettings)PhpUnitLocalRunConfiguration.this.getSettings()).getTestRunnerSettings().setFilePath(newValue);
            }
        });
        toUpdate.add(new PhpRefactoringListenerRunConfiguration.PhpRefValue<String>(){

            @Override
            @Nullable
            public String getValue() {
                return ((PhpUnitRunConfigurationSettings)PhpUnitLocalRunConfiguration.this.getSettings()).getTestRunnerSettings().getConfigurationFilePath();
            }

            @Override
            public void setValue(@Nullable String newValue) {
                ((PhpUnitRunConfigurationSettings)PhpUnitLocalRunConfiguration.this.getSettings()).getTestRunnerSettings().setConfigurationFilePath(newValue);
            }
        });
        List<PhpRefactoringListenerRunConfiguration.PhpRefValue<String>> list = toUpdate;
        if (list == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(36);
        }
        return list;
    }

    @Override
    @Nullable
    protected RefactoringElementListener getRefactoringPsiElementListener(@NotNull PsiElement oldElement) {
        if (oldElement == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(37);
        }
        ClassAndMethodData oldCam = PhpUnitLocalRunConfiguration.getClassAndMethodData(oldElement);
        PhpUnitTestRunnerSettings settings = ((PhpUnitRunConfigurationSettings)this.getSettings()).getTestRunnerSettings();
        return oldCam != null && PhpUnitLocalRunConfiguration.getClassAndMethodData(((PhpUnitRunConfigurationSettings)this.getSettings()).getTestRunnerSettings()).stream().anyMatch(settingsCam -> oldCam.equals(settingsCam)) ? new PhpUnitTestElementRenamedListener(oldCam, settings) : null;
    }

    @NotNull
    private static Collection<ClassAndMethodData> getClassAndMethodData(@NotNull PhpUnitTestRunnerSettings settings) {
        PhpUnitTestRunnerSettings.Scope scope;
        if (settings == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(38);
        }
        if ((scope = settings.getScope()) == PhpUnitTestRunnerSettings.Scope.Class) {
            List<ClassAndMethodData> list = Collections.singletonList(new ClassAndMethodData(StringUtil.notNullize((String)settings.getClassName()), null, StringUtil.notNullize((String)settings.getFilePath())));
            if (list == null) {
                PhpUnitLocalRunConfiguration.$$$reportNull$$$0(39);
            }
            return list;
        }
        if (scope == PhpUnitTestRunnerSettings.Scope.Method) {
            List<ClassAndMethodData> list = Collections.singletonList(new ClassAndMethodData(StringUtil.notNullize((String)settings.getClassName()), settings.getMethodName(), StringUtil.notNullize((String)settings.getFilePath())));
            if (list == null) {
                PhpUnitLocalRunConfiguration.$$$reportNull$$$0(40);
            }
            return list;
        }
        if (scope == PhpUnitTestRunnerSettings.Scope.Pattern) {
            List list = ContainerUtil.map(settings.getTestPatterns(), p -> new ClassAndMethodData(p.getClassFqn(), p.getMethodName(), StringUtil.notNullize((String)p.getContainingFileAbsolutePath())));
            if (list == null) {
                PhpUnitLocalRunConfiguration.$$$reportNull$$$0(41);
            }
            return list;
        }
        List<ClassAndMethodData> list = Collections.emptyList();
        if (list == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(42);
        }
        return list;
    }

    @Nullable
    private static ClassAndMethodData getClassAndMethodData(@NotNull PsiElement element) {
        if (element == null) {
            PhpUnitLocalRunConfiguration.$$$reportNull$$$0(43);
        }
        if (!(element instanceof PhpClass) && !(element instanceof Method)) {
            return null;
        }
        PhpClass aClass = element instanceof PhpClass ? (PhpClass)element : ((Method)element).getContainingClass();
        String classFQN = aClass != null ? aClass.getPresentableFQN() : null;
        Method method = element instanceof Method ? (Method)element : null;
        String methodName = method != null ? method.getName() : null;
        return classFQN != null ? new ClassAndMethodData(classFQN, methodName, element.getContainingFile().getVirtualFile().getPresentableUrl()) : null;
    }

    @Override
    protected boolean createRemoteProcessHandlerFromRunner() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 43: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 43: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration";
                break;
            }
            case 1: 
            case 2: 
            case 18: 
            case 22: 
            case 27: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 6: 
            case 8: 
            case 26: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 10: 
            case 15: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterName";
                break;
            }
            case 19: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 20: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envParameters";
                break;
            }
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpUnitConfiguration";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestConsoleProperties";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "fillTestArguments";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToUpdate";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassAndMethodData";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fixSettingsAfterDeserialization";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fixSettingsBeforeSerialization";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkAndGetState";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "notifyIfTestSuitIsEmpty";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPhpUnitSettings";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDirectory";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createCommand";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "fillTestArguments";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "fillPhpUnitConfigurationSettings";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPathToScript";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getRefactoringPsiElementListener";
                break;
            }
            case 38: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getClassAndMethodData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 43: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpUnitTestElementRenamedListener
    extends UndoRefactoringElementAdapter {
        private final ClassAndMethodData myCamBeforeRefactoring;
        private final PhpUnitTestRunnerSettings mySettings;
        @Nullable
        private ClassAndMethodData myCamAfterRefactoring;

        PhpUnitTestElementRenamedListener(ClassAndMethodData camBeforeRefactoring, PhpUnitTestRunnerSettings settings) {
            this.myCamBeforeRefactoring = camBeforeRefactoring;
            this.mySettings = settings;
        }

        protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
            ClassAndMethodData cam;
            boolean isUndoAction;
            if (element == null) {
                PhpUnitTestElementRenamedListener.$$$reportNull$$$0(0);
            }
            boolean bl = isUndoAction = oldQualifiedName != null;
            if (!isUndoAction) {
                this.myCamAfterRefactoring = PhpUnitLocalRunConfiguration.getClassAndMethodData(element);
            }
            ClassAndMethodData oldCam = isUndoAction ? this.myCamAfterRefactoring : this.myCamBeforeRefactoring;
            ClassAndMethodData classAndMethodData = cam = isUndoAction ? this.myCamBeforeRefactoring : this.myCamAfterRefactoring;
            if (cam == null) {
                return;
            }
            this.mySettings.setClassName(cam.getClassName());
            if (cam.getMethodName() != null) {
                this.mySettings.setMethodName(cam.getMethodName());
            }
            if (this.mySettings.getScope() == PhpUnitTestRunnerSettings.Scope.Pattern) {
                boolean customBasePathNotUsed = this.isCustomBasePathNotUsed();
                this.updateTestPatterns(oldCam, cam);
                if (customBasePathNotUsed) {
                    PhpUnitTestRunnerConfigurationEditor.setCommonPath(this.mySettings, PhpUnitTestRunnerConfigurationEditor.getCommonFileOrDirectory(this.mySettings.getTestPatterns()));
                }
            } else {
                this.mySettings.setFilePath(cam.getFilePath());
            }
        }

        private boolean isCustomBasePathNotUsed() {
            VirtualFile common = PhpUnitTestRunnerConfigurationEditor.getCommonFileOrDirectory(this.mySettings.getTestPatterns());
            if (common == null) {
                return false;
            }
            return common.isDirectory() ? FileUtil.pathsEqual((String)common.getPath(), (String)this.mySettings.getDirectoryPath()) : FileUtil.pathsEqual((String)common.getPath(), (String)this.mySettings.getFilePath());
        }

        private void updateTestPatterns(ClassAndMethodData oldCam, ClassAndMethodData newCam) {
            List<PhpUnitTestPattern> testPatterns = this.mySettings.getTestPatterns().stream().map(p -> PhpUnitTestElementRenamedListener.updatePattern(p, oldCam, newCam)).collect(Collectors.toList());
            this.mySettings.setTestPatterns(testPatterns);
        }

        @NotNull
        private static PhpUnitTestPattern updatePattern(@NotNull PhpUnitTestPattern pattern, @NotNull ClassAndMethodData oldCam, @NotNull ClassAndMethodData newCam) {
            if (pattern == null) {
                PhpUnitTestElementRenamedListener.$$$reportNull$$$0(1);
            }
            if (oldCam == null) {
                PhpUnitTestElementRenamedListener.$$$reportNull$$$0(2);
            }
            if (newCam == null) {
                PhpUnitTestElementRenamedListener.$$$reportNull$$$0(3);
            }
            String fqn = StringUtil.equals((CharSequence)pattern.getClassFqn(), (CharSequence)oldCam.getClassName()) ? newCam.getClassName() : pattern.getClassFqn();
            String methodName = StringUtil.equals((CharSequence)pattern.getMethodName(), (CharSequence)oldCam.getMethodName()) ? newCam.getMethodName() : pattern.getMethodName();
            String path = StringUtil.equals((CharSequence)pattern.getContainingFileAbsolutePath(), (CharSequence)oldCam.getFilePath()) ? newCam.getFilePath() : pattern.getContainingFileAbsolutePath();
            PhpUnitTestPattern phpUnitTestPattern = new PhpUnitTestPattern(fqn, methodName, path, pattern.getDataSet());
            if (phpUnitTestPattern == null) {
                PhpUnitTestElementRenamedListener.$$$reportNull$$$0(4);
            }
            return phpUnitTestPattern;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldCam";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newCam";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration$PhpUnitTestElementRenamedListener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration$PhpUnitTestElementRenamedListener";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updatePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "refactored";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "updatePattern";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ClassAndMethodData {
        @NotNull
        private final String myClassFQN;
        @Nullable
        private final String myMethodName;
        @NotNull
        private final String myFilePath;

        ClassAndMethodData(@NotNull String classFQN, @Nullable String methodName, @NotNull String filePath) {
            if (classFQN == null) {
                ClassAndMethodData.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                ClassAndMethodData.$$$reportNull$$$0(1);
            }
            this.myClassFQN = classFQN;
            this.myMethodName = methodName;
            this.myFilePath = filePath;
        }

        @NotNull
        public String getClassName() {
            String string = this.myClassFQN;
            if (string == null) {
                ClassAndMethodData.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public String getMethodName() {
            return this.myMethodName;
        }

        @NotNull
        public String getFilePath() {
            String string = this.myFilePath;
            if (string == null) {
                ClassAndMethodData.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassAndMethodData data = (ClassAndMethodData)o;
            if (!this.myClassFQN.equals(data.myClassFQN)) {
                return false;
            }
            if (this.myMethodName != null && !this.myMethodName.equals(data.myMethodName)) {
                return false;
            }
            return this.myFilePath.equals(data.myFilePath);
        }

        public int hashCode() {
            int result = this.myClassFQN.hashCode();
            result = 31 * result + (this.myMethodName != null ? this.myMethodName.hashCode() : 0);
            result = 31 * result + this.myFilePath.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classFQN";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration$ClassAndMethodData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitLocalRunConfiguration$ClassAndMethodData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

